/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public abstract class ResolverConstraint {
    protected final ResolverBundle bundle;
    protected VersionConstraint constraint;
    private VersionSupplier[] possibleSuppliers;
    private int selectedSupplierIndex = 0;

    ResolverConstraint(ResolverBundle resolverBundle, VersionConstraint versionConstraint) {
        this.bundle = resolverBundle;
        this.constraint = versionConstraint;
    }

    ResolverBundle getBundle() {
        return this.bundle;
    }

    BundleDescription getBundleDescription() {
        return this.bundle.getBundle();
    }

    boolean isFromFragment() {
        return this.constraint.getBundle().getHost() != null;
    }

    boolean isSatisfiedBy(VersionSupplier versionSupplier) {
        if (!this.bundle.getResolver().getPermissionChecker().checkPermission(this.constraint, versionSupplier.getBaseDescription())) {
            return false;
        }
        return this.constraint.isSatisfiedBy(versionSupplier.getBaseDescription());
    }

    VersionConstraint getVersionConstraint() {
        return this.constraint;
    }

    public String getName() {
        return this.constraint.getName();
    }

    public String toString() {
        return this.constraint.toString();
    }

    abstract boolean isOptional();

    public void setPossibleSuppliers(VersionSupplier[] versionSupplierArray) {
        this.possibleSuppliers = versionSupplierArray;
    }

    void addPossibleSupplier(VersionSupplier versionSupplier) {
        if (versionSupplier == null) {
            return;
        }
        if (this.possibleSuppliers == null) {
            this.possibleSuppliers = new VersionSupplier[]{versionSupplier};
            return;
        }
        VersionSupplier[] versionSupplierArray = new VersionSupplier[this.possibleSuppliers.length + 1];
        System.arraycopy(this.possibleSuppliers, 0, versionSupplierArray, 0, this.possibleSuppliers.length);
        versionSupplierArray[this.possibleSuppliers.length] = versionSupplier;
        this.possibleSuppliers = versionSupplierArray;
    }

    int getNumPossibleSuppliers() {
        if (this.possibleSuppliers == null) {
            return 0;
        }
        return this.possibleSuppliers.length;
    }

    VersionSupplier getSelectedSupplier() {
        if (this.possibleSuppliers == null || this.selectedSupplierIndex >= this.possibleSuppliers.length) {
            return null;
        }
        return this.possibleSuppliers[this.selectedSupplierIndex];
    }

    void setSelectedSupplier(int n) {
        this.selectedSupplierIndex = n;
    }

    int getSelectedSupplierIndex() {
        return this.selectedSupplierIndex;
    }

    VersionSupplier[] getPossibleSuppliers() {
        return this.possibleSuppliers;
    }

    void clearPossibleSuppliers() {
        this.possibleSuppliers = null;
        this.selectedSupplierIndex = 0;
    }

    void setVersionConstraint(VersionConstraint versionConstraint) {
        this.constraint = versionConstraint;
    }

    public void removePossibleSupplier(VersionSupplier versionSupplier) {
        if (this.possibleSuppliers == null || versionSupplier == null) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.possibleSuppliers.length) {
            if (this.possibleSuppliers[n2] == versionSupplier) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n >= 0) {
            if (this.possibleSuppliers.length == 1) {
                this.possibleSuppliers = null;
                return;
            }
            VersionSupplier[] versionSupplierArray = new VersionSupplier[this.possibleSuppliers.length - 1];
            System.arraycopy(this.possibleSuppliers, 0, versionSupplierArray, 0, n);
            if (n < this.possibleSuppliers.length - 1) {
                System.arraycopy(this.possibleSuppliers, n + 1, versionSupplierArray, n, this.possibleSuppliers.length - n - 1);
            }
            this.possibleSuppliers = versionSupplierArray;
        }
    }

    boolean selectNextSupplier() {
        if (this.possibleSuppliers == null || this.selectedSupplierIndex >= this.possibleSuppliers.length) {
            return false;
        }
        ++this.selectedSupplierIndex;
        return this.selectedSupplierIndex < this.possibleSuppliers.length;
    }
}

