/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Dictionary;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.internal.baseadaptor.BaseStorage;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;

public class BaseStorage$$Cold {
    public static void bundleChanged(BaseStorage baseStorage, BundleEvent bundleEvent) {
        if (bundleEvent.getType() != 32) {
            return;
        }
        BaseData baseData = (BaseData)((AbstractBundle)bundleEvent.getBundle()).getBundleData();
        try {
            if ((baseData.getType() & 2) != 0) {
                baseStorage.processFrameworkExtension(baseData, (byte)1);
            } else if ((baseData.getType() & 4) != 0) {
                baseStorage.processBootExtension(baseData, (byte)1);
            }
        }
        catch (BundleException bundleException) {}
    }

    public static String copyToTempLibrary(BaseStorage baseStorage, BaseData baseData, String string) {
        File file = baseStorage.getBundleStoreRoot();
        File file2 = new File(file, "libtemp");
        File file3 = new File(string);
        String string2 = file3.getName();
        File file4 = null;
        File file5 = null;
        Long l = new Long(baseData.getBundleID());
        int n = 0;
        while (n < Integer.MAX_VALUE) {
            file4 = new File(file2, String.valueOf(l.toString()) + "_" + new Integer(n).toString());
            file5 = new File(file4, string2);
            if (!file4.exists() || !file5.exists()) break;
            ++n;
        }
        if (!file4.exists()) {
            file4.mkdirs();
            file4.deleteOnExit();
            File file6 = new File(file2, ".delete");
            if (!file6.exists()) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file6);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        FileInputStream fileInputStream = new FileInputStream(file3);
        AdaptorUtil.readFile(fileInputStream, file5);
        BundleFile.setPermissions(file5);
        file5.deleteOnExit();
        return file5.getAbsolutePath();
    }

    public static File getDataFile(BaseStorage baseStorage, BaseData baseData, String string) {
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        if (baseStorageHook == null) {
            return null;
        }
        return baseStorageHook.getDataFile(string);
    }

    public static File getExtractFile(BaseStorage baseStorage, BaseData baseData, String string) {
        File file;
        File file2;
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY);
        if (baseStorageHook == null) {
            return null;
        }
        File file3 = baseStorageHook.getGenerationDir();
        if (file3 != null && (file2 = new File(file3, string)).exists()) {
            return file2;
        }
        file2 = baseStorageHook.getParentGenerationDir();
        if (file2 != null && (file = new File(file2, string)).exists()) {
            return file;
        }
        file = baseStorageHook.createGenerationDir();
        if (file != null && file.exists()) {
            return new File(file, string);
        }
        return null;
    }

    public static void installNativeCode(BaseStorage baseStorage, BaseData baseData, String[] stringArray) {
        BaseStorageHook baseStorageHook;
        if (stringArray.length > 0 && (baseStorageHook = (BaseStorageHook)baseData.getStorageHook(BaseStorageHook.KEY)) != null) {
            baseStorageHook.installNativePaths(stringArray);
        }
    }

    public static void processBootExtension(BaseStorage baseStorage, BundleData bundleData, byte by) {
        throw (Throwable)new BundleException("Boot classpath extensions are not supported.", new UnsupportedOperationException());
    }

    public static void validateExtension(BaseStorage baseStorage, BundleData bundleData) {
        Dictionary dictionary = bundleData.getManifest();
        if (dictionary.get("Import-Package") != null) {
            throw (Throwable)new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_IMPORT_ERROR, bundleData.getLocation()));
        }
        if (dictionary.get("Require-Bundle") != null) {
            throw (Throwable)new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_REQUIRE_ERROR, bundleData.getLocation()));
        }
        if (dictionary.get("Bundle-NativeCode") != null) {
            throw (Throwable)new BundleException(NLS.bind(AdaptorMsg.ADAPTOR_EXTENSION_NATIVECODE_ERROR, bundleData.getLocation()));
        }
    }
}

