/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.internal.baseadaptor.InvalidVersion;
import org.osgi.framework.Version;

public class AdaptorUtil$$Cold {
    public static void copyDir(File file, File file2) {
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            file2.mkdir();
            int n = 0;
            while (n < stringArray.length) {
                File file3 = new File(file, stringArray[n]);
                File file4 = new File(file2, stringArray[n]);
                if (file3.isDirectory()) {
                    AdaptorUtil.copyDir(file3, file4);
                } else {
                    FileInputStream fileInputStream = new FileInputStream(file3);
                    AdaptorUtil.readFile(fileInputStream, file4);
                }
                ++n;
            }
        }
    }

    public static Version loadVersion(DataInputStream dataInputStream) {
        String string = AdaptorUtil.readString(dataInputStream, false);
        try {
            return Version.parseVersion(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new InvalidVersion(string);
        }
    }

    public static void readFile(InputStream inputStream, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            fileOutputStream = null;
            inputStream.close();
            inputStream = null;
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {}
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unable to read file");
                Debug.printStackTrace(iOException);
            }
            throw (Throwable)iOException;
        }
    }

    public static String readString(DataInputStream dataInputStream, boolean bl) {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        return bl ? dataInputStream.readUTF().intern() : dataInputStream.readUTF();
    }

    public static boolean rm(File file) {
        if (file.exists()) {
            String[] stringArray;
            if (file.isDirectory() && (stringArray = file.list()) != null) {
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AdaptorUtil.rm(new File(file, stringArray[n2]));
                    ++n2;
                }
            }
            if (Debug.DEBUG_GENERAL) {
                if (file.isDirectory()) {
                    Debug.println("rmdir " + file.getPath());
                } else {
                    Debug.println("rm " + file.getPath());
                }
            }
            boolean bl = file.delete();
            if (Debug.DEBUG_GENERAL && !bl) {
                Debug.println("  rm failed!!");
            }
            return bl;
        }
        return true;
    }
}

