/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.zip.Checksum;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;

public class ReliableFileOutputStream
extends FilterOutputStream {
    private ReliableFile reliable;
    private Checksum crc;
    private boolean outputOpen = false;

    public ReliableFileOutputStream(File file) throws IOException {
        this(ReliableFile.getReliableFile(file), false);
    }

    public ReliableFileOutputStream(File file, boolean bl) throws IOException {
        this(ReliableFile.getReliableFile(file), bl);
    }

    public ReliableFileOutputStream(String string) throws IOException {
        this(ReliableFile.getReliableFile(string), false);
    }

    public ReliableFileOutputStream(String string, boolean bl) throws IOException {
        this(ReliableFile.getReliableFile(string), bl);
    }

    private ReliableFileOutputStream(ReliableFile reliableFile, boolean bl) throws IOException {
        super(reliableFile.getOutputStream(bl, 0));
        this.reliable = reliableFile;
        this.outputOpen = true;
        this.crc = bl ? reliableFile.getFileChecksum() : reliableFile.getChecksumCalculator();
    }

    public synchronized void close() throws IOException {
        this.closeIntermediateFile();
        this.reliable.closeOutputFile(this.crc);
        this.reliable = null;
    }

    public File closeIntermediateFile() throws IOException {
        if (this.reliable == null) {
            throw (Throwable)new IOException("ReliableFile stream not open");
        }
        if (this.outputOpen) {
            this.reliable.writeChecksumSignature(this.out, this.crc);
            this.out.flush();
            try {
                ((FileOutputStream)this.out).getFD().sync();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.out.close();
            this.outputOpen = false;
        }
        return this.reliable.getOutputFile();
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        this.crc.update((byte)n);
    }

    public void abort() {
        if (this.reliable == null) {
            return;
        }
        if (this.outputOpen) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
            this.outputOpen = false;
        }
        this.reliable.abortOutputFile();
        this.reliable = null;
    }
}

