/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.zip.Checksum;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;

public class ReliableFile$$Cold {
    public static void cp(InputStream inputStream, OutputStream outputStream, int n) {
        try {
            int n2 = inputStream.available();
            n2 = n > n2 ? 0 : (n2 -= n);
            if (n2 > 0) {
                int n3;
                int n4 = n2 > 4096 ? 4096 : n2;
                byte[] byArray = new byte[n4];
                int n5 = 0;
                while ((n3 = inputStream.read(byArray, 0, n2)) > 0) {
                    if (n5 + n3 >= n2) {
                        n3 = n2 - n5;
                    }
                    outputStream.write(byArray, 0, n3);
                    n5 += n3;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            outputStream.close();
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        outputStream.close();
    }

    public static boolean exists(File file) {
        String string = String.valueOf(file.getName()) + '.';
        File file2 = new File(file.getParent());
        int n = string.length();
        String[] stringArray = file2.list();
        if (stringArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith(string)) {
                try {
                    Integer.parseInt(stringArray[n2].substring(n));
                    return true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n2;
        }
        return file.exists();
    }

    public static String[] getBaseFiles(File file) {
        Object object;
        if (!file.isDirectory()) {
            throw (Throwable)new IOException("Not a valid directory");
        }
        String[] stringArray = file.list();
        HashSet<String> hashSet = new HashSet<String>(stringArray.length / 2);
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            int n2 = ((String)object).lastIndexOf(46);
            if (n2 != -1) {
                String string = ((String)object).substring(n2 + 1);
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
                if (n3 != 0) {
                    String string2 = ((String)object).substring(0, n2);
                    hashSet.add(string2);
                }
            }
            ++n;
        }
        stringArray = new String[hashSet.size()];
        n = 0;
        object = hashSet.iterator();
        while (object.hasNext()) {
            stringArray[n++] = (String)object.next();
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getStreamType(ReliableFile reliableFile, InputStream inputStream, Checksum checksum) {
        boolean bl = inputStream.markSupported();
        if (bl) {
            inputStream.mark(inputStream.available());
        }
        try {
            long l;
            int n;
            int n2;
            int n3 = inputStream.available();
            if (n3 < 16) {
                byte[] byArray;
                int n4;
                if (checksum != null && (n4 = inputStream.read(byArray = new byte[16])) > 0) {
                    checksum.update(byArray, 0, n4);
                }
                return 2;
            }
            n3 -= 16;
            int n5 = 0;
            byte[] byArray = new byte[4096];
            while (n5 < n3) {
                n2 = byArray.length;
                if (n5 + n2 > n3) {
                    n2 = n3 - n5;
                }
                if ((n = inputStream.read(byArray, 0, n2)) == -1) {
                    throw (Throwable)new IOException("Unable to read entire file.");
                }
                checksum.update(byArray, 0, n);
                n5 += n;
            }
            n2 = inputStream.read(byArray);
            if (n2 != 16) {
                throw (Throwable)new IOException("Unable to read entire file.");
            }
            n = 0;
            while (n < 4) {
                if (ReliableFile.identifier1[n] != byArray[n]) {
                    checksum.update(byArray, 0, 16);
                    return 2;
                }
                ++n;
            }
            n = 0;
            int n6 = 12;
            while (n < 4) {
                if (ReliableFile.identifier2[n] != byArray[n6]) {
                    checksum.update(byArray, 0, 16);
                    return 2;
                }
                ++n;
                ++n6;
            }
            try {
                l = Long.valueOf(new String(byArray, 4, 8, "UTF-8"), 16);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                l = Long.valueOf(new String(byArray, 4, 8), 16);
            }
            if (l != checksum.getValue()) return 1;
            return 0;
        }
        finally {
            if (bl) {
                inputStream.reset();
            }
        }
    }
}

