/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.StartLevelEvent;
import org.eclipse.osgi.framework.internal.core.StartLevelImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager$$Cold;
import org.eclipse.osgi.framework.internal.core.StartLevelManager$1;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class StartLevelManager
implements EventDispatcher,
EventListener,
ServiceFactory {
    protected static Framework framework;
    protected static EventManager eventManager;
    protected static EventListeners startLevelListeners;
    protected int frameworkBeginningStartLevel = 1;
    protected int initialBundleStartLevel = 1;
    private static int activeSL;
    private static final Object lock;
    private volatile boolean settingStartLevel = false;
    private StartLevelImpl implementation;

    static {
        activeSL = 0;
        lock = new Object();
    }

    protected StartLevelManager(Framework framework) {
        StartLevelManager.framework = framework;
    }

    protected void initialize() {
        this.initialBundleStartLevel = StartLevelManager.framework.adaptor.getInitialBundleStartLevel();
        String string = framework.getProperty("osgi.framework.beginningstartlevel");
        if (string == null) {
            string = "1";
        } else {
            try {
                if (Integer.parseInt(string) <= 0) {
                    System.err.println(NLS.bind(Msg.PROPERTIES_INVALID_FW_STARTLEVEL, "1"));
                    string = "1";
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(NLS.bind(Msg.PROPERTIES_INVALID_FW_STARTLEVEL, "1"));
                string = "1";
            }
        }
        framework.setProperty("osgi.framework.beginningstartlevel", string);
        this.frameworkBeginningStartLevel = Integer.parseInt(string);
        eventManager = new EventManager("Start Level Event Dispatcher");
        startLevelListeners = new EventListeners();
        startLevelListeners.addListener(this, this);
    }

    protected void cleanup() {
        eventManager.close();
        eventManager = null;
        startLevelListeners.removeAllListeners();
        startLevelListeners = null;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public int getFrameworkStartLevel() {
        return this.frameworkBeginningStartLevel;
    }

    public int getStartLevel() {
        return activeSL;
    }

    public void setStartLevel(int n, Bundle bundle) {
        if (n <= 0) {
            throw (Throwable)new IllegalArgumentException(NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, "" + n));
        }
        framework.checkAdminPermission(StartLevelManager.framework.systemBundle, "startlevel");
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("StartLevelImpl: setStartLevel: " + n + "; callerBundle = " + bundle.getBundleId());
        }
        this.issueEvent(new StartLevelEvent(1, n, (AbstractBundle)bundle));
    }

    protected void setStartLevel(int n) {
        this.setStartLevel(n, StartLevelManager.framework.systemBundle);
    }

    protected void launch(int n) {
        this.doSetStartLevel(n, StartLevelManager.framework.systemBundle);
    }

    protected void shutdown() {
        this.doSetStartLevel(0, StartLevelManager.framework.systemBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetStartLevel(int n, AbstractBundle abstractBundle) {
        Object object = lock;
        synchronized (object) {
            this.settingStartLevel = true;
            try {
                int n2 = activeSL;
                if (n > n2) {
                    int n3 = n2;
                    while (n3 < n) {
                        if (Debug.DEBUG_STARTLEVEL) {
                            Debug.println("sync - incrementing Startlevel from " + n2);
                        }
                        ++n2;
                        this.incFWSL(n3 + 1, abstractBundle);
                        ++n3;
                    }
                } else {
                    AbstractBundle[] abstractBundleArray = this.getInstalledBundles(StartLevelManager.framework.bundles, true);
                    int n4 = n2;
                    while (n4 > n) {
                        if (Debug.DEBUG_STARTLEVEL) {
                            Debug.println("sync - decrementing Startlevel from " + n2);
                        }
                        --n2;
                        this.decFWSL(n4 - 1, abstractBundleArray);
                        --n4;
                    }
                }
                framework.publishFrameworkEvent(8, abstractBundle, null);
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("StartLevelImpl: doSetStartLevel: STARTLEVEL_CHANGED event published");
                }
            }
            finally {
                this.settingStartLevel = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveActiveStartLevel(int n) {
        Object object = lock;
        synchronized (object) {
            activeSL = n;
        }
    }

    public void setBundleStartLevel(Bundle bundle, int n) {
        block11: {
            String string = null;
            if (bundle.getBundleId() == 0L) {
                string = Msg.STARTLEVEL_CANT_CHANGE_SYSTEMBUNDLE_STARTLEVEL;
            } else if (bundle.getState() == 1) {
                string = NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation());
            } else if (n <= 0) {
                string = NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, "" + n);
            }
            if (string != null) {
                throw (Throwable)new IllegalArgumentException(string);
            }
            framework.checkAdminPermission(bundle, "execute");
            try {
                if (n == ((AbstractBundle)bundle).getStartLevel()) break block11;
                AbstractBundle abstractBundle = (AbstractBundle)bundle;
                abstractBundle.getBundleData().setStartLevel(n);
                try {
                    AccessController.doPrivileged(new StartLevelManager$1(this, abstractBundle));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getException() instanceof IOException) {
                        throw (Throwable)privilegedActionException.getException();
                    }
                    throw (Throwable)privilegedActionException.getException();
                }
                this.issueEvent(new StartLevelEvent(0, n, (AbstractBundle)bundle));
            }
            catch (IOException iOException) {
                framework.publishFrameworkEvent(2, bundle, iOException);
            }
        }
    }

    private void issueEvent(StartLevelEvent startLevelEvent) {
        ListenerQueue listenerQueue = new ListenerQueue(eventManager);
        listenerQueue.queueListeners(startLevelListeners, this);
        listenerQueue.dispatchEventAsynchronous(startLevelEvent.getType(), startLevelEvent);
    }

    public void dispatchEvent(Object object, Object object2, int n, Object object3) {
        try {
            switch (n) {
                case 0: {
                    this.setBundleSL((StartLevelEvent)object3);
                    break;
                }
                case 1: {
                    this.doSetStartLevel(((StartLevelEvent)object3).getNewSL(), ((StartLevelEvent)object3).getBundle());
                }
            }
        }
        catch (Throwable throwable) {
            StartLevelManager.framework.adaptor.handleRuntimeError(throwable);
        }
    }

    protected void incFWSL(int n, AbstractBundle abstractBundle) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: incFWSL: saving activeSL of " + n);
        }
        this.saveActiveStartLevel(n);
        BundleRepository bundleRepository = StartLevelManager.framework.bundles;
        AbstractBundle[] abstractBundleArray = this.getInstalledBundles(bundleRepository, false);
        if (n == 1) {
            this.loadInstalledBundles(abstractBundleArray);
            this.resumeBundles(abstractBundleArray, true);
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Framework started");
            }
            framework.publishFrameworkEvent(1, abstractBundle, null);
        } else {
            this.resumeBundles(abstractBundleArray, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractBundle[] getInstalledBundles(BundleRepository bundleRepository, boolean bl) {
        Object[] objectArray;
        BundleRepository bundleRepository2 = bundleRepository;
        synchronized (bundleRepository2) {
            List list = bundleRepository.getBundles();
            objectArray = new AbstractBundle[list.size()];
            list.toArray(objectArray);
            Util.sort(objectArray, 0, objectArray.length);
            if (bl) {
                StartLevelManager.sortByDependency((AbstractBundle[])objectArray);
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sortByDependency(AbstractBundle[] abstractBundleArray) {
        BundleRepository bundleRepository = StartLevelManager.framework.bundles;
        synchronized (bundleRepository) {
            if (abstractBundleArray.length <= 1) {
                return;
            }
            int n = abstractBundleArray[0].getStartLevel();
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 < abstractBundleArray.length) {
                if (n != abstractBundleArray[n3].getStartLevel()) {
                    if (bl) {
                        StartLevelManager.sortByDependencies(abstractBundleArray, n2, n3);
                    }
                    n = abstractBundleArray[n3].getStartLevel();
                    n2 = n3;
                    bl = false;
                }
                bl |= (abstractBundleArray[n3].getBundleData().getStatus() & 2) != 0;
                ++n3;
            }
            if (bl) {
                StartLevelManager.sortByDependencies(abstractBundleArray, n2, abstractBundleArray.length);
            }
        }
    }

    private static void sortByDependencies(AbstractBundle[] abstractBundleArray, int n, int n2) {
        if (n2 - n <= 1) {
            return;
        }
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(n2 - n);
        ArrayList<AbstractBundle> arrayList2 = new ArrayList<AbstractBundle>(0);
        int n3 = n;
        while (n3 < n2) {
            BundleDescription bundleDescription = abstractBundleArray[n3].getBundleDescription();
            if (bundleDescription != null) {
                arrayList.add(bundleDescription);
            } else {
                arrayList2.add(abstractBundleArray[n3]);
            }
            ++n3;
        }
        if (arrayList.size() <= 1) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = arrayList.toArray(new BundleDescription[arrayList.size()]);
        StartLevelManager.framework.adaptor.getPlatformAdmin().getStateHelper().sortBundles(bundleDescriptionArray);
        int n4 = n;
        while (n4 < bundleDescriptionArray.length + n) {
            abstractBundleArray[n4] = StartLevelManager.framework.bundles.getBundle(bundleDescriptionArray[n4 - n].getBundleId());
            ++n4;
        }
        if (arrayList2.size() > 0) {
            Iterator iterator = arrayList2.iterator();
            int n5 = n + bundleDescriptionArray.length;
            while (n5 < n2 && iterator.hasNext()) {
                abstractBundleArray[n5] = (AbstractBundle)iterator.next();
                ++n5;
            }
        }
    }

    private void loadInstalledBundles(AbstractBundle[] abstractBundleArray) {
        int n = 0;
        while (n < abstractBundleArray.length) {
            AbstractBundle abstractBundle = abstractBundleArray[n];
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Trying to load bundle " + abstractBundle);
            }
            abstractBundle.load();
            ++n;
        }
    }

    private void resumeBundles(AbstractBundle[] abstractBundleArray, boolean bl) {
        if (bl) {
            try {
                StartLevelManager.framework.systemBundle.state = 8;
                StartLevelManager.framework.systemBundle.context.start();
            }
            catch (BundleException bundleException) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Bundle resume exception: " + bundleException.getMessage());
                    Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
                }
                framework.publishFrameworkEvent(2, StartLevelManager.framework.systemBundle, bundleException);
                throw (Throwable)new RuntimeException(bundleException.getMessage());
            }
        }
        int n = this.getStartLevel();
        int n2 = 0;
        while (n2 < abstractBundleArray.length) {
            int n3 = abstractBundleArray[n2].getStartLevel();
            if (n3 >= n) {
                if (n3 != n) break;
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Active sl = " + n + "; Bundle " + abstractBundleArray[n2].getBundleId() + " sl = " + n3);
                }
                framework.resumeBundle(abstractBundleArray[n2]);
            }
            ++n2;
        }
        StartLevelManager.framework.systemBundle.state = 32;
    }

    protected void decFWSL(int n, AbstractBundle[] abstractBundleArray) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: decFWSL: saving activeSL of " + n);
        }
        this.saveActiveStartLevel(n);
        if (n == 0) {
            this.suspendAllBundles(StartLevelManager.framework.bundles);
            this.unloadAllBundles(StartLevelManager.framework.bundles);
            return;
        }
        int n2 = abstractBundleArray.length - 1;
        while (n2 >= 0) {
            int n3 = abstractBundleArray[n2].getStartLevel();
            if (n3 <= n + 1) {
                if (n3 <= n) break;
                if (abstractBundleArray[n2].isActive()) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("SLL: stopping bundle " + abstractBundleArray[n2].getBundleId());
                    }
                    framework.suspendBundle(abstractBundleArray[n2], false);
                }
            }
            --n2;
        }
    }

    private void suspendAllBundles(BundleRepository bundleRepository) {
        boolean bl;
        do {
            bl = false;
            AbstractBundle[] abstractBundleArray = this.getInstalledBundles(bundleRepository, false);
            int n = abstractBundleArray.length - 1;
            while (n >= 0) {
                AbstractBundle abstractBundle = abstractBundleArray[n];
                if (framework.suspendBundle(abstractBundle, false)) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("SLL: stopped bundle " + abstractBundle.getBundleId());
                    }
                    bl = true;
                }
                --n;
            }
        } while (bl);
        try {
            StartLevelManager.framework.systemBundle.context.stop();
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle suspend exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            framework.publishFrameworkEvent(2, StartLevelManager.framework.systemBundle, bundleException);
        }
        StartLevelManager.framework.systemBundle.state = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllBundles(BundleRepository bundleRepository) {
        BundleRepository bundleRepository2 = bundleRepository;
        synchronized (bundleRepository2) {
            List list = bundleRepository.getBundles();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                AbstractBundle abstractBundle = (AbstractBundle)list.get(n2);
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Trying to unload bundle " + abstractBundle);
                }
                abstractBundle.refresh();
                try {
                    abstractBundle.getBundleData().close();
                }
                catch (IOException iOException) {}
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleSL(StartLevelEvent startLevelEvent) {
        Object object = lock;
        synchronized (object) {
            int n = this.getStartLevel();
            int n2 = startLevelEvent.getNewSL();
            AbstractBundle abstractBundle = startLevelEvent.getBundle();
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.print("SLL: bundle active=" + abstractBundle.isActive());
                Debug.print("; newSL = " + n2);
                Debug.println("; activeSL = " + n);
            }
            if (abstractBundle.isActive() && n2 > n) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: stopping bundle " + abstractBundle.getBundleId());
                }
                framework.suspendBundle(abstractBundle, false);
            } else if (!abstractBundle.isActive() && n2 <= n) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: starting bundle " + abstractBundle.getBundleId());
                }
                framework.resumeBundle(abstractBundle);
            }
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle Startlevel set to " + n2);
            }
        }
    }

    public synchronized Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        if (this.implementation == null) {
            this.implementation = new StartLevelImpl(StartLevelManager.framework.systemBundle, framework);
        }
        return this.implementation;
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object object) {
    }

    public boolean isSettingStartLevel() {
        return this.settingStartLevel;
    }

    public void setInitialBundleStartLevel(int n) throws  {
        StartLevelManager$$Cold.setInitialBundleStartLevel(this, n);
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) throws  {
        return StartLevelManager$$Cold.isBundlePersistentlyStarted(this, bundle);
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle) throws  {
        return StartLevelManager$$Cold.isBundleActivationPolicyUsed(this, bundle);
    }

    public int getBundleStartLevel(Bundle bundle) throws  {
        return StartLevelManager$$Cold.getBundleStartLevel(this, bundle);
    }
}

