/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl$$Cold;
import org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl$Properties;
import org.eclipse.osgi.framework.internal.core.ServiceUse;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration {
    protected ServiceReferenceImpl reference;
    protected Framework framework;
    protected BundleContextImpl context;
    protected AbstractBundle bundle;
    protected ArrayList contextsUsing;
    protected String[] clazzes;
    protected Object service;
    protected ServiceRegistrationImpl$Properties properties;
    protected long serviceid;
    protected int serviceranking;
    protected Object registrationLock = new Object();
    protected int state = 0;
    public static final int REGISTERED = 0;
    public static final int UNREGISTERING = 1;
    public static final int UNREGISTERED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRegistrationImpl(BundleContextImpl bundleContextImpl, String[] stringArray, Object object, Dictionary dictionary) {
        this.context = bundleContextImpl;
        this.bundle = bundleContextImpl.bundle;
        this.framework = bundleContextImpl.framework;
        this.clazzes = stringArray;
        this.service = object;
        this.contextsUsing = null;
        this.reference = new ServiceReferenceImpl(this);
        ServiceRegistry serviceRegistry = this.framework.serviceRegistry;
        synchronized (serviceRegistry) {
            this.serviceid = this.framework.getNextServiceId();
            this.properties = this.createProperties(dictionary);
            if (Debug.DEBUG_SERVICES) {
                Debug.println("registerService[" + this.bundle + "](" + this + ")");
            }
            this.framework.serviceRegistry.publishService(bundleContextImpl, this);
        }
        this.framework.publishServiceEvent(1, this.reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        BundleContextImpl[] bundleContextImplArray;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state != 0) {
                throw (Throwable)new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("unregisterService[" + this.bundle + "](" + this + ")");
            }
            bundleContextImplArray = this.framework.serviceRegistry;
            synchronized (this.framework.serviceRegistry) {
                this.framework.serviceRegistry.unpublishService(this.context, this);
                // ** MonitorExit[var2_3] (shouldn't be in output)
                this.state = 1;
            }
        }
        {
            this.framework.publishServiceEvent(4, this.reference);
            this.service = null;
            this.state = 2;
            int n = 0;
            bundleContextImplArray = null;
            Object object2 = this.registrationLock;
            synchronized (object2) {
                if (this.contextsUsing != null && (n = this.contextsUsing.size()) > 0) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println("unregisterService: releasing users");
                    }
                    bundleContextImplArray = this.contextsUsing.toArray(new BundleContextImpl[n]);
                }
            }
            int n2 = 0;
            while (n2 < n) {
                this.releaseService(bundleContextImplArray[n2]);
                ++n2;
            }
            this.contextsUsing = null;
            this.reference = null;
            this.context = null;
            return;
        }
    }

    public ServiceReference getReference() {
        if (this.reference == null) {
            throw (Throwable)new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
        }
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary dictionary) {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state != 0) {
                throw (Throwable)new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            this.properties = this.createProperties(dictionary);
        }
        this.framework.publishServiceEvent(2, this.reference);
    }

    protected ServiceRegistrationImpl$Properties createProperties(Dictionary dictionary) {
        ServiceRegistrationImpl$Properties serviceRegistrationImpl$Properties = new ServiceRegistrationImpl$Properties(dictionary);
        serviceRegistrationImpl$Properties.set("objectClass", this.clazzes, true);
        serviceRegistrationImpl$Properties.set("service.id", new Long(this.serviceid), true);
        serviceRegistrationImpl$Properties.setReadOnly();
        Object object = serviceRegistrationImpl$Properties.getProperty("service.ranking");
        this.serviceranking = object instanceof Integer ? (Integer)object : 0;
        return serviceRegistrationImpl$Properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getProperty(String string) {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getProperty(string);
        }
    }

    protected AbstractBundle getBundle() {
        if (this.reference == null) {
            return null;
        }
        return this.bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getService(BundleContextImpl bundleContextImpl) {
        Object object = this.registrationLock;
        synchronized (object) {
            Hashtable hashtable;
            ServiceUse serviceUse;
            block8: {
                if (this.state != 2) break block8;
                return null;
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getService[" + bundleContextImpl.bundle + "](" + this + ")");
            }
            if ((serviceUse = (ServiceUse)(hashtable = bundleContextImpl.servicesInUse).get(this.reference)) == null) {
                serviceUse = new ServiceUse(bundleContextImpl, this);
                Object object2 = serviceUse.getService();
                if (object2 != null) {
                    hashtable.put(this.reference, serviceUse);
                    if (this.contextsUsing == null) {
                        this.contextsUsing = new ArrayList(10);
                    }
                    this.contextsUsing.add(bundleContextImpl);
                }
                return object2;
            }
            return serviceUse.getService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ungetService(BundleContextImpl bundleContextImpl) {
        Object object = this.registrationLock;
        synchronized (object) {
            block8: {
                ServiceUse serviceUse;
                Object object2;
                block7: {
                    if (this.state != 2) break block7;
                    return false;
                }
                if (Debug.DEBUG_SERVICES) {
                    object2 = bundleContextImpl.bundle == null ? "" : bundleContextImpl.bundle.toString();
                    Debug.println("ungetService[" + (String)object2 + "](" + this + ")");
                }
                if ((object2 = bundleContextImpl.servicesInUse) == null || (serviceUse = (ServiceUse)((Hashtable)object2).get(this.reference)) == null) break block8;
                if (serviceUse.ungetService()) {
                    ((Hashtable)object2).remove(this.reference);
                    this.contextsUsing.remove(bundleContextImpl);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseService(BundleContextImpl bundleContextImpl) {
        Object object = this.registrationLock;
        synchronized (object) {
            ServiceUse serviceUse;
            Object object2;
            if (this.reference == null) {
                return;
            }
            if (Debug.DEBUG_SERVICES) {
                object2 = bundleContextImpl.bundle == null ? "" : bundleContextImpl.bundle.toString();
                Debug.println("releaseService[" + (String)object2 + "](" + this + ")");
            }
            if ((object2 = bundleContextImpl.servicesInUse) != null && (serviceUse = (ServiceUse)((Hashtable)object2).remove(this.reference)) != null) {
                serviceUse.releaseService();
                if (this.contextsUsing != null) {
                    this.contextsUsing.remove(bundleContextImpl);
                }
            }
        }
    }

    protected String[] getPropertyKeys() throws  {
        return ServiceRegistrationImpl$$Cold.getPropertyKeys(this);
    }

    protected AbstractBundle[] getUsingBundles() throws  {
        return ServiceRegistrationImpl$$Cold.getUsingBundles(this);
    }

    public String toString() throws  {
        return ServiceRegistrationImpl$$Cold.toString(this);
    }
}

