/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;

public class SecurePermissionStorage
implements PermissionStorage,
PrivilegedExceptionAction {
    private PermissionStorage storage;
    private String location;
    private String[] data;
    private String[] infos;
    private int action;
    private static final int GET = 1;
    private static final int SET = 2;
    private static final int LOCATION = 3;
    private static final int GET_INFOS = 4;
    private static final int SAVE_INFOS = 5;

    public SecurePermissionStorage(PermissionStorage permissionStorage) {
        this.storage = permissionStorage;
    }

    public Object run() throws IOException {
        switch (this.action) {
            case 1: {
                return this.storage.getPermissionData(this.location);
            }
            case 2: {
                this.storage.setPermissionData(this.location, this.data);
                return null;
            }
            case 3: {
                return this.storage.getLocations();
            }
            case 5: {
                this.storage.saveConditionalPermissionInfos(this.infos);
                return null;
            }
            case 4: {
                return this.storage.getConditionalPermissionInfos();
            }
        }
        throw (Throwable)new UnsupportedOperationException();
    }

    public String[] getPermissionData(String string) throws IOException {
        this.location = string;
        this.action = 1;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public String[] getLocations() throws IOException {
        this.action = 3;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public void setPermissionData(String string, String[] stringArray) throws IOException {
        this.location = string;
        this.data = stringArray;
        this.action = 2;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public void saveConditionalPermissionInfos(String[] stringArray) throws IOException {
        this.action = 5;
        this.infos = stringArray;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)privilegedActionException.getException();
        }
    }

    public String[] getConditionalPermissionInfos() throws IOException {
        this.action = 4;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Throwable)privilegedActionException.getException();
        }
    }
}

