/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.FilterImpl$$Cold;
import org.eclipse.osgi.framework.internal.core.FilterImpl$Parser;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterImpl
implements Filter {
    protected int operation;
    protected static final int EQUAL = 1;
    protected static final int APPROX = 2;
    protected static final int GREATER = 3;
    protected static final int LESS = 4;
    protected static final int PRESENT = 5;
    protected static final int SUBSTRING = 6;
    protected static final int AND = 7;
    protected static final int OR = 8;
    protected static final int NOT = 9;
    protected String attr;
    protected Object value;
    protected String filter;
    protected boolean topLevel;
    protected static final Class[] constructorType;
    static Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        classArray[0] = clazz;
        constructorType = classArray;
    }

    public FilterImpl(String string) throws InvalidSyntaxException {
        this.topLevel = true;
        new FilterImpl$Parser(string).parse(this);
    }

    public boolean match(ServiceReference serviceReference) {
        return this.match0(((ServiceReferenceImpl)serviceReference).registration.properties);
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.match0(dictionary);
    }

    public String toString() {
        if (this.filter == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            switch (this.operation) {
                case 7: {
                    stringBuffer.append('&');
                    FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        stringBuffer.append(filterImplArray[n2].toString());
                        ++n2;
                    }
                    break;
                }
                case 8: {
                    stringBuffer.append('|');
                    FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                    int n = filterImplArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        stringBuffer.append(filterImplArray[n3].toString());
                        ++n3;
                    }
                    break;
                }
                case 9: {
                    stringBuffer.append('!');
                    stringBuffer.append(this.value.toString());
                    break;
                }
                case 6: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append('=');
                    String[] stringArray = (String[])this.value;
                    int n = stringArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String string = stringArray[n4];
                        if (string == null) {
                            stringBuffer.append('*');
                        } else {
                            stringBuffer.append(FilterImpl.encodeValue(string));
                        }
                        ++n4;
                    }
                    break;
                }
                case 1: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append('=');
                    stringBuffer.append(FilterImpl.encodeValue(this.value.toString()));
                    break;
                }
                case 3: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append(">=");
                    stringBuffer.append(FilterImpl.encodeValue(this.value.toString()));
                    break;
                }
                case 4: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append("<=");
                    stringBuffer.append(FilterImpl.encodeValue(this.value.toString()));
                    break;
                }
                case 2: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append("~=");
                    stringBuffer.append(FilterImpl.encodeValue(FilterImpl.approxString(this.value.toString())));
                    break;
                }
                case 5: {
                    stringBuffer.append(this.attr);
                    stringBuffer.append("=*");
                }
            }
            stringBuffer.append(')');
            if (this.topLevel) {
                this.filter = stringBuffer.toString();
            } else {
                return stringBuffer.toString();
            }
        }
        return this.filter;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected FilterImpl() {
        this.topLevel = false;
    }

    protected void setFilter(int n, String string, Object object) {
        this.operation = n;
        this.attr = string;
        this.value = object;
    }

    protected boolean match(ServiceReferenceImpl serviceReferenceImpl) {
        return this.match0(serviceReferenceImpl.registration.properties);
    }

    protected boolean match0(Dictionary dictionary) {
        switch (this.operation) {
            case 7: {
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (!filterImplArray[n2].match0(dictionary)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            case 8: {
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = filterImplArray.length;
                int n3 = 0;
                while (n3 < n) {
                    if (filterImplArray[n3].match0(dictionary)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            case 9: {
                FilterImpl filterImpl = (FilterImpl)this.value;
                return !filterImpl.match0(dictionary);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                Object var2_5 = dictionary == null ? null : dictionary.get(this.attr);
                return this.compare(this.operation, var2_5, this.value);
            }
            case 5: {
                Object var2_6;
                if (Debug.DEBUG_FILTER) {
                    Debug.println("PRESENT(" + this.attr + ")");
                }
                Object v0 = var2_6 = dictionary == null ? null : dictionary.get(this.attr);
                return var2_6 != null;
            }
        }
        return false;
    }

    protected static String encodeValue(String string) {
        boolean bl = false;
        int n = string.length();
        int n2 = n << 1;
        char[] cArray = new char[n2];
        string.getChars(0, n, cArray, n);
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c = cArray[n4];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    cArray[n3] = 92;
                    ++n3;
                    bl = true;
                }
            }
            cArray[n3] = c;
            ++n3;
            ++n4;
        }
        return bl ? new String(cArray, 0, n3) : string;
    }

    protected boolean compare(int n, Object object, Object object2) {
        if (object == null) {
            if (Debug.DEBUG_FILTER) {
                Debug.println("compare(" + object + "," + object2 + ")");
            }
            return false;
        }
        if (object instanceof String) {
            return this.compare_String(n, (String)object, object2);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                return this.compare_PrimitiveArray(n, clazz2, object, object2);
            }
            return this.compare_ObjectArray(n, (Object[])object, object2);
        }
        if (object instanceof Collection) {
            return this.compare_Collection(n, (Collection)object, object2);
        }
        if (object instanceof Integer) {
            return this.compare_Integer(n, (Integer)object, object2);
        }
        if (object instanceof Long) {
            return this.compare_Long(n, (Long)object, object2);
        }
        if (object instanceof Byte) {
            return this.compare_Byte(n, (Byte)object, object2);
        }
        if (object instanceof Short) {
            return this.compare_Short(n, (Short)object, object2);
        }
        if (object instanceof Character) {
            return this.compare_Character(n, ((Character)object).charValue(), object2);
        }
        if (object instanceof Float) {
            return this.compare_Float(n, ((Float)object).floatValue(), object2);
        }
        if (object instanceof Double) {
            return this.compare_Double(n, (Double)object, object2);
        }
        if (object instanceof Boolean) {
            return this.compare_Boolean(n, (Boolean)object, object2);
        }
        if (object instanceof Comparable) {
            return this.compare_Comparable(n, (Comparable)object, object2);
        }
        return this.compare_Unknown(n, object, object2);
    }

    protected boolean compare_ObjectArray(int n, Object[] objectArray, Object object) {
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.compare(n, objectArray[n3], object)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean compare_String(int n, String string, Object object) {
        switch (n) {
            case 6: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("SUBSTRING(" + string + "," + object + ")");
                }
                String[] stringArray = (String[])object;
                int n2 = 0;
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string2 = stringArray[n4];
                    if (n4 + 1 < n3) {
                        if (string2 == null) {
                            String string3 = stringArray[n4 + 1];
                            if (string3 != null) {
                                int n5;
                                if (Debug.DEBUG_FILTER) {
                                    Debug.println("indexOf(\"" + string3 + "\"," + n2 + ")");
                                }
                                if ((n5 = string.indexOf(string3, n2)) == -1) {
                                    return false;
                                }
                                n2 = n5 + string3.length();
                                if (n4 + 2 < n3) {
                                    ++n4;
                                }
                            }
                        } else {
                            int n6 = string2.length();
                            if (Debug.DEBUG_FILTER) {
                                Debug.println("regionMatches(" + n2 + ",\"" + string2 + "\")");
                            }
                            if (!string.regionMatches(n2, string2, 0, n6)) return false;
                            n2 += n6;
                        }
                    } else {
                        if (string2 == null) {
                            return true;
                        }
                        if (!Debug.DEBUG_FILTER) return string.endsWith(string2);
                        Debug.println("regionMatches(" + n2 + "," + string2 + ")");
                        return string.endsWith(string2);
                    }
                    ++n4;
                }
                return true;
            }
            case 1: {
                if (!Debug.DEBUG_FILTER) return string.equals(object);
                Debug.println("EQUAL(" + string + "," + object + ")");
                return string.equals(object);
            }
            case 2: {
                if (Debug.DEBUG_FILTER) {
                    Debug.println("APPROX(" + string + "," + object + ")");
                }
                string = FilterImpl.approxString(string);
                String string4 = FilterImpl.approxString((String)object);
                return string.equalsIgnoreCase(string4);
            }
            case 3: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)object) >= 0;
                Debug.println("GREATER(" + string + "," + object + ")");
                return string.compareTo((String)object) >= 0;
            }
            case 4: {
                if (!Debug.DEBUG_FILTER) return string.compareTo((String)object) <= 0;
                Debug.println("LESS(" + string + "," + object + ")");
                return string.compareTo((String)object) <= 0;
            }
        }
        return false;
    }

    public String getRequiredObjectClass() {
        switch (this.operation) {
            case 1: {
                if (!this.attr.equalsIgnoreCase("objectClass") || !(this.value instanceof String)) break;
                return (String)this.value;
            }
            case 7: {
                FilterImpl[] filterImplArray = (FilterImpl[])this.value;
                int n = 0;
                while (n < filterImplArray.length) {
                    String string;
                    if (filterImplArray[n].operation == 1 && (string = filterImplArray[n].getRequiredObjectClass()) != null) {
                        return string;
                    }
                    ++n;
                }
                break;
            }
        }
        return null;
    }

    public static String getObjectClassFilterString(String string) {
        if (string == null) {
            return null;
        }
        return "(objectClass=" + string + ")";
    }

    public String[] getAttributes() {
        ArrayList arrayList = new ArrayList();
        this.getAttributesInternal(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void getAttributesInternal(ArrayList arrayList) {
        if (this.value instanceof FilterImpl[]) {
            FilterImpl[] filterImplArray = (FilterImpl[])this.value;
            int n = 0;
            while (n < filterImplArray.length) {
                filterImplArray[n].getAttributesInternal(arrayList);
                ++n;
            }
            return;
        }
        if (this.value instanceof FilterImpl) {
            ((FilterImpl)this.value).getAttributesInternal(arrayList);
            return;
        }
        if (this.attr != null) {
            arrayList.add(this.attr);
        }
    }

    public boolean match(Dictionary dictionary) throws  {
        return FilterImpl$$Cold.match(this, dictionary);
    }

    public boolean equals(Object object) throws  {
        return FilterImpl$$Cold.equals(this, object);
    }

    protected boolean compare_Collection(int n, Collection collection, Object object) throws  {
        return FilterImpl$$Cold.compare_Collection(this, n, collection, object);
    }

    protected boolean compare_PrimitiveArray(int n, Class clazz, Object object, Object object2) throws  {
        return FilterImpl$$Cold.compare_PrimitiveArray(this, n, clazz, object, object2);
    }

    protected boolean compare_Integer(int n, int n2, Object object) throws  {
        return FilterImpl$$Cold.compare_Integer(this, n, n2, object);
    }

    protected boolean compare_Long(int n, long l, Object object) throws  {
        return FilterImpl$$Cold.compare_Long(this, n, l, object);
    }

    protected boolean compare_Byte(int n, byte by, Object object) throws  {
        return FilterImpl$$Cold.compare_Byte(this, n, by, object);
    }

    protected boolean compare_Short(int n, short s, Object object) throws  {
        return FilterImpl$$Cold.compare_Short(this, n, s, object);
    }

    protected boolean compare_Character(int n, char c, Object object) throws  {
        return FilterImpl$$Cold.compare_Character(this, n, c, object);
    }

    protected boolean compare_Boolean(int n, boolean bl, Object object) throws  {
        return FilterImpl$$Cold.compare_Boolean(this, n, bl, object);
    }

    protected boolean compare_Float(int n, float f, Object object) throws  {
        return FilterImpl$$Cold.compare_Float(this, n, f, object);
    }

    protected boolean compare_Double(int n, double d, Object object) throws  {
        return FilterImpl$$Cold.compare_Double(this, n, d, object);
    }

    protected boolean compare_Comparable(int n, Comparable comparable, Object object) throws  {
        return FilterImpl$$Cold.compare_Comparable(this, n, comparable, object);
    }

    protected boolean compare_Unknown(int n, Object object, Object object2) throws  {
        return FilterImpl$$Cold.compare_Unknown(this, n, object, object2);
    }

    protected static String approxString(String string) throws  {
        return FilterImpl$$Cold.approxString(string);
    }
}

