/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.osgi.framework.Version;

public class BundleRepository {
    private ArrayList bundlesByInstallOrder;
    private KeyedHashSet bundlesById;
    private HashMap bundlesBySymbolicName;

    public BundleRepository(int n) {
        this.bundlesByInstallOrder = new ArrayList(n);
        this.bundlesById = new KeyedHashSet(n, true);
        this.bundlesBySymbolicName = new HashMap(n);
    }

    public List getBundles() {
        return this.bundlesByInstallOrder;
    }

    public AbstractBundle getBundle(long l) {
        Long l2 = new Long(l);
        return (AbstractBundle)this.bundlesById.getByKey(l2);
    }

    public AbstractBundle[] getBundles(String string) {
        if ("system.bundle".equals(string)) {
            string = Constants.getInternalSymbolicName();
        }
        return (AbstractBundle[])this.bundlesBySymbolicName.get(string);
    }

    public AbstractBundle getBundle(String string, Version version) {
        AbstractBundle[] abstractBundleArray = this.getBundles(string);
        if (abstractBundleArray != null && abstractBundleArray.length > 0) {
            int n = 0;
            while (n < abstractBundleArray.length) {
                if (abstractBundleArray[n].getVersion().equals(version)) {
                    return abstractBundleArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public void add(AbstractBundle abstractBundle) {
        this.bundlesByInstallOrder.add(abstractBundle);
        this.bundlesById.add(abstractBundle);
        String string = abstractBundle.getSymbolicName();
        if (string != null) {
            AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.bundlesBySymbolicName.get(string);
            if (abstractBundleArray == null) {
                abstractBundleArray = new AbstractBundle[]{abstractBundle};
                this.bundlesBySymbolicName.put(string, abstractBundleArray);
                return;
            }
            ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>(abstractBundleArray.length + 1);
            Version version = abstractBundle.getVersion();
            boolean bl = false;
            int n = 0;
            while (n < abstractBundleArray.length) {
                AbstractBundle abstractBundle2 = abstractBundleArray[n];
                Version version2 = abstractBundle2.getVersion();
                if (!bl && version.compareTo(version2) >= 0) {
                    bl = true;
                    arrayList.add(abstractBundle);
                }
                arrayList.add(abstractBundle2);
                ++n;
            }
            if (!bl) {
                arrayList.add(abstractBundle);
            }
            abstractBundleArray = new AbstractBundle[arrayList.size()];
            arrayList.toArray(abstractBundleArray);
            this.bundlesBySymbolicName.put(string, abstractBundleArray);
        }
    }

    public void removeAllBundles() {
        this.bundlesByInstallOrder.clear();
        this.bundlesById = new KeyedHashSet();
        this.bundlesBySymbolicName.clear();
    }

    public boolean remove(AbstractBundle abstractBundle) {
        boolean bl = this.bundlesById.remove(abstractBundle);
        if (!bl) {
            return false;
        }
        this.bundlesByInstallOrder.remove(abstractBundle);
        String string = abstractBundle.getSymbolicName();
        if (string == null) {
            return true;
        }
        AbstractBundle[] abstractBundleArray = (AbstractBundle[])this.bundlesBySymbolicName.get(string);
        if (abstractBundleArray == null) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < abstractBundleArray.length) {
            if (abstractBundle == abstractBundleArray[n2]) {
                ++n;
                abstractBundleArray[n2] = null;
            }
            ++n2;
        }
        if (n > 0) {
            if (abstractBundleArray.length - n <= 0) {
                this.bundlesBySymbolicName.remove(string);
            } else {
                AbstractBundle[] abstractBundleArray2 = new AbstractBundle[abstractBundleArray.length - n];
                int n3 = 0;
                int n4 = 0;
                while (n4 < abstractBundleArray.length) {
                    if (abstractBundleArray[n4] != null) {
                        abstractBundleArray2[n3] = abstractBundleArray[n4];
                        ++n3;
                    }
                    ++n4;
                }
                this.bundlesBySymbolicName.put(string, abstractBundleArray2);
            }
        }
        return true;
    }
}

