/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle$$Cold;
import org.eclipse.osgi.framework.internal.core.AbstractBundle$1;
import org.eclipse.osgi.framework.internal.core.AbstractBundle$7;
import org.eclipse.osgi.framework.internal.core.AbstractBundle$BundleStatusException;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.ManifestLocalization;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

public abstract class AbstractBundle
implements Bundle,
Comparable,
KeyedElement {
    protected Framework framework;
    protected volatile int state = 2;
    protected volatile Thread stateChanging = null;
    protected BundleData bundledata;
    protected Object statechangeLock = new Object();
    protected BundleProtectionDomain domain;
    protected ManifestLocalization manifestLocalization = null;

    protected static AbstractBundle createBundle(BundleData bundleData, Framework framework) throws BundleException {
        if ((bundleData.getType() & 1) > 0) {
            return new BundleFragment(bundleData, framework);
        }
        return new BundleHost(bundleData, framework);
    }

    protected AbstractBundle(BundleData bundleData, Framework framework) {
        this.bundledata = bundleData;
        this.framework = framework;
        bundleData.setBundle(this);
    }

    protected abstract void load();

    protected abstract boolean reload(AbstractBundle var1);

    protected abstract void refresh();

    protected abstract boolean unload();

    protected void close() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.close called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        this.state = 1;
    }

    protected BundleActivator loadBundleActivator() throws BundleException {
        String string = this.bundledata.getActivator();
        if (string != null) {
            try {
                Class clazz = this.loadClass(string, false);
                return (BundleActivator)clazz.newInstance();
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(throwable);
                }
                throw (Throwable)new BundleException(NLS.bind(Msg.BUNDLE_INVALID_ACTIVATOR_EXCEPTION, string, this.bundledata.getSymbolicName()), throwable);
            }
        }
        return null;
    }

    protected abstract Class loadClass(String var1, boolean var2) throws ClassNotFoundException;

    public int getState() {
        return this.state;
    }

    protected boolean isActive() {
        return (this.state & 0x28) != 0;
    }

    protected boolean isResolved() {
        return (this.state & 3) == 0;
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int n) throws BundleException {
        this.framework.checkAdminPermission(this, "execute");
        this.checkValid();
        this.beginStateChange();
        try {
            this.startWorker(n);
        }
        finally {
            this.completeStateChange();
        }
    }

    protected abstract void startWorker(int var1) throws BundleException;

    protected boolean readyToResume() {
        return false;
    }

    protected void resume() throws BundleException {
        if (this.state == 1) {
            return;
        }
        this.beginStateChange();
        try {
            if (this.readyToResume()) {
                this.startWorker(1);
            }
        }
        finally {
            this.completeStateChange();
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    protected abstract void stopWorker(int var1) throws BundleException;

    protected void setStatus(int n, boolean bl) {
        try {
            AccessController.doPrivileged(new AbstractBundle$1(this, n, bl));
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.framework.publishFrameworkEvent(2, this, privilegedActionException.getException());
        }
    }

    protected void suspend(boolean bl) throws BundleException {
        if (this.state == 1) {
            return;
        }
        this.beginStateChange();
        try {
            this.stopWorker(1);
        }
        finally {
            if (!bl) {
                this.completeStateChange();
            }
        }
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary getHeaders(String string) {
        this.framework.checkAdminPermission(this, "metadata");
        try {
            this.initializeManifestLocalization();
        }
        catch (BundleException bundleException) {
            this.framework.publishFrameworkEvent(2, this, bundleException);
            return new Hashtable();
        }
        if (string == null) {
            string = Locale.getDefault().toString();
        }
        return this.manifestLocalization.getHeaders(string);
    }

    public long getBundleId() {
        return this.bundledata.getBundleID();
    }

    public String getLocation() {
        this.framework.checkAdminPermission(this, "metadata");
        return this.bundledata.getLocation();
    }

    protected void beginStateChange() throws BundleException {
        Object object = this.statechangeLock;
        synchronized (object) {
            boolean bl = false;
            while (true) {
                if (this.stateChanging == null) {
                    this.stateChanging = Thread.currentThread();
                    return;
                }
                if (bl || this.stateChanging == Thread.currentThread()) {
                    throw (Throwable)new BundleException(NLS.bind(Msg.BUNDLE_STATE_CHANGE_EXCEPTION, this.getBundleData().getLocation(), this.stateChanging.getName()), new AbstractBundle$BundleStatusException(this, null, 4, this.stateChanging));
                }
                try {
                    long l;
                    long l2 = 0L;
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(" Waiting for state to change in bundle " + this);
                        l2 = System.currentTimeMillis();
                    }
                    this.statechangeLock.wait(5000L);
                    if (Debug.DEBUG_GENERAL && (l = System.currentTimeMillis()) - l2 > 0L) {
                        System.out.println("Waiting... : " + this.getSymbolicName() + ' ' + (l - l2));
                    }
                }
                catch (InterruptedException interruptedException) {}
                bl = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeStateChange() {
        Object object = this.statechangeLock;
        synchronized (object) {
            if (this.stateChanging != null) {
                this.stateChanging = null;
                this.statechangeLock.notify();
            }
        }
    }

    public String toString() {
        return String.valueOf(this.bundledata.getLocation()) + " [" + this.getBundleId() + "]";
    }

    public int compareTo(Object object) {
        int n = this.getStartLevel() - ((AbstractBundle)object).getStartLevel();
        if (n != 0) {
            return n;
        }
        long l = this.getBundleId() - ((AbstractBundle)object).getBundleId();
        return l < 0L ? -1 : (l > 0L ? 1 : 0);
    }

    protected void checkValid() {
        if (this.state == 1) {
            throw (Throwable)new IllegalStateException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, this.getBundleData().getLocation()));
        }
    }

    protected BundleProtectionDomain getProtectionDomain() {
        return this.domain;
    }

    protected void unresolvePermissions() {
        if (this.domain != null) {
            BundlePermissionCollection bundlePermissionCollection = (BundlePermissionCollection)this.domain.getPermissions();
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unresolving permissions in bundle " + this);
            }
            bundlePermissionCollection.unresolvePermissions();
        }
    }

    protected Bundle[] getFragments() {
        this.checkValid();
        return null;
    }

    protected boolean isFragment() {
        return false;
    }

    protected BundleLoaderProxy[] getHosts() {
        this.checkValid();
        return null;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    public URL getEntry(String string) {
        try {
            this.framework.checkAdminPermission(this, "resource");
        }
        catch (SecurityException securityException) {
            return null;
        }
        this.checkValid();
        if (System.getSecurityManager() == null) {
            return this.bundledata.getEntry(string);
        }
        String string2 = string;
        return (URL)AccessController.doPrivileged(new AbstractBundle$7(this, string2));
    }

    public String getSymbolicName() {
        return this.bundledata.getSymbolicName();
    }

    public long getLastModified() {
        return this.bundledata.getLastModified();
    }

    public BundleData getBundleData() {
        return this.bundledata;
    }

    public Version getVersion() {
        return this.bundledata.getVersion();
    }

    protected BundleDescription getBundleDescription() {
        return this.framework.adaptor.getState().getBundle(this.getBundleId());
    }

    protected int getStartLevel() {
        return this.bundledata.getStartLevel();
    }

    protected abstract BundleLoader getBundleLoader();

    protected void resolve() {
        if (Debug.DEBUG_GENERAL && (this.state & 2) == 0) {
            Debug.println("Bundle.resolve called when state != INSTALLED: " + this);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
        if (this.state == 2) {
            this.state = 4;
        }
    }

    protected abstract BundleContextImpl getContext();

    public String getResolutionFailureMessage() {
        BundleDescription bundleDescription = this.getBundleDescription();
        if (bundleDescription == null) {
            return Msg.BUNDLE_UNRESOLVED_EXCEPTION;
        }
        if (bundleDescription.isResolved()) {
            throw (Throwable)new IllegalStateException(Msg.BUNDLE_UNRESOLVED_STATE_CONFLICT);
        }
        return NLS.bind(Msg.BUNDLE_UNRESOLVED_UNSATISFIED_CONSTRAINT_EXCEPTION, this.getResolverError(bundleDescription));
    }

    private String getResolverError(BundleDescription bundleDescription) {
        ResolverError[] resolverErrorArray = this.framework.adaptor.getState().getResolverErrors(bundleDescription);
        if (resolverErrorArray == null || resolverErrorArray.length == 0) {
            return Msg.BUNDLE_UNRESOLVED_EXCEPTION;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < resolverErrorArray.length) {
            stringBuffer.append(resolverErrorArray[n].toString());
            if (n < resolverErrorArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getKeyHashCode() {
        return (int)this.getBundleId();
    }

    public boolean compare(KeyedElement keyedElement) {
        return this.getBundleId() == ((AbstractBundle)keyedElement).getBundleId();
    }

    public Object getKey() {
        return new Long(this.getBundleId());
    }

    public ResourceBundle getResourceBundle(String string) {
        try {
            this.initializeManifestLocalization();
        }
        catch (BundleException bundleException) {
            return null;
        }
        if (string == null) {
            string = Locale.getDefault().toString();
        }
        return this.manifestLocalization.getResourceBundle(string);
    }

    private void initializeManifestLocalization() throws BundleException {
        if (this.manifestLocalization == null) {
            Dictionary dictionary = this.bundledata.getManifest();
            this.manifestLocalization = new ManifestLocalization(this, dictionary);
        }
    }

    public boolean testStateChanging(Object object) {
        return this.stateChanging == object;
    }

    public Thread getStateChanging() {
        return this.stateChanging;
    }

    public void stop(int n) throws BundleException {
        AbstractBundle$$Cold.stop(this, n);
    }

    public void update() throws BundleException {
        AbstractBundle$$Cold.update(this);
    }

    public void update(InputStream inputStream) throws BundleException {
        AbstractBundle$$Cold.update(this, inputStream);
    }

    protected void updateWorker(PrivilegedExceptionAction privilegedExceptionAction) throws BundleException {
        AbstractBundle$$Cold.updateWorker(this, privilegedExceptionAction);
    }

    protected void updateWorkerPrivileged(URLConnection uRLConnection, AccessControlContext accessControlContext) throws BundleException {
        AbstractBundle$$Cold.updateWorkerPrivileged(this, uRLConnection, accessControlContext);
    }

    public void uninstall() throws BundleException {
        AbstractBundle$$Cold.uninstall(this);
    }

    protected void uninstallWorker(PrivilegedExceptionAction privilegedExceptionAction) throws BundleException {
        AbstractBundle$$Cold.uninstallWorker(this, privilegedExceptionAction);
    }

    protected void uninstallWorkerPrivileged() throws BundleException {
        AbstractBundle$$Cold.uninstallWorkerPrivileged(this);
    }

    public boolean hasPermission(Object object) throws  {
        return AbstractBundle$$Cold.hasPermission(this, object);
    }

    public Enumeration getEntryPaths(String string) throws  {
        return AbstractBundle$$Cold.getEntryPaths(this, string);
    }

    public BundleContext getBundleContext() throws  {
        return AbstractBundle$$Cold.getBundleContext(this);
    }

    public Enumeration findEntries(String string, String string2, boolean bl) throws  {
        return AbstractBundle$$Cold.findEntries(this, string, string2, bl);
    }

    protected void findLocalEntryPaths(String string, Filter filter, Hashtable hashtable, boolean bl, List list) throws  {
        AbstractBundle$$Cold.findLocalEntryPaths(this, string, filter, hashtable, bl, list);
    }
}

