/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions$$Cold;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.debug.DebugOptions;

public class FrameworkDebugOptions
implements DebugOptions {
    private Properties options = null;
    private static FrameworkDebugOptions singleton = null;
    private static boolean debugEnabled = true;
    private static final String OPTIONS = ".options";

    public static FrameworkDebugOptions getDefault() {
        FrameworkDebugOptions frameworkDebugOptions;
        if (singleton == null && debugEnabled && (debugEnabled = (frameworkDebugOptions = new FrameworkDebugOptions()).isDebugEnabled())) {
            singleton = frameworkDebugOptions;
        }
        return singleton;
    }

    private FrameworkDebugOptions() {
        this.loadOptions();
    }

    private boolean isDebugEnabled() {
        return this.options != null;
    }

    private void loadOptions() {
        URL uRL;
        Object object;
        String string = FrameworkProperties.getProperty("osgi.debug");
        if (string == null) {
            return;
        }
        this.options = new Properties();
        if (string.length() == 0) {
            object = FrameworkProperties.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!((String)object).endsWith("/")) {
                object = String.valueOf(object) + "/";
            }
            string = new File((String)object, OPTIONS).toString();
        }
        if ((uRL = FrameworkDebugOptions.buildURL(string, false)) == null) {
            System.out.println("Unable to construct URL for options file: " + string);
            return;
        }
        System.out.print("Debug options:\n    " + uRL.toExternalForm());
        try {
            object = uRL.openStream();
            try {
                this.options.load((InputStream)object);
                System.out.println(" loaded");
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(" not found");
        }
        catch (IOException iOException) {
            System.out.println(" did not parse");
            iOException.printStackTrace(System.out);
        }
        object = this.options.keySet().iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            this.options.put(object2, ((String)this.options.get(object2)).trim());
        }
        if (this.options.size() == 0) {
            this.options = null;
        }
    }

    private static URL buildURL(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        boolean bl2 = string.startsWith("file:");
        try {
            if (bl2) {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(string.substring(5)).toURL(), bl);
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (bl2) {
                return null;
            }
            try {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(string).toURL(), bl);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL uRL, boolean bl) throws MalformedURLException {
        return FrameworkDebugOptions$$Cold.adjustTrailingSlash(uRL, bl);
    }

    public boolean getBooleanOption(String string, boolean bl) throws  {
        return FrameworkDebugOptions$$Cold.getBooleanOption(this, string, bl);
    }

    public String getOption(String string) {
        return this.options != null ? this.options.getProperty(string) : null;
    }

    public String getOption(String string, String string2) {
        return this.options != null ? this.options.getProperty(string, string2) : string2;
    }

    public int getIntegerOption(String string, int n) throws  {
        return FrameworkDebugOptions$$Cold.getIntegerOption(this, string, n);
    }

    public void setOption(String string, String string2) {
        if (this.options != null) {
            this.options.put(string, string2.trim());
        }
    }
}

