/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor;

import java.io.File;

public class FilePath {
    private static final boolean WINDOWS = File.separatorChar == '\\';
    private static final String CURRENT_DIR = ".";
    private static final char DEVICE_SEPARATOR = ':';
    private static final byte HAS_LEADING = 1;
    private static final byte HAS_TRAILING = 4;
    private static final String[] NO_SEGMENTS = new String[0];
    private static final String PARENT_DIR = "..";
    private static final char SEPARATOR = '/';
    private static final String UNC_SLASHES = "//";
    private String device;
    private byte flags;
    private String[] segments;

    public FilePath(File file) {
        this.initialize(file.getPath());
        this.flags = file.isDirectory() ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public FilePath(String string) {
        this.initialize(string);
    }

    private int computeSegmentCount(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0 || n2 == 1 && string.charAt(0) == '/') {
            return 0;
        }
        int n3 = 1;
        int n4 = -1;
        while ((n = string.indexOf(47, n4 + 1)) != -1) {
            if (n != n4 + 1 && n != n2) {
                ++n3;
            }
            n4 = n;
        }
        if (string.charAt(n2 - 1) == '/') {
            --n3;
        }
        return n3;
    }

    private String[] computeSegments(String string) {
        int n = this.computeSegmentCount(string);
        if (n == 0) {
            return NO_SEGMENTS;
        }
        String[] stringArray = new String[n];
        int n2 = string.length();
        int n3 = this.isAbsolute() ? 1 : 0;
        int n4 = this.hasTrailingSlash() ? n2 - 2 : n2 - 1;
        int n5 = n3;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            int n8 = n5;
            int n9 = string.indexOf(47, n5);
            n5 = n9 + 1;
            String string2 = string.substring(n8, n9 == -1 ? n4 + 1 : n9);
            if (!CURRENT_DIR.equals(string2)) {
                if (PARENT_DIR.equals(string2)) {
                    if (n6 > 0) {
                        --n6;
                    }
                } else {
                    stringArray[n6++] = string2;
                }
            }
            ++n7;
        }
        if (n6 == stringArray.length) {
            return stringArray;
        }
        if (n6 == 0) {
            return NO_SEGMENTS;
        }
        String[] stringArray2 = new String[n6];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        return stringArray2;
    }

    public String getDevice() {
        return this.device;
    }

    public String[] getSegments() {
        return (String[])this.segments.clone();
    }

    public boolean hasTrailingSlash() {
        return (this.flags & 4) != 0;
    }

    private void initialize(String string) {
        String string2 = string = string.indexOf(92) == -1 ? string : string.replace('\\', '/');
        if (WINDOWS) {
            int n = string.indexOf(58);
            if (n >= 0) {
                int n2 = string.charAt(0) == '/' ? 1 : 0;
                this.device = string.substring(n2, n + 1);
                string = string.substring(n + 1, string.length());
            } else if (string.startsWith(UNC_SLASHES)) {
                int n3 = string.indexOf(47, 2);
                if (n3 >= 0) {
                    n3 = string.indexOf(47, n3 + 1);
                }
                if (n3 >= 0) {
                    this.device = string.substring(0, n3);
                    string = string.substring(n3, string.length());
                } else {
                    throw (Throwable)new IllegalArgumentException("Not a valid UNC: " + string);
                }
            }
        }
        if (string.charAt(0) == '/') {
            this.flags = (byte)(this.flags | 1);
        }
        if (string.charAt(string.length() - 1) == '/') {
            this.flags = (byte)(this.flags | 4);
        }
        this.segments = this.computeSegments(string);
    }

    public boolean isAbsolute() {
        return (this.flags & 1) != 0;
    }

    public String makeRelative(FilePath filePath) {
        if (filePath.device != null && !filePath.device.equalsIgnoreCase(this.device)) {
            return filePath.toString();
        }
        int n = this.segments.length;
        int n2 = this.matchingFirstSegments(filePath);
        if (n == n2 && n2 == filePath.segments.length) {
            return filePath.hasTrailingSlash() ? "./" : CURRENT_DIR;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n - n2) {
            stringBuffer.append("../");
            ++n3;
        }
        n3 = 0;
        while (n3 < filePath.segments.length - n2) {
            stringBuffer.append(filePath.segments[n2 + n3]);
            stringBuffer.append('/');
            ++n3;
        }
        if (!filePath.hasTrailingSlash()) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private int matchingFirstSegments(FilePath filePath) {
        int n = filePath.segments.length;
        int n2 = Math.min(this.segments.length, n);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (!this.segments[n4].equals(filePath.segments[n4])) {
                return n3;
            }
            ++n3;
            ++n4;
        }
        return n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.device != null) {
            stringBuffer.append(this.device);
        }
        if (this.isAbsolute()) {
            stringBuffer.append('/');
        }
        int n = 0;
        while (n < this.segments.length) {
            stringBuffer.append(this.segments[n]);
            stringBuffer.append('/');
            ++n;
        }
        if (this.segments.length > 0 && !this.hasTrailingSlash()) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

