/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile$$Cold;
import org.eclipse.osgi.framework.internal.protocol.bundleresource.Handler;
import org.eclipse.osgi.framework.util.SecureAction;

public abstract class BundleFile {
    protected static final String PROP_SETPERMS_CMD = "osgi.filepermissions.command";
    static final SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    protected File basefile;
    private int mruIndex = -1;

    public BundleFile() {
    }

    public BundleFile(File file) {
        this.basefile = file;
    }

    public abstract File getFile(String var1, boolean var2);

    public abstract BundleEntry getEntry(String var1);

    public abstract Enumeration getEntryPaths(String var1);

    public abstract void close() throws IOException;

    public abstract void open() throws IOException;

    public abstract boolean containsDir(String var1);

    public URL getResourceURL(String string, long l) {
        return this.getResourceURL(string, l, 0);
    }

    public URL getResourceURL(String string, long l, int n) {
        BundleEntry bundleEntry = this.getEntry(string);
        if (bundleEntry == null) {
            return null;
        }
        if (string.length() == 0 || string.charAt(0) != '/') {
            string = String.valueOf('/') + string;
        }
        try {
            return secureAction.getURL("bundleresource", Long.toString(l), n, string, new Handler(bundleEntry));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public File getBaseFile() {
        return this.basefile;
    }

    void setMruIndex(int n) {
        this.mruIndex = n;
    }

    int getMruIndex() {
        return this.mruIndex;
    }

    public String toString() {
        return String.valueOf(this.basefile);
    }

    public static void setPermissions(File file) throws  {
        BundleFile$$Cold.setPermissions(file);
    }
}

