/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.IModel;
import org.eclipse.core.runtime.internal.adaptor.PluginParser$$Cold;
import org.eclipse.core.runtime.internal.adaptor.PluginParser$PluginInfo;
import org.eclipse.core.runtime.internal.adaptor.PluginParser$Prerequisite;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler
implements IModel {
    private static ServiceTracker xmlTracker = null;
    private PluginParser$PluginInfo manifestInfo = new PluginParser$PluginInfo(this);
    private BundleContext context;
    private FrameworkAdaptor adaptor;
    private Version target;
    private static final Version TARGET21 = new Version(2, 1, 0);
    Stack stateStack = new Stack();
    Stack objectStack = new Stack();
    Locator locator = null;
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int PLUGIN_STATE = 2;
    private static final int PLUGIN_RUNTIME_STATE = 3;
    private static final int PLUGIN_REQUIRES_STATE = 4;
    private static final int PLUGIN_EXTENSION_POINT_STATE = 5;
    private static final int PLUGIN_EXTENSION_STATE = 6;
    private static final int RUNTIME_LIBRARY_STATE = 7;
    private static final int LIBRARY_EXPORT_STATE = 8;
    private static final int PLUGIN_REQUIRES_IMPORT_STATE = 9;
    private static final int FRAGMENT_STATE = 11;

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void endDocument() {
    }

    public void error(SAXParseException sAXParseException) {
        this.logStatus(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.logStatus(sAXParseException);
        throw (Throwable)sAXParseException;
    }

    public static void releaseXMLParsing() {
        if (xmlTracker != null) {
            xmlTracker.close();
        }
    }

    public void parseRequiresAttributes(Attributes attributes) {
    }

    public void warning(SAXParseException sAXParseException) {
        this.logStatus(sAXParseException);
    }

    static Version access$0() {
        return TARGET21;
    }

    static Version access$1(PluginParser pluginParser) {
        return pluginParser.target;
    }

    public PluginParser(FrameworkAdaptor frameworkAdaptor, BundleContext bundleContext, Version version) {
        this.context = bundleContext;
        this.adaptor = frameworkAdaptor;
        this.target = version;
    }

    public void endElement(String string, String string2, String string3) {
        switch ((Integer)this.stateStack.peek()) {
            case 0: {
                this.stateStack.pop();
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                if (!string2.equals("runtime")) break;
                this.stateStack.pop();
                break;
            }
            case 4: {
                if (!string2.equals("requires")) break;
                this.stateStack.pop();
                this.objectStack.pop();
                break;
            }
            case 5: {
                if (!string2.equals("extension-point")) break;
                this.stateStack.pop();
                break;
            }
            case 6: {
                if (!string2.equals("extension")) break;
                this.stateStack.pop();
                break;
            }
            case 7: {
                if (!string2.equals("library")) break;
                String string4 = (String)this.objectStack.pop();
                if (!string4.trim().equals("")) {
                    Vector vector = (Vector)this.objectStack.pop();
                    if (PluginParser$PluginInfo.access$0(this.manifestInfo) == null) {
                        PluginParser$PluginInfo.access$1(this.manifestInfo, new HashMap(3));
                        PluginParser$PluginInfo.access$2(this.manifestInfo, new ArrayList(3));
                    }
                    PluginParser$PluginInfo.access$0(this.manifestInfo).put(string4, vector);
                    PluginParser$PluginInfo.access$3(this.manifestInfo).add(string4.replace('\\', '/'));
                }
                this.stateStack.pop();
                break;
            }
            case 8: {
                if (!string2.equals("export")) break;
                this.stateStack.pop();
                break;
            }
            case 9: {
                if (!string2.equals("import")) break;
                this.stateStack.pop();
            }
        }
    }

    public void handleExtensionPointState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(0));
        PluginParser$PluginInfo.access$4(this.manifestInfo, true);
    }

    public void handleExtensionState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(0));
        PluginParser$PluginInfo.access$4(this.manifestInfo, true);
    }

    public void handleInitialState(String string, Attributes attributes) {
        if (string.equals("plugin")) {
            this.stateStack.push(new Integer(2));
            this.parsePluginAttributes(attributes);
        } else if (string.equals("fragment")) {
            PluginParser$PluginInfo.access$5(this.manifestInfo, true);
            this.stateStack.push(new Integer(11));
            this.parseFragmentAttributes(attributes);
        } else {
            this.stateStack.push(new Integer(0));
            this.internalError(string);
        }
    }

    public void handleLibraryExportState(String string, Attributes attributes) throws  {
        PluginParser$$Cold.handleLibraryExportState(this, string, attributes);
    }

    public void handleLibraryState(String string, Attributes attributes) {
        if (string.equals("export")) {
            this.stateStack.push(new Integer(8));
            String string2 = (String)this.objectStack.peek();
            if (attributes == null) {
                return;
            }
            String string3 = attributes.getValue("", "name");
            this.objectStack.pop();
            Vector vector = (Vector)this.objectStack.peek();
            this.objectStack.push(string2);
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (vector.contains(string3)) continue;
                    vector.addElement(string4.trim());
                }
            }
            return;
        }
        if (string.equals("packages")) {
            this.stateStack.push(new Integer(0));
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(string);
    }

    public void handlePluginState(String string, Attributes attributes) {
        if (string.equals("runtime")) {
            Object e = this.objectStack.peek();
            if (e instanceof PluginParser$PluginInfo && PluginParser$PluginInfo.access$0((PluginParser$PluginInfo)this.objectStack.peek()) != null) {
                this.stateStack.push(new Integer(0));
                return;
            }
            this.stateStack.push(new Integer(3));
            return;
        }
        if (string.equals("requires")) {
            this.stateStack.push(new Integer(4));
            this.objectStack.push(new Vector());
            this.parseRequiresAttributes(attributes);
            return;
        }
        if (string.equals("extension-point")) {
            PluginParser$PluginInfo.access$6(this.manifestInfo, true);
            this.stateStack.push(new Integer(5));
            return;
        }
        if (string.equals("extension")) {
            PluginParser$PluginInfo.access$6(this.manifestInfo, true);
            this.stateStack.push(new Integer(6));
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(string);
    }

    public void handleRequiresImportState(String string, Attributes attributes) throws  {
        PluginParser$$Cold.handleRequiresImportState(this, string, attributes);
    }

    public void handleRequiresState(String string, Attributes attributes) {
        if (string.equals("import")) {
            this.parsePluginRequiresImport(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(string);
    }

    public void handleRuntimeState(String string, Attributes attributes) {
        if (string.equals("library")) {
            this.stateStack.push(new Integer(7));
            this.parseLibraryAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(string);
    }

    private void logStatus(SAXParseException sAXParseException) {
        String string = sAXParseException.getSystemId();
        string = string == null ? "" : string.substring(1 + string.lastIndexOf("/"));
        String string2 = string.equals("") ? NLS.bind(EclipseAdaptorMsg.parse_error, sAXParseException.getMessage()) : NLS.bind(EclipseAdaptorMsg.parse_errorNameLineColumn, new String[]{string, Integer.toString(sAXParseException.getLineNumber()), Integer.toString(sAXParseException.getColumnNumber()), sAXParseException.getMessage()});
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string2, 0, sAXParseException, null);
        this.adaptor.getFrameworkLog().log(frameworkLogEntry);
    }

    public synchronized PluginParser$PluginInfo parsePlugin(InputStream inputStream) throws Exception {
        SAXParserFactory sAXParserFactory = PluginParser.acquireXMLParsing(this.context);
        if (sAXParserFactory == null) {
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, EclipseAdaptorMsg.ECLIPSE_CONVERTER_NO_SAX_FACTORY, 0, null, null);
            this.adaptor.getFrameworkLog().log(frameworkLogEntry);
            return null;
        }
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setNamespaceAware(true);
        try {
            sAXParserFactory.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException sAXException) {}
        sAXParserFactory.setValidating(false);
        sAXParserFactory.newSAXParser().parse(inputStream, (DefaultHandler)this);
        return this.manifestInfo;
    }

    public static SAXParserFactory acquireXMLParsing(BundleContext bundleContext) {
        SAXParserFactory sAXParserFactory;
        if (xmlTracker == null) {
            xmlTracker = new ServiceTracker(bundleContext, "javax.xml.parsers.SAXParserFactory", null);
            xmlTracker.open();
        }
        if ((sAXParserFactory = (SAXParserFactory)xmlTracker.getService()) != null) {
            return sAXParserFactory;
        }
        return SAXParserFactory.newInstance();
    }

    public void parseFragmentAttributes(Attributes attributes) {
        this.objectStack.push(this.manifestInfo);
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getLocalName(n2);
            String string2 = attributes.getValue(n2).trim();
            if (string.equals("id")) {
                PluginParser$PluginInfo.access$7(this.manifestInfo, string2);
            } else if (string.equals("name")) {
                PluginParser$PluginInfo.access$8(this.manifestInfo, string2);
            } else if (string.equals("version")) {
                PluginParser$PluginInfo.access$9(this.manifestInfo, string2);
            } else if (string.equals("provider-name")) {
                PluginParser$PluginInfo.access$10(this.manifestInfo, string2);
            } else if (string.equals("plugin-id")) {
                PluginParser$PluginInfo.access$11(this.manifestInfo, string2);
            } else if (string.equals("plugin-version")) {
                PluginParser$PluginInfo.access$12(this.manifestInfo, string2);
            } else if (string.equals("match")) {
                PluginParser$PluginInfo.access$13(this.manifestInfo, string2);
            }
            ++n2;
        }
    }

    public void parseLibraryAttributes(Attributes attributes) throws  {
        PluginParser$$Cold.parseLibraryAttributes(this, attributes);
    }

    public void parsePluginAttributes(Attributes attributes) {
        this.objectStack.push(this.manifestInfo);
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getLocalName(n2);
            String string2 = attributes.getValue(n2).trim();
            if (string.equals("id")) {
                PluginParser$PluginInfo.access$7(this.manifestInfo, string2);
            } else if (string.equals("name")) {
                PluginParser$PluginInfo.access$8(this.manifestInfo, string2);
            } else if (string.equals("version")) {
                PluginParser$PluginInfo.access$9(this.manifestInfo, string2);
            } else if (string.equals("vendor-name") || string.equals("provider-name")) {
                PluginParser$PluginInfo.access$10(this.manifestInfo, string2);
            } else if (string.equals("class")) {
                PluginParser$PluginInfo.access$14(this.manifestInfo, string2);
            }
            ++n2;
        }
    }

    public void parsePluginRequiresImport(Attributes attributes) {
        String string;
        if (PluginParser$PluginInfo.access$15(this.manifestInfo) == null) {
            PluginParser$PluginInfo.access$16(this.manifestInfo, new ArrayList());
        }
        if ((string = attributes.getValue("", "plugin")) == null) {
            return;
        }
        if (string.equals("org.eclipse.core.boot")) {
            return;
        }
        if (string.equals("org.eclipse.core.runtime.compatibility")) {
            PluginParser$PluginInfo.access$17(this.manifestInfo, true);
        }
        String string2 = attributes.getValue("", "version");
        String string3 = attributes.getValue("", "optional");
        String string4 = attributes.getValue("", "export");
        String string5 = attributes.getValue("", "match");
        PluginParser$PluginInfo.access$15(this.manifestInfo).add(new PluginParser$Prerequisite(this, string, string2, "true".equalsIgnoreCase(string3), "true".equalsIgnoreCase(string4), string5));
    }

    static String replace(String string, String string2, String string3) throws  {
        return PluginParser$$Cold.replace(string, string2, string3);
    }

    public void startDocument() throws  {
        PluginParser$$Cold.startDocument(this);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws  {
        PluginParser$$Cold.startElement(this, string, string2, string3, attributes);
    }

    private void internalError(String string) {
        String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_PARSE_UNKNOWNTOP_ELEMENT, string);
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, PluginParser$PluginInfo.access$18(this.manifestInfo) == null ? string2 : "Plug-in : " + PluginParser$PluginInfo.access$18(this.manifestInfo) + ", " + string2, 0, null, null);
        this.adaptor.getFrameworkLog().log(frameworkLogEntry);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string.equalsIgnoreCase("eclipse")) {
            PluginParser$PluginInfo.access$19(this.manifestInfo, "3.0");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=\"");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equalsIgnoreCase("version")) continue;
                if (!stringTokenizer.hasMoreTokens()) break;
                PluginParser$PluginInfo.access$19(this.manifestInfo, stringTokenizer.nextToken());
                break;
            }
        }
    }
}

