/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.Locker;
import org.eclipse.osgi.util.NLS;

public class Locker_JavaNio
implements Locker {
    private File lockFile;
    private FileLock fileLock;
    private RandomAccessFile raFile;

    public Locker_JavaNio(File file) {
        this.lockFile = file;
    }

    public synchronized boolean lock() throws IOException {
        this.raFile = new RandomAccessFile(this.lockFile, "rw");
        try {
            try {
                this.fileLock = this.raFile.getChannel().tryLock(0L, 1L, false);
            }
            catch (IOException iOException) {
                if (BasicLocation.DEBUG) {
                    System.out.println(NLS.bind(EclipseAdaptorMsg.location_cannotLock, this.lockFile));
                }
                String string = NLS.bind(EclipseAdaptorMsg.location_cannotLockNIO, new Object[]{this.lockFile, iOException.getMessage(), "\"-Dosgi.locking=none\""});
                throw (Throwable)new IOException(string);
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                this.fileLock = null;
                if (this.fileLock != null) {
                    return true;
                }
                this.raFile.close();
                this.raFile = null;
            }
        }
        finally {
            if (this.fileLock != null) {
                return true;
            }
            this.raFile.close();
            this.raFile = null;
        }
        return false;
    }

    public synchronized void release() {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
            }
            catch (IOException iOException) {}
            this.fileLock = null;
        }
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {}
            this.raFile = null;
        }
    }
}

