/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseCommandProvider$$Cold;
import org.eclipse.core.runtime.internal.adaptor.MessageHelper;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseCommandProvider
implements CommandProvider {
    private BundleContext context;
    static Class class$0;

    public EclipseCommandProvider(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    public String getHelp() throws  {
        return EclipseCommandProvider$$Cold.getHelp(this);
    }

    private BundleDescription getBundleDescriptionFromToken(State state, String string) throws  {
        return EclipseCommandProvider$$Cold.getBundleDescriptionFromToken(this, state, string);
    }

    public void _diag(CommandInterpreter commandInterpreter) throws Exception {
        ServiceReference serviceReference;
        String string = commandInterpreter.nextArgument();
        if (string == null) {
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        if ((serviceReference = this.context.getServiceReference(clazz.getName())) == null) {
            commandInterpreter.print("  ");
            commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        try {
            PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(serviceReference);
            if (platformAdmin == null) {
                return;
            }
            State state = platformAdmin.getState(false);
            while (string != null) {
                BundleDescription bundleDescription = this.getBundleDescriptionFromToken(state, string);
                if (bundleDescription == null) {
                    commandInterpreter.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, string));
                    string = commandInterpreter.nextArgument();
                    continue;
                }
                commandInterpreter.println(String.valueOf(bundleDescription.getLocation()) + " [" + bundleDescription.getBundleId() + "]");
                VersionConstraint[] versionConstraintArray = platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundleDescription);
                ResolverError[] resolverErrorArray = platformAdmin.getState(false).getResolverErrors(bundleDescription);
                int n = 0;
                while (n < resolverErrorArray.length) {
                    if ((resolverErrorArray[n].getType() & 0x8007) == 0) {
                        commandInterpreter.print("  ");
                        commandInterpreter.println(resolverErrorArray[n].toString());
                    }
                    ++n;
                }
                n = 0;
                while (n < versionConstraintArray.length) {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(MessageHelper.getResolutionFailureMessage(versionConstraintArray[n]));
                    ++n;
                }
                if (versionConstraintArray.length == 0 && resolverErrorArray.length == 0) {
                    commandInterpreter.print("  ");
                    commandInterpreter.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS);
                }
                string = commandInterpreter.nextArgument();
            }
        }
        finally {
            this.context.ungetService(serviceReference);
        }
    }
}

