/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.BasicLocation;
import org.eclipse.core.runtime.internal.adaptor.BundleLocalizationImpl;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorHook$DomParsingService;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorHook$SaxParsingService;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseCommandProvider;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.core.runtime.internal.adaptor.MessageHelper;
import org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import org.eclipse.core.runtime.internal.adaptor.PluginParser;
import org.eclipse.core.runtime.internal.adaptor.URLConverterImpl;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.runnable.ApplicationLauncher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class EclipseAdaptorHook
implements AdaptorHook,
HookConfigurator {
    public static final String SAXFACTORYNAME = "javax.xml.parsers.SAXParserFactory";
    public static final String DOMFACTORYNAME = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String RUNTIME_ADAPTOR = "org.eclipse.osgi/eclipseadaptor";
    private static final String OPTION_CONVERTER = "org.eclipse.osgi/eclipseadaptor/converter/debug";
    private static final String OPTION_LOCATION = "org.eclipse.osgi/eclipseadaptor/debug/location";
    private BaseAdaptor adaptor;
    private boolean noXML = false;
    static Class class$0;
    static Class class$1;
    static Class class$2;
    static Class class$3;
    static Class class$4;
    static Class class$5;
    static Class class$6;
    static Class class$7;

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
        Class<?> clazz;
        this.registerEndorsedXMLParser(bundleContext);
        Location location = LocationManager.getUserLocation();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        if (location != null) {
            hashtable.put("type", "osgi.user.area");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            bundleContext.registerService(clazz2.getName(), (Object)location, (Dictionary)hashtable);
        }
        if ((location = LocationManager.getInstanceLocation()) != null) {
            hashtable.put("type", "osgi.instance.area");
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            bundleContext.registerService(clazz3.getName(), (Object)location, (Dictionary)hashtable);
        }
        if ((location = LocationManager.getConfigurationLocation()) != null) {
            hashtable.put("type", "osgi.configuration.area");
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            bundleContext.registerService(clazz4.getName(), (Object)location, (Dictionary)hashtable);
        }
        if ((location = LocationManager.getInstallLocation()) != null) {
            hashtable.put("type", "osgi.install.area");
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            bundleContext.registerService(clazz5.getName(), (Object)location, (Dictionary)hashtable);
        }
        Hashtable hashtable2 = new Hashtable();
        ((Dictionary)hashtable2).put("protocol", new String[]{"bundleentry", "bundleresource"});
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("org.eclipse.osgi.service.urlconversion.URLConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        bundleContext.registerService(clazz6.getName(), (Object)new URLConverterImpl(), (Dictionary)hashtable2);
        Class<?> clazz7 = class$2;
        if (clazz7 == null) {
            try {
                clazz7 = class$2 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        AdaptorUtil.register(clazz7.getName(), EclipseEnvironmentInfo.getDefault(), bundleContext);
        Class<?> clazz8 = class$3;
        if (clazz8 == null) {
            try {
                clazz8 = class$3 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        AdaptorUtil.register(clazz8.getName(), this.adaptor.getPlatformAdmin(), bundleContext);
        PluginConverterImpl pluginConverterImpl = PluginConverterImpl.getDefault();
        if (pluginConverterImpl == null) {
            pluginConverterImpl = new PluginConverterImpl(this.adaptor, bundleContext);
        }
        if ((clazz = class$4) == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        AdaptorUtil.register(clazz.getName(), pluginConverterImpl, bundleContext);
        Class<?> clazz9 = class$5;
        if (clazz9 == null) {
            try {
                clazz9 = class$5 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        AdaptorUtil.register(clazz9.getName(), new EclipseCommandProvider(bundleContext), bundleContext);
        Class<?> clazz10 = class$6;
        if (clazz10 == null) {
            try {
                clazz10 = class$6 = Class.forName("org.eclipse.osgi.service.localization.BundleLocalization");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        AdaptorUtil.register(clazz10.getName(), new BundleLocalizationImpl(), bundleContext);
    }

    private void registerEndorsedXMLParser(BundleContext bundleContext) {
        block2: {
            try {
                Class.forName(SAXFACTORYNAME);
                bundleContext.registerService(SAXFACTORYNAME, (Object)new EclipseAdaptorHook$SaxParsingService(this, null), (Dictionary)new Hashtable());
                Class.forName(DOMFACTORYNAME);
                bundleContext.registerService(DOMFACTORYNAME, (Object)new EclipseAdaptorHook$DomParsingService(this, null), (Dictionary)new Hashtable());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.noXML = true;
                if (!Debug.DEBUG_ENABLED) break block2;
                String string = EclipseAdaptorMsg.ECLIPSE_ADAPTOR_ERROR_XML_SERVICE;
                this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, string, 0, classNotFoundException, null));
            }
        }
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        this.printStats();
        if (!this.noXML) {
            PluginParser.releaseXMLParsing();
        }
    }

    private void printStats() {
        String string;
        String string2;
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions == null) {
            return;
        }
        String string3 = frameworkDebugOptions.getOption("org.eclipse.core.runtime/registry/parsing/timing/value");
        if (string3 != null) {
            MessageHelper.debug("Time spent in registry parsing: " + string3);
        }
        if ((string2 = frameworkDebugOptions.getOption("debug.packageadmin/timing/value")) != null) {
            System.out.println("Time spent in package admin resolve: " + string2);
        }
        if ((string = frameworkDebugOptions.getOption("org.eclipse.core.runtime.adaptor/resolver/timing/value")) != null) {
            System.out.println("Time spent resolving the dependency system: " + string);
        }
    }

    public void frameworkStopping(BundleContext bundleContext) {
        ServiceReference serviceReference;
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.osgi.service.runnable.ApplicationLauncher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        if ((serviceReference = bundleContext.getServiceReference(clazz.getName())) != null) {
            ApplicationLauncher applicationLauncher = (ApplicationLauncher)bundleContext.getService(serviceReference);
            applicationLauncher.shutdown();
            bundleContext.ungetService(serviceReference);
        }
    }

    public void addProperties(Properties properties) {
        if (properties.getProperty(Constants.ECLIPSE_EE_INSTALL_VERIFY) == null) {
            properties.put(Constants.ECLIPSE_EE_INSTALL_VERIFY, "false");
        }
        if (properties.getProperty(Constants.OSGI_COMPATIBILITY_BOOTDELEGATION) == null) {
            properties.put(Constants.OSGI_COMPATIBILITY_BOOTDELEGATION, "true");
        }
    }

    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable throwable) {
    }

    public boolean matchDNChain(String string, String[] stringArray) {
        return false;
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public void initialize(BaseAdaptor baseAdaptor) {
        this.adaptor = baseAdaptor;
        EclipseEnvironmentInfo.getDefault();
        this.setDebugOptions();
    }

    private void setDebugOptions() {
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions == null) {
            return;
        }
        PluginConverterImpl.DEBUG = frameworkDebugOptions.getBooleanOption(OPTION_CONVERTER, false);
        BasicLocation.DEBUG = frameworkDebugOptions.getBooleanOption(OPTION_LOCATION, false);
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook(this);
    }
}

