/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.adaptor.EclipseStarter$$Cold;
import org.eclipse.core.runtime.adaptor.EclipseStarter$1;
import org.eclipse.core.runtime.adaptor.EclipseStarter$2;
import org.eclipse.core.runtime.adaptor.EclipseStarter$3;
import org.eclipse.core.runtime.adaptor.EclipseStarter$InitialBundle;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.DefaultStartupMonitor;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseAppLauncher;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.core.runtime.internal.adaptor.MessageHelper;
import org.eclipse.core.runtime.internal.adaptor.Semaphore;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class EclipseStarter {
    private static FrameworkAdaptor adaptor;
    private static BundleContext context;
    private static boolean initialize;
    public static boolean debug;
    private static boolean running;
    private static OSGi osgi;
    private static ServiceRegistration defaultMonitorRegistration;
    private static ServiceRegistration appLauncherRegistration;
    private static ServiceRegistration splashStreamRegistration;
    private static final String CLEAN = "-clean";
    private static final String CONSOLE = "-console";
    private static final String CONSOLE_LOG = "-consoleLog";
    private static final String DEBUG = "-debug";
    private static final String INITIALIZE = "-initialize";
    private static final String DEV = "-dev";
    private static final String WS = "-ws";
    private static final String OS = "-os";
    private static final String ARCH = "-arch";
    private static final String NL = "-nl";
    private static final String CONFIGURATION = "-configuration";
    private static final String USER = "-user";
    private static final String NOEXIT = "-noExit";
    private static final String DATA = "-data";
    public static final String PROP_BUNDLES = "osgi.bundles";
    public static final String PROP_BUNDLES_STARTLEVEL = "osgi.bundles.defaultStartLevel";
    public static final String PROP_EXTENSIONS = "osgi.framework.extensions";
    public static final String PROP_INITIAL_STARTLEVEL = "osgi.startLevel";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_CONSOLE = "osgi.console";
    public static final String PROP_CONSOLE_CLASS = "osgi.consoleClass";
    public static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_ADAPTOR = "osgi.adaptor";
    public static final String PROP_SYSPATH = "osgi.syspath";
    public static final String PROP_LOGFILE = "osgi.logfile";
    public static final String PROP_FRAMEWORK = "osgi.framework";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_FRAMEWORK_SHAPE = "osgi.framework.shape";
    public static final String PROP_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_FORCED_RESTART = "osgi.forcedRestart";
    public static final String PROP_EXITCODE = "eclipse.exitcode";
    public static final String PROP_EXITDATA = "eclipse.exitdata";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    public static final String PROP_IGNOREAPP = "eclipse.ignoreApp";
    public static final String PROP_REFRESH_BUNDLES = "eclipse.refreshBundles";
    private static final String PROP_ALLOW_APPRELAUNCH = "eclipse.allowAppRelaunch";
    private static final String PROP_APPLICATION_LAUNCHDEFAULT = "eclipse.application.launchDefault";
    private static final String FILE_SCHEME = "file:";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String REFERENCE_PROTOCOL = "reference";
    private static final String INITIAL_LOCATION = "initial@";
    protected static final String DEFAULT_ADAPTOR_CLASS = "org.eclipse.osgi.baseadaptor.BaseAdaptor";
    private static final int DEFAULT_INITIAL_STARTLEVEL = 6;
    private static final String DEFAULT_BUNDLES_STARTLEVEL = "4";
    protected static final String DEFAULT_CONSOLE_CLASS = "org.eclipse.osgi.framework.internal.core.FrameworkConsole";
    private static final String CONSOLE_NAME = "OSGi Console";
    private static Runnable console;
    private static FrameworkLog log;
    private static HashMap searchCandidates;
    private static EclipseAppLauncher appLauncher;
    private static List shutdownHandlers;
    static Class class$0;
    static Class class$1;
    static Class class$2;
    static Class class$3;
    static Class class$4;
    static Class class$5;
    static Class class$6;
    static Class class$7;
    static Class class$8;
    static Class class$9;
    static Class class$10;

    static {
        initialize = false;
        debug = false;
        running = false;
        osgi = null;
        defaultMonitorRegistration = null;
        appLauncherRegistration = null;
        splashStreamRegistration = null;
        searchCandidates = new HashMap(4);
    }

    public static Object run(String[] stringArray, Runnable runnable) throws Exception {
        if (Profile.STARTUP) {
            Profile.logEnter("EclipseStarter.run()", null);
        }
        if (running) {
            throw (Throwable)new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        boolean bl = true;
        try {
            EclipseStarter.startup(stringArray, runnable);
            bl = false;
            if (Boolean.valueOf(FrameworkProperties.getProperty(PROP_IGNOREAPP)).booleanValue() || EclipseStarter.isForcedRestart()) {
                return null;
            }
            Object object = EclipseStarter.run(null);
            return object;
        }
        catch (Throwable throwable) {
            if (runnable != null) {
                runnable.run();
            }
            FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, bl ? EclipseAdaptorMsg.ECLIPSE_STARTUP_STARTUP_ERROR : EclipseAdaptorMsg.ECLIPSE_STARTUP_APP_ERROR, 1, throwable, null);
            if (log != null) {
                log.log(frameworkLogEntry);
                if (context != null) {
                    EclipseStarter.logUnresolvedBundles(context.getBundles());
                }
            } else {
                throwable.printStackTrace();
            }
        }
        finally {
            String string;
            try {
                if (EclipseStarter.isForcedRestart()) {
                    FrameworkProperties.setProperty(PROP_EXITCODE, "23");
                }
                if (!Boolean.valueOf(FrameworkProperties.getProperty(PROP_NOSHUTDOWN)).booleanValue()) {
                    EclipseStarter.shutdown();
                }
            }
            catch (Throwable throwable) {
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, throwable, null);
                if (log != null) {
                    log.log(frameworkLogEntry);
                }
                throwable.printStackTrace();
            }
            if (Profile.STARTUP) {
                Profile.logExit("EclipseStarter.run()");
            }
            if ((string = Profile.getProfileLog()) != null && string.length() > 0) {
                System.out.println(string);
            }
        }
        FrameworkProperties.setProperty(PROP_EXITCODE, "13");
        FrameworkProperties.setProperty(PROP_EXITDATA, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_CHECK_LOG, log == null ? null : log.getFile().getPath()));
        return null;
    }

    public static boolean isRunning() {
        return running;
    }

    public static BundleContext startup(String[] stringArray, Runnable runnable) throws Exception {
        String string;
        if (Profile.STARTUP) {
            Profile.logEnter("EclipseStarter.startup()", null);
        }
        if (running) {
            throw (Throwable)new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        EclipseStarter.initializeProperties();
        EclipseStarter.processCommandLine(stringArray);
        LocationManager.initializeLocations();
        EclipseStarter.loadConfigurationInfo();
        EclipseStarter.finalizeProperties();
        Profile.initProps();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "props inited");
        }
        adaptor = EclipseStarter.createAdaptor();
        log = adaptor.getFrameworkLog();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "adapter created");
        }
        osgi = new OSGi(adaptor);
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "OSGi created");
        }
        context = osgi.getBundleContext();
        EclipseStarter.registerFrameworkShutdownHandlers();
        EclipseStarter.publishSplashScreen(runnable);
        osgi.launch();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "osgi launched");
        }
        if ((string = FrameworkProperties.getProperty(PROP_CONSOLE)) != null) {
            EclipseStarter.startConsole(osgi, new String[0], string);
            if (Profile.STARTUP) {
                Profile.logTime("EclipseStarter.startup()", "console started");
            }
        }
        if ("true".equals(FrameworkProperties.getProperty(PROP_REFRESH_BUNDLES)) && EclipseStarter.refreshPackages(EclipseStarter.getCurrentBundles(false))) {
            return context;
        }
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "loading basic bundles");
        }
        long l = adaptor.getState().getTimeStamp();
        Bundle[] bundleArray = EclipseStarter.loadBasicBundles();
        if (bundleArray == null) {
            return context;
        }
        EclipseStarter.setStartLevel(EclipseStarter.getStartLevel());
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "StartLevel set");
        }
        EclipseStarter.ensureBundlesActive(bundleArray);
        if ((debug || FrameworkProperties.getProperty(PROP_DEV) != null) && l != adaptor.getState().getTimeStamp()) {
            EclipseStarter.logUnresolvedBundles(context.getBundles());
        }
        running = true;
        if (Profile.STARTUP) {
            Profile.logExit("EclipseStarter.startup()");
        }
        return context;
    }

    private static int getStartLevel() {
        block3: {
            String string = FrameworkProperties.getProperty(PROP_INITIAL_STARTLEVEL);
            if (string != null) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!debug) break block3;
                    System.out.println("Start level = " + string + "  parsed. Using hardcoded default: 6");
                }
            }
        }
        return 6;
    }

    public static Object run(Object object) throws Exception {
        if (Profile.STARTUP) {
            Profile.logEnter("EclipseStarter.run(Object)()", null);
        }
        if (!running) {
            throw (Throwable)new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_NOT_RUNNING);
        }
        if (initialize) {
            return new Integer(0);
        }
        if (appLauncher == null) {
            boolean bl = Boolean.valueOf(FrameworkProperties.getProperty(PROP_APPLICATION_LAUNCHDEFAULT, "true"));
            appLauncher = new EclipseAppLauncher(context, Boolean.valueOf(FrameworkProperties.getProperty(PROP_ALLOW_APPRELAUNCH)), bl, log);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.runnable.ApplicationLauncher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            appLauncherRegistration = context.registerService(clazz.getName(), (Object)appLauncher, null);
            return appLauncher.start(object);
        }
        return appLauncher.reStart(object);
    }

    public static void shutdown() throws Exception {
        if (!running || osgi == null) {
            return;
        }
        if (appLauncherRegistration != null) {
            appLauncherRegistration.unregister();
        }
        if (splashStreamRegistration != null) {
            splashStreamRegistration.unregister();
        }
        if (defaultMonitorRegistration != null) {
            defaultMonitorRegistration.unregister();
        }
        appLauncherRegistration = null;
        appLauncher = null;
        splashStreamRegistration = null;
        defaultMonitorRegistration = null;
        EclipseStarter.stopConsole();
        osgi.close();
        osgi = null;
        context = null;
        running = false;
    }

    private static void ensureBundlesActive(Bundle[] bundleArray) {
        ServiceTracker serviceTracker = null;
        try {
            int n = 0;
            while (n < bundleArray.length) {
                if (bundleArray[n].getState() != 32) {
                    if (bundleArray[n].getState() == 2) {
                        log.log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, bundleArray[n].getLocation()), 0, null, null));
                    } else {
                        StartLevel startLevel;
                        if (serviceTracker == null) {
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.osgi.service.startlevel.StartLevel");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                                }
                            }
                            serviceTracker = new ServiceTracker(context, clazz.getName(), null);
                            serviceTracker.open();
                        }
                        if ((startLevel = (StartLevel)serviceTracker.getService()) != null && startLevel.getBundleStartLevel(bundleArray[n]) <= startLevel.getStartLevel()) {
                            log.log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_ACTIVE, bundleArray[n]), 0, null, null));
                        }
                    }
                }
                ++n;
            }
        }
        finally {
            if (serviceTracker != null) {
                serviceTracker.close();
            }
        }
    }

    private static void publishSplashScreen(Runnable runnable) {
        Object object;
        block11: {
            if (runnable == null) {
                return;
            }
            try {
                object = runnable.getClass().getMethod("getOutputStream", new Class[0]);
                Object object2 = ((Method)object).invoke((Object)runnable, new Object[0]);
                if (!(object2 instanceof OutputStream)) break block11;
                Hashtable hashtable = new Hashtable();
                ((Dictionary)hashtable).put("name", "splashstream");
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.io.OutputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                splashStreamRegistration = context.registerService(clazz.getName(), object2, (Dictionary)hashtable);
            }
            catch (Exception exception) {}
        }
        try {
            object = new Hashtable();
            ((Dictionary)object).put("service.ranking", new Integer(Integer.MIN_VALUE));
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.osgi.service.runnable.StartupMonitor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            defaultMonitorRegistration = context.registerService(clazz.getName(), (Object)new DefaultStartupMonitor(runnable), (Dictionary)object);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private static URL searchForBundle(String string, String string2) throws MalformedURLException {
        Object object;
        URL uRL = null;
        File file = null;
        boolean bl = false;
        try {
            new URL(string);
            uRL = new URL(new File(string2).toURL(), string);
        }
        catch (MalformedURLException malformedURLException) {
            object = new File(string);
            file = ((File)object).isAbsolute() ? object : new File(string2, string);
            uRL = new URL(REFERENCE_PROTOCOL, null, file.toURL().toExternalForm());
            bl = true;
        }
        if (!bl) {
            object = uRL;
            if (uRL.getProtocol().equals(REFERENCE_PROTOCOL)) {
                File file2;
                bl = true;
                String string3 = uRL.getFile();
                object = string3.startsWith(FILE_SCHEME) ? ((file2 = new File(string3.substring(5))).isAbsolute() ? file2.toURL() : new File(string2, file2.getPath()).toURL()) : new URL(string3);
            }
            if (!(file = new File(((URL)object).getFile())).isAbsolute()) {
                file = new File(string2, file.toString());
            }
        }
        if (bl) {
            object = EclipseStarter.searchFor(file.getName(), new File(file.getParent()).getAbsolutePath());
            if (object != null) {
                uRL = new URL(REFERENCE_PROTOCOL, null, FILE_SCHEME + (String)object);
            } else {
                return null;
            }
        }
        try {
            object = uRL.openConnection();
            ((URLConnection)object).connect();
            return uRL;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Bundle[] loadBasicBundles() throws IOException {
        long l = System.currentTimeMillis();
        String string = FrameworkProperties.getProperty(PROP_BUNDLES);
        String string2 = FrameworkProperties.getProperty(PROP_EXTENSIONS);
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string2) + ',' + string;
            FrameworkProperties.setProperty(PROP_BUNDLES, string);
        }
        String[] stringArray = EclipseStarter.getArrayFromList(string, ",");
        EclipseStarter$InitialBundle[] eclipseStarter$InitialBundleArray = EclipseStarter.getInitialBundles(stringArray);
        Bundle[] bundleArray = EclipseStarter.getCurrentBundles(true);
        ArrayList arrayList = new ArrayList(bundleArray.length);
        EclipseStarter.uninstallBundles(bundleArray, eclipseStarter$InitialBundleArray, arrayList);
        ArrayList arrayList2 = new ArrayList(stringArray.length);
        ArrayList arrayList3 = new ArrayList(stringArray.length);
        EclipseStarter.installBundles(eclipseStarter$InitialBundleArray, bundleArray, arrayList2, arrayList3, arrayList);
        if (!arrayList.isEmpty() && EclipseStarter.refreshPackages(arrayList.toArray(new Bundle[arrayList.size()]))) {
            return null;
        }
        Bundle[] bundleArray2 = arrayList2.toArray(new Bundle[arrayList2.size()]);
        Bundle[] bundleArray3 = arrayList3.toArray(new Bundle[arrayList3.size()]);
        EclipseStarter.startBundles(bundleArray2, bundleArray3);
        if (debug) {
            System.out.println("Time to load bundles: " + (System.currentTimeMillis() - l));
        }
        return bundleArray2;
    }

    private static EclipseStarter$InitialBundle[] getInitialBundles(String[] stringArray) throws MalformedURLException {
        searchCandidates.clear();
        ArrayList<EclipseStarter$InitialBundle> arrayList = new ArrayList<EclipseStarter$InitialBundle>(stringArray.length);
        int n = Integer.parseInt(FrameworkProperties.getProperty(PROP_BUNDLES_STARTLEVEL, DEFAULT_BUNDLES_STARTLEVEL));
        String string = EclipseStarter.getSysPath();
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {}
        int n2 = 0;
        while (n2 < stringArray.length) {
            Object object;
            Object object2;
            String string2 = stringArray[n2];
            int n3 = n;
            boolean bl = false;
            int n4 = string2.indexOf(64);
            if (n4 >= 0) {
                object2 = EclipseStarter.getArrayFromList(string2.substring(n4 + 1, string2.length()), ":");
                string2 = string2.substring(0, n4);
                int n5 = 0;
                while (n5 < ((Object)object2).length) {
                    Object object3 = object2[n5];
                    if (((String)object3).equals("start")) {
                        bl = true;
                    } else {
                        n3 = Integer.parseInt((String)object3);
                    }
                    ++n5;
                }
            }
            if ((object2 = EclipseStarter.searchForBundle(string2, string)) == null) {
                object = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_BUNDLE_NOT_FOUND, stringArray[n2]), 0, null, null);
                log.log((FrameworkLogEntry)object);
            } else {
                object2 = EclipseStarter.makeRelative(LocationManager.getInstallLocation().getURL(), (URL)object2);
                object = INITIAL_LOCATION + ((URL)object2).toExternalForm();
                arrayList.add(new EclipseStarter$InitialBundle((String)object, (URL)object2, n3, bl));
            }
            ++n2;
        }
        return arrayList.toArray(new EclipseStarter$InitialBundle[arrayList.size()]);
    }

    private static boolean refreshPackages(Bundle[] bundleArray) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        ServiceReference serviceReference = context.getServiceReference(clazz.getName());
        PackageAdmin packageAdmin = null;
        if (serviceReference != null && (packageAdmin = (PackageAdmin)context.getService(serviceReference)) == null) {
            return false;
        }
        Semaphore semaphore = new Semaphore(0);
        EclipseStarter$1 eclipseStarter$1 = new EclipseStarter$1(semaphore);
        context.addFrameworkListener(eclipseStarter$1);
        packageAdmin.refreshPackages(bundleArray);
        context.ungetService(serviceReference);
        EclipseStarter.updateSplash(semaphore, eclipseStarter$1);
        if (EclipseStarter.isForcedRestart()) {
            Bundle bundle = context.getBundle(0L);
            for (int i = 0; i < 5000 && (bundle.getState() & 0x30) != 0; i += 200) {
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private static void stopConsole() {
        if (console == null) {
            return;
        }
        try {
            Method method = console.getClass().getMethod("shutdown", null);
            method.invoke((Object)console, null);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private static FrameworkAdaptor createAdaptor() throws Exception {
        String string = FrameworkProperties.getProperty(PROP_ADAPTOR, DEFAULT_ADAPTOR_CLASS);
        Class<?> clazz = Class.forName(string);
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$6;
        if (clazz2 == null) {
            try {
                clazz2 = class$6 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        classArray[0] = clazz2;
        Class[] classArray2 = classArray;
        Constructor<?> constructor = clazz.getConstructor(classArray2);
        return (FrameworkAdaptor)constructor.newInstance(new Object[]{new String[0]});
    }

    private static String[] processCommandLine(String[] stringArray) throws Exception {
        EclipseEnvironmentInfo.setAllArgs(stringArray);
        if (stringArray.length == 0) {
            EclipseEnvironmentInfo.setFrameworkArgs(stringArray);
            EclipseEnvironmentInfo.setAllArgs(stringArray);
            return stringArray;
        }
        int[] nArray = new int[stringArray.length];
        nArray[0] = -1;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            boolean bl = false;
            if (stringArray[n2].equalsIgnoreCase(DEBUG) && (n2 + 1 == stringArray.length || n2 + 1 < stringArray.length && stringArray[n2 + 1].startsWith("-"))) {
                FrameworkProperties.setProperty(PROP_DEBUG, "");
                debug = true;
                bl = true;
            }
            if (stringArray[n2].equalsIgnoreCase(DEV) && (n2 + 1 == stringArray.length || n2 + 1 < stringArray.length && stringArray[n2 + 1].startsWith("-"))) {
                FrameworkProperties.setProperty(PROP_DEV, "");
                bl = true;
            }
            if (stringArray[n2].equalsIgnoreCase(INITIALIZE)) {
                initialize = true;
                bl = true;
            }
            if (stringArray[n2].equalsIgnoreCase(CLEAN)) {
                FrameworkProperties.setProperty(PROP_CLEAN, "true");
                bl = true;
            }
            if (stringArray[n2].equalsIgnoreCase(CONSOLE_LOG)) {
                FrameworkProperties.setProperty(PROP_CONSOLE_LOG, "true");
                bl = true;
            }
            if (stringArray[n2].equalsIgnoreCase(CONSOLE) && (n2 + 1 == stringArray.length || n2 + 1 < stringArray.length && stringArray[n2 + 1].startsWith("-"))) {
                FrameworkProperties.setProperty(PROP_CONSOLE, "");
                bl = true;
            }
            if (stringArray[n2].equalsIgnoreCase(NOEXIT)) {
                FrameworkProperties.setProperty(PROP_NOSHUTDOWN, "true");
                bl = true;
            }
            if (bl) {
                nArray[n++] = n2;
            } else if (n2 != stringArray.length - 1 && !stringArray[n2 + 1].startsWith("-")) {
                String string = stringArray[++n2];
                if (stringArray[n2 - 1].equalsIgnoreCase(CONSOLE)) {
                    FrameworkProperties.setProperty(PROP_CONSOLE, string);
                    bl = true;
                }
                if (stringArray[n2 - 1].equalsIgnoreCase(CONFIGURATION)) {
                    FrameworkProperties.setProperty("osgi.configuration.area", string);
                    bl = true;
                }
                if (stringArray[n2 - 1].equalsIgnoreCase(DATA)) {
                    FrameworkProperties.setProperty("osgi.instance.area", string);
                    bl = true;
                }
                if (stringArray[n2 - 1].equalsIgnoreCase(USER)) {
                    FrameworkProperties.setProperty("osgi.user.area", string);
                    bl = true;
                }
                if (stringArray[n2 - 1].equalsIgnoreCase(DEV)) {
                    FrameworkProperties.setProperty(PROP_DEV, string);
                    bl = true;
                }
                if (stringArray[n2 - 1].equalsIgnoreCase(DEBUG)) {
                    FrameworkProperties.setProperty(PROP_DEBUG, string);
                    debug = true;
                    bl = true;
                }
                if (stringArray[n2 - 1].equalsIgnoreCase(WS)) {
                    FrameworkProperties.setProperty(PROP_WS, string);
                    bl = true;
                }
                if (stringArray[n2 - 1].equalsIgnoreCase(OS)) {
                    FrameworkProperties.setProperty(PROP_OS, string);
                    bl = true;
                }
                if (stringArray[n2 - 1].equalsIgnoreCase(ARCH)) {
                    FrameworkProperties.setProperty(PROP_ARCH, string);
                    bl = true;
                }
                if (stringArray[n2 - 1].equalsIgnoreCase(NL)) {
                    FrameworkProperties.setProperty(PROP_NL, string);
                    bl = true;
                }
                if (bl) {
                    nArray[n++] = n2 - 1;
                    nArray[n++] = n2;
                }
            }
            ++n2;
        }
        if (n == 0) {
            EclipseEnvironmentInfo.setFrameworkArgs(new String[0]);
            EclipseEnvironmentInfo.setAppArgs(stringArray);
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length - n];
        String[] stringArray3 = new String[n];
        n = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (n5 == nArray[n]) {
                stringArray3[n4++] = stringArray[n5];
                ++n;
            } else {
                stringArray2[n3++] = stringArray[n5];
            }
            ++n5;
        }
        EclipseEnvironmentInfo.setFrameworkArgs(stringArray3);
        EclipseEnvironmentInfo.setAppArgs(stringArray2);
        return stringArray2;
    }

    private static String[] getArrayFromList(String string, String string2) {
        return ManifestElement.getArrayFromList(string, string2);
    }

    protected static String getSysPath() {
        String string = FrameworkProperties.getProperty(PROP_SYSPATH);
        if (string != null) {
            return string;
        }
        string = EclipseStarter.getSysPathFromURL(FrameworkProperties.getProperty(PROP_FRAMEWORK));
        if (string == null) {
            string = EclipseStarter.getSysPathFromCodeSource();
        }
        if (string == null) {
            throw (Throwable)new IllegalStateException("Can not find the system path.");
        }
        if (Character.isUpperCase(string.charAt(0))) {
            char[] cArray = string.toCharArray();
            cArray[0] = Character.toLowerCase(cArray[0]);
            string = new String(cArray);
        }
        FrameworkProperties.setProperty(PROP_SYSPATH, string);
        return string;
    }

    private static Bundle[] getCurrentBundles(boolean bl) {
        Bundle[] bundleArray = context.getBundles();
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        int n = 0;
        while (n < bundleArray.length) {
            Bundle bundle = bundleArray[n];
            if (bundle.getLocation().startsWith(INITIAL_LOCATION)) {
                if (bl) {
                    arrayList.add(bundle);
                }
            } else if (!bl && bundle.getBundleId() != 0L) {
                arrayList.add(bundle);
            }
            ++n;
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    private static Bundle getBundleByLocation(String string, Bundle[] bundleArray) {
        int n = 0;
        while (n < bundleArray.length) {
            Bundle bundle = bundleArray[n];
            if (string.equalsIgnoreCase(bundle.getLocation())) {
                return bundle;
            }
            ++n;
        }
        return null;
    }

    private static void uninstallBundles(Bundle[] bundleArray, EclipseStarter$InitialBundle[] eclipseStarter$InitialBundleArray, List list) {
        int n = 0;
        while (n < bundleArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < eclipseStarter$InitialBundleArray.length) {
                if (bundleArray[n].getLocation().equalsIgnoreCase(eclipseStarter$InitialBundleArray[n2].locationString)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                try {
                    bundleArray[n].uninstall();
                    list.add(bundleArray[n]);
                }
                catch (BundleException bundleException) {
                    FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_UNINSTALL, bundleArray[n].getLocation()), 0, bundleException, null);
                    log.log(frameworkLogEntry);
                }
            }
            ++n;
        }
    }

    private static void installBundles(EclipseStarter$InitialBundle[] eclipseStarter$InitialBundleArray, Bundle[] bundleArray, ArrayList arrayList, ArrayList arrayList2, List list) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        ServiceReference serviceReference = context.getServiceReference(clazz.getName());
        StartLevel startLevel = null;
        if (serviceReference != null) {
            startLevel = (StartLevel)context.getService(serviceReference);
        }
        try {
            int n = 0;
            while (n < eclipseStarter$InitialBundleArray.length) {
                FrameworkLogEntry frameworkLogEntry;
                Bundle bundle = EclipseStarter.getBundleByLocation(eclipseStarter$InitialBundleArray[n].locationString, bundleArray);
                try {
                    if (bundle == null) {
                        InputStream inputStream = eclipseStarter$InitialBundleArray[n].location.openStream();
                        bundle = context.installBundle(eclipseStarter$InitialBundleArray[n].locationString, inputStream);
                        if (!eclipseStarter$InitialBundleArray[n].start && EclipseStarter.hasLazyActivationPolicy(bundle)) {
                            arrayList2.add(bundle);
                        }
                    }
                    if ((bundle.getState() & 1) == 0 && eclipseStarter$InitialBundleArray[n].level >= 0 && startLevel != null) {
                        startLevel.setBundleStartLevel(bundle, eclipseStarter$InitialBundleArray[n].level);
                    }
                    if (eclipseStarter$InitialBundleArray[n].start) {
                        arrayList.add(bundle);
                    }
                    if ((bundle.getState() & 2) != 0) {
                        list.add(bundle);
                    }
                }
                catch (BundleException bundleException) {
                    frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_INSTALL, eclipseStarter$InitialBundleArray[n].location), 0, bundleException, null);
                    log.log(frameworkLogEntry);
                }
                catch (IOException iOException) {
                    frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_INSTALL, eclipseStarter$InitialBundleArray[n].location), 0, iOException, null);
                    log.log(frameworkLogEntry);
                }
                ++n;
            }
        }
        finally {
            if (serviceReference != null) {
                context.ungetService(serviceReference);
            }
        }
    }

    private static void startBundles(Bundle[] bundleArray, Bundle[] bundleArray2) {
        int n = 0;
        while (n < bundleArray.length) {
            EclipseStarter.startBundle(bundleArray[n], 0);
            ++n;
        }
        n = 0;
        while (n < bundleArray2.length) {
            EclipseStarter.startBundle(bundleArray2[n], 2);
            ++n;
        }
    }

    private static void startBundle(Bundle bundle, int n) {
        block2: {
            try {
                bundle.start(n);
            }
            catch (BundleException bundleException) {
                if ((bundle.getState() & 4) == 0) break block2;
                FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_START, bundle.getLocation()), 0, bundleException, null);
                log.log(frameworkLogEntry);
            }
        }
    }

    private static void loadConfigurationInfo() {
        Location location = LocationManager.getConfigurationLocation();
        if (location == null) {
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(String.valueOf(location.getURL().toExternalForm()) + "config.ini");
        }
        catch (MalformedURLException malformedURLException) {}
        EclipseStarter.mergeProperties(FrameworkProperties.getProperties(), EclipseStarter.loadProperties(uRL));
    }

    private static Properties loadProperties(URL uRL) {
        Properties properties = new Properties();
        if (uRL == null) {
            return properties;
        }
        try {
            InputStream inputStream = uRL.openStream();
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        return properties;
    }

    private static URL makeRelative(URL uRL, URL uRL2) throws MalformedURLException {
        if (uRL == null) {
            return uRL2;
        }
        if (!"file".equals(uRL.getProtocol())) {
            return uRL2;
        }
        if (!uRL2.getProtocol().equals(REFERENCE_PROTOCOL)) {
            return uRL2;
        }
        URL uRL3 = new URL(uRL2.getPath());
        if (!uRL.getProtocol().equals(uRL3.getProtocol())) {
            return uRL2;
        }
        File file = new File(uRL3.getPath());
        if (!file.isAbsolute()) {
            return uRL2;
        }
        File file2 = EclipseStarter.makeRelative(new File(uRL.getPath()), file);
        String string = file2.getPath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (uRL3.getPath().endsWith("/")) {
            string = String.valueOf(string) + '/';
        }
        URL uRL4 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
        uRL4 = new URL(REFERENCE_SCHEME + uRL4.toExternalForm());
        return uRL4;
    }

    private static File makeRelative(File file, File file2) {
        if (!file2.isAbsolute()) {
            return file2;
        }
        File file3 = new File(new FilePath(file).makeRelative(new FilePath(file2)));
        return file3;
    }

    private static void mergeProperties(Properties properties, Properties properties2) {
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties2.getProperty(string);
            if (properties.getProperty(string) != null) continue;
            properties.put(string, string2);
        }
    }

    private static void setStartLevel(int n) {
        ServiceReference serviceReference;
        StartLevel startLevel;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        StartLevel startLevel2 = startLevel = (serviceReference = context.getServiceReference(clazz.getName())) != null ? (StartLevel)context.getService(serviceReference) : null;
        if (startLevel == null) {
            return;
        }
        Semaphore semaphore = new Semaphore(0);
        EclipseStarter$2 eclipseStarter$2 = new EclipseStarter$2(startLevel, n, semaphore);
        context.addFrameworkListener(eclipseStarter$2);
        startLevel.setStartLevel(n);
        context.ungetService(serviceReference);
        EclipseStarter.updateSplash(semaphore, eclipseStarter$2);
    }

    private static void updateSplash(Semaphore semaphore, FrameworkListener frameworkListener) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.runnable.StartupMonitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        ServiceTracker serviceTracker = new ServiceTracker(context, clazz.getName(), null);
        serviceTracker.open();
        try {
            do {
                StartupMonitor startupMonitor;
                if ((startupMonitor = (StartupMonitor)serviceTracker.getService()) == null) continue;
                try {
                    startupMonitor.update();
                }
                catch (Throwable throwable) {}
            } while (!semaphore.acquire(50L));
        }
        finally {
            if (frameworkListener != null) {
                context.removeFrameworkListener(frameworkListener);
            }
            serviceTracker.close();
        }
    }

    private static String searchFor(String string, String string2) {
        String[] stringArray = (String[])searchCandidates.get(string2);
        if (stringArray == null && (stringArray = new File(string2).list()) != null) {
            searchCandidates.put(string2, stringArray);
        }
        if (stringArray == null) {
            return null;
        }
        String string3 = null;
        Object[] objectArray = null;
        int n = 0;
        while (n < stringArray.length) {
            block9: {
                String string4;
                Object[] objectArray2;
                boolean bl;
                String string5;
                block10: {
                    string5 = stringArray[n];
                    if (!string5.startsWith(string)) break block9;
                    bl = false;
                    if (string5.length() <= string.length() || string5.charAt(string.length()) == '_') break block10;
                    if (string5.length() != 4 + string.length() || !string5.endsWith(".jar")) break block9;
                    bl = true;
                }
                if ((objectArray2 = EclipseStarter.getVersionElements(string4 = string5.length() > string.length() + 1 && string5.charAt(string.length()) == '_' ? string5.substring(string.length() + 1) : "")) != null && EclipseStarter.compareVersion(objectArray, objectArray2) < 0) {
                    File file = new File(string2, string5);
                    if (!bl || file.isFile()) {
                        string3 = file.getAbsolutePath();
                        objectArray = objectArray2;
                    }
                }
            }
            ++n;
        }
        if (string3 == null) {
            return null;
        }
        return String.valueOf(string3.replace(File.separatorChar, '/')) + "/";
    }

    private static Object[] getVersionElements(String string) {
        Object[] objectArray = new Object[]{new Integer(-1), new Integer(-1), new Integer(-1), ""};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < 4) {
            String string2 = stringTokenizer.nextToken();
            if (n < 3) {
                try {
                    objectArray[n] = new Integer(string2);
                }
                catch (Exception exception) {
                    if (n != 0) break;
                    return null;
                }
            } else {
                objectArray[n] = string2;
            }
            ++n;
        }
        return objectArray;
    }

    private static int compareVersion(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return -1;
        }
        int n = ((Integer)objectArray[0]).compareTo((Integer)objectArray2[0]);
        if (n != 0) {
            return n;
        }
        n = ((Integer)objectArray[1]).compareTo((Integer)objectArray2[1]);
        if (n != 0) {
            return n;
        }
        n = ((Integer)objectArray[2]).compareTo((Integer)objectArray2[2]);
        if (n != 0) {
            return n;
        }
        return ((String)objectArray[3]).compareTo((String)objectArray2[3]);
    }

    private static void initializeProperties() {
        if (FrameworkProperties.getProperty(PROP_FRAMEWORK) == null || FrameworkProperties.getProperty(PROP_INSTALL_AREA) == null) {
            CodeSource codeSource;
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("org.eclipse.core.runtime.adaptor.EclipseStarter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            if ((codeSource = clazz.getProtectionDomain().getCodeSource()) == null) {
                throw (Throwable)new IllegalArgumentException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_PROPS_NOT_SET, "osgi.framework, osgi.install.area"));
            }
            URL uRL = codeSource.getLocation();
            if (FrameworkProperties.getProperty(PROP_FRAMEWORK) == null) {
                FrameworkProperties.setProperty(PROP_FRAMEWORK, uRL.toExternalForm());
            }
            if (FrameworkProperties.getProperty(PROP_INSTALL_AREA) == null) {
                String string = uRL.getFile();
                FrameworkProperties.setProperty(PROP_INSTALL_AREA, string.substring(0, string.lastIndexOf(47)));
            }
        }
        FrameworkProperties.setProperty(PROP_FRAMEWORK, EclipseStarter.decode(FrameworkProperties.getProperty(PROP_FRAMEWORK)));
        FrameworkProperties.setProperty(PROP_INSTALL_AREA, EclipseStarter.decode(FrameworkProperties.getProperty(PROP_INSTALL_AREA)));
    }

    private static void finalizeProperties() {
        if (FrameworkProperties.getProperty(PROP_DEV) != null && FrameworkProperties.getProperty(PROP_CHECK_CONFIG) == null) {
            FrameworkProperties.setProperty(PROP_CHECK_CONFIG, "true");
        }
    }

    private static String decode(String string) {
        char c;
        int n;
        Object object;
        Object object2;
        try {
            Object object3;
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("java.net.URLDecoder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Class[] classArray = new Class[2];
            Class<?> clazz3 = class$10;
            if (clazz3 == null) {
                try {
                    clazz3 = class$10 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            classArray[0] = clazz3;
            Class<?> clazz4 = class$10;
            if (clazz4 == null) {
                try {
                    clazz4 = class$10 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            classArray[1] = clazz4;
            object2 = clazz2.getDeclaredMethod("decode", classArray);
            if (string.indexOf(43) >= 0) {
                int n2 = string.length();
                object = new StringBuffer(n2);
                n = 0;
                while (n < n2) {
                    c = string.charAt(n);
                    if (c == '+') {
                        ((StringBuffer)object).append("%2B");
                    } else {
                        ((StringBuffer)object).append(c);
                    }
                    ++n;
                }
                string = ((StringBuffer)object).toString();
            }
            if ((object3 = ((Method)object2).invoke(null, string, "UTF-8")) != null) {
                return (String)object3;
            }
        }
        catch (Exception exception) {}
        boolean bl = false;
        object2 = string.getBytes();
        char c2 = ((byte[])object2).length;
        object = new byte[c2];
        n = 0;
        c = '\u0000';
        while (c < c2) {
            byte by = object2[c];
            if (by == 37) {
                byte by2 = object2[++c];
                byte by3 = object2[++c];
                by = (byte)((EclipseStarter.hexToByte(by2) << 4) + EclipseStarter.hexToByte(by3));
                bl = true;
            }
            object[n++] = by;
            ++c;
        }
        if (!bl) {
            return string;
        }
        try {
            return new String((byte[])object, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String((byte[])object, 0, n);
        }
    }

    private static boolean isForcedRestart() {
        return Boolean.valueOf(FrameworkProperties.getProperty(PROP_FORCED_RESTART));
    }

    private static void registerFrameworkShutdownHandlers() {
        if (shutdownHandlers == null) {
            return;
        }
        Bundle bundle = context.getBundle();
        Iterator iterator = shutdownHandlers.iterator();
        while (iterator.hasNext()) {
            Runnable runnable = (Runnable)iterator.next();
            EclipseStarter$3 eclipseStarter$3 = new EclipseStarter$3(bundle, runnable);
            context.addBundleListener(eclipseStarter$3);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        EclipseStarter$$Cold.main(stringArray);
    }

    protected static FrameworkLog createFrameworkLog() throws  {
        return EclipseStarter$$Cold.createFrameworkLog();
    }

    private static void logUnresolvedBundles(Bundle[] bundleArray) {
        int n;
        Object[] objectArray;
        VersionConstraint[] versionConstraintArray;
        FrameworkLogEntry[] frameworkLogEntryArray;
        Object object;
        Object object2;
        Object object3;
        State state = adaptor.getState();
        FrameworkLog frameworkLog = adaptor.getFrameworkLog();
        StateHelper stateHelper = adaptor.getPlatformAdmin().getStateHelper();
        VersionConstraint[] versionConstraintArray2 = stateHelper.getUnsatisfiedLeaves(state.getBundles());
        HashMap<BundleDescription, Object> hashMap = new HashMap<BundleDescription, Object>();
        int n2 = 0;
        while (n2 < versionConstraintArray2.length) {
            if (!(versionConstraintArray2[n2] instanceof BundleSpecification && ((BundleSpecification)versionConstraintArray2[n2]).isOptional() || versionConstraintArray2[n2] instanceof ImportPackageSpecification && ("optional".equals(((ImportPackageSpecification)versionConstraintArray2[n2]).getDirective("resolution")) || "dynamic".equals(((ImportPackageSpecification)versionConstraintArray2[n2]).getDirective("resolution"))))) {
                BundleDescription bundleDescription = versionConstraintArray2[n2].getBundle();
                object3 = (ArrayList)hashMap.get(bundleDescription);
                if (object3 == null) {
                    object3 = new ArrayList<VersionConstraint>();
                    hashMap.put(bundleDescription, object3);
                }
                ((ArrayList)object3).add(versionConstraintArray2[n2]);
            }
            ++n2;
        }
        if (hashMap.size() > 0) {
            FrameworkLogEntry[] frameworkLogEntryArray2 = new FrameworkLogEntry[hashMap.size()];
            int n3 = 0;
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (BundleDescription)object3.next();
                object = object2.getSymbolicName() == null ? "org.eclipse.osgi" : object2.getSymbolicName();
                frameworkLogEntryArray = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, object2.getLocation());
                versionConstraintArray = (VersionConstraint[])hashMap.get(object2);
                objectArray = new FrameworkLogEntry[versionConstraintArray.size()];
                n = 0;
                while (n < objectArray.length) {
                    objectArray[n] = new FrameworkLogEntry((String)object, 2, 0, MessageHelper.getResolutionFailureMessage((VersionConstraint)versionConstraintArray.get(n)), 0, null, null);
                    ++n;
                }
                frameworkLogEntryArray2[n3] = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, (String)frameworkLogEntryArray, 0, null, (FrameworkLogEntry[])objectArray);
                ++n3;
            }
            frameworkLog.log(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_ROOTS_NOT_RESOLVED, 0, null, frameworkLogEntryArray2));
        }
        ArrayList<FrameworkLogEntry> arrayList = new ArrayList<FrameworkLogEntry>();
        int n4 = 0;
        while (n4 < bundleArray.length) {
            if (bundleArray[n4].getState() == 2) {
                object3 = bundleArray[n4].getSymbolicName() == null ? "org.eclipse.osgi" : bundleArray[n4].getSymbolicName();
                object2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, bundleArray[n4]);
                object = state.getBundle(bundleArray[n4].getBundleId());
                if (object != null) {
                    frameworkLogEntryArray = null;
                    versionConstraintArray = stateHelper.getUnsatisfiedConstraints((BundleDescription)object);
                    if (versionConstraintArray.length > 0) {
                        frameworkLogEntryArray = new FrameworkLogEntry[versionConstraintArray.length];
                        int n5 = 0;
                        while (n5 < versionConstraintArray.length) {
                            frameworkLogEntryArray[n5] = new FrameworkLogEntry((String)object3, 2, 0, MessageHelper.getResolutionFailureMessage(versionConstraintArray[n5]), 0, null, null);
                            ++n5;
                        }
                    } else {
                        objectArray = state.getResolverErrors((BundleDescription)object);
                        if (objectArray.length > 0) {
                            frameworkLogEntryArray = new FrameworkLogEntry[objectArray.length];
                            n = 0;
                            while (n < objectArray.length) {
                                frameworkLogEntryArray[n] = new FrameworkLogEntry((String)object3, 2, 0, objectArray[n].toString(), 0, null, null);
                                ++n;
                            }
                        }
                    }
                    arrayList.add(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, (String)object2, 0, null, frameworkLogEntryArray));
                }
            }
            ++n4;
        }
        if (arrayList.size() > 0) {
            frameworkLog.log(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_ALL_NOT_RESOLVED, 0, null, arrayList.toArray(new FrameworkLogEntry[arrayList.size()])));
        }
    }

    private static void startConsole(OSGi oSGi, String[] stringArray, String string) {
        try {
            Object[] objectArray;
            Class[] classArray;
            String string2 = FrameworkProperties.getProperty(PROP_CONSOLE_CLASS, DEFAULT_CONSOLE_CLASS);
            Class<?> clazz = Class.forName(string2);
            if (string.length() == 0) {
                Class[] classArray2 = new Class[2];
                Class<?> clazz2 = class$5;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$5 = Class.forName("org.eclipse.osgi.framework.internal.core.OSGi");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                classArray2[0] = clazz2;
                Class<?> clazz3 = class$6;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$6 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                classArray2[1] = clazz3;
                classArray = classArray2;
                objectArray = new Object[]{oSGi, stringArray};
            } else {
                Class[] classArray3 = new Class[3];
                Class<?> clazz4 = class$5;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$5 = Class.forName("org.eclipse.osgi.framework.internal.core.OSGi");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                classArray3[0] = clazz4;
                classArray3[1] = Integer.TYPE;
                Class<?> clazz5 = class$6;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$6 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                classArray3[2] = clazz5;
                classArray = classArray3;
                objectArray = new Object[]{oSGi, new Integer(string), stringArray};
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            console = (Runnable)constructor.newInstance(objectArray);
            Thread thread = new Thread(console, CONSOLE_NAME);
            thread.start();
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_INVALID_PORT, string));
        }
        catch (Exception exception) {
            System.out.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_FIND, CONSOLE_NAME));
        }
    }

    private static String getSysPathFromURL(String string) throws  {
        return EclipseStarter$$Cold.getSysPathFromURL(string);
    }

    private static String getSysPathFromCodeSource() throws  {
        return EclipseStarter$$Cold.getSysPathFromCodeSource();
    }

    private static boolean hasLazyActivationPolicy(Bundle bundle) throws  {
        return EclipseStarter$$Cold.hasLazyActivationPolicy(bundle);
    }

    private static int hexToByte(byte by) throws  {
        return EclipseStarter$$Cold.hexToByte(by);
    }

    public static void setInitialProperties(Map map) throws  {
        EclipseStarter$$Cold.setInitialProperties(map);
    }

    public static BundleContext getSystemBundleContext() {
        if (context == null || !running) {
            return null;
        }
        return context.getBundle().getBundleContext();
    }

    static void internalAddFrameworkShutdownHandler(Runnable runnable) {
        if (running) {
            throw (Throwable)new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        if (shutdownHandlers == null) {
            shutdownHandlers = new ArrayList();
        }
        shutdownHandlers.add(runnable);
    }

    static void internalRemoveFrameworkShutdownHandler(Runnable runnable) {
        if (running) {
            throw (Throwable)new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        if (shutdownHandlers != null) {
            shutdownHandlers.remove(runnable);
        }
    }
}

