/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;

public class EclipseLog$$Cold {
    public static void $init$(EclipseLog eclipseLog, Writer writer) {
        eclipseLog.consoleLog = false;
        eclipseLog.newSession = true;
        eclipseLog.maxLogSize = 1000;
        eclipseLog.maxLogFiles = 10;
        eclipseLog.backupIdx = 0;
        eclipseLog.writer = writer == null ? eclipseLog.logForStream(System.err) : writer;
    }

    /*
     * Unable to fully structure code
     */
    public static StringBuffer appendPaddedInt(EclipseLog var0, int var1_1, int var2_2, StringBuffer var3_3) {
        if (--var2_2 == 0) {
            return var3_3.append(Integer.toString(var1_1));
        }
        var4_4 = (int)Math.pow(10.0, var2_2);
        if (var1_1 < var4_4) ** GOTO lbl9
        return var3_3.append(Integer.toString(var1_1));
lbl-1000:
        // 1 sources

        {
            var3_3.append('0');
            var4_4 /= 10;
lbl9:
            // 2 sources

            ** while (var4_4 > var1_1 && var4_4 > 1)
        }
lbl10:
        // 1 sources

        var3_3.append(var1_1);
        return var3_3;
    }

    public static void close(EclipseLog eclipseLog) {
        try {
            if (eclipseLog.writer != null) {
                Writer writer = eclipseLog.writer;
                eclipseLog.writer = null;
                writer.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void closeFile(EclipseLog eclipseLog) {
        if (eclipseLog.outFile != null && eclipseLog.writer != null) {
            try {
                eclipseLog.writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            eclipseLog.writer = null;
        }
    }

    public static void copyReader(EclipseLog eclipseLog, Reader reader, Writer writer) {
        int n;
        char[] cArray = new char[1024];
        while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
            writer.write(cArray, 0, n);
        }
    }

    public static String getSessionTimestamp(EclipseLog eclipseLog) {
        String string = FrameworkProperties.getProperty("eclipse.startTime");
        if (string != null) {
            try {
                return eclipseLog.getDate(new Date(Long.parseLong(string)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return eclipseLog.getDate(new Date());
    }

    public static void log(EclipseLog eclipseLog, FrameworkLogEntry frameworkLogEntry) {
        if (frameworkLogEntry == null) {
            return;
        }
        try {
            try {
                eclipseLog.checkLogFileSize();
                eclipseLog.openFile();
                if (eclipseLog.newSession) {
                    eclipseLog.writeSession();
                    eclipseLog.newSession = false;
                }
                eclipseLog.writeLog(0, frameworkLogEntry);
                eclipseLog.writer.flush();
            }
            catch (Exception exception) {
                System.err.println("An exception occurred while writing to the platform log:");
                exception.printStackTrace(System.err);
                System.err.println("Logging to the console instead.");
                try {
                    eclipseLog.writer = eclipseLog.logForStream(System.err);
                    eclipseLog.writeLog(0, frameworkLogEntry);
                    eclipseLog.writer.flush();
                }
                catch (Exception exception2) {
                    System.err.println("An exception occurred while logging to the console:");
                    exception2.printStackTrace(System.err);
                }
                eclipseLog.closeFile();
            }
        }
        finally {
            eclipseLog.closeFile();
        }
    }

    public static void log(EclipseLog eclipseLog, FrameworkEvent frameworkEvent) {
        int n;
        Bundle bundle = frameworkEvent.getBundle();
        Throwable throwable = frameworkEvent.getThrowable();
        String string = bundle.getSymbolicName() == null ? bundle.getLocation() : bundle.getSymbolicName();
        switch (frameworkEvent.getType()) {
            case 32: {
                n = 1;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 16: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        FrameworkLogEntry frameworkLogEntry = new FrameworkLogEntry(string, n, 0, "", 0, throwable, null);
        eclipseLog.log(frameworkLogEntry);
    }

    public static Writer logForStream(EclipseLog eclipseLog, OutputStream outputStream) {
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    public static void write(EclipseLog eclipseLog, String string) {
        if (string != null) {
            eclipseLog.writer.write(string);
            if (eclipseLog.consoleLog) {
                System.out.print(string);
            }
        }
    }

    public static void writeArgs(EclipseLog eclipseLog, String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        eclipseLog.write(string);
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0 && "-password".equals(stringArray[n - 1])) {
                eclipseLog.write(" (omitted)");
            } else {
                eclipseLog.write(" " + stringArray[n]);
            }
            ++n;
        }
        eclipseLog.writeln();
    }

    public static void writeEntry(EclipseLog eclipseLog, int n, FrameworkLogEntry frameworkLogEntry) {
        if (n == 0) {
            eclipseLog.writeln();
            eclipseLog.write("!ENTRY");
        } else {
            eclipseLog.write("!SUBENTRY");
            eclipseLog.writeSpace();
            eclipseLog.write(Integer.toString(n));
        }
        eclipseLog.writeSpace();
        eclipseLog.write(frameworkLogEntry.getEntry());
        if (frameworkLogEntry.getSeverity() != 0 || frameworkLogEntry.getBundleCode() != 0) {
            eclipseLog.writeSpace();
            eclipseLog.write(Integer.toString(frameworkLogEntry.getSeverity()));
            eclipseLog.writeSpace();
            eclipseLog.write(Integer.toString(frameworkLogEntry.getBundleCode()));
        }
        eclipseLog.writeSpace();
        eclipseLog.write(eclipseLog.getDate(new Date()));
        eclipseLog.writeln();
    }

    public static void writeLog(EclipseLog eclipseLog, int n, FrameworkLogEntry frameworkLogEntry) {
        eclipseLog.writeEntry(n, frameworkLogEntry);
        eclipseLog.writeMessage(frameworkLogEntry);
        eclipseLog.writeStack(frameworkLogEntry);
        FrameworkLogEntry[] frameworkLogEntryArray = frameworkLogEntry.getChildren();
        if (frameworkLogEntryArray != null) {
            int n2 = 0;
            while (n2 < frameworkLogEntryArray.length) {
                eclipseLog.writeLog(n + 1, frameworkLogEntryArray[n2]);
                ++n2;
            }
        }
    }

    public static void writeMessage(EclipseLog eclipseLog, FrameworkLogEntry frameworkLogEntry) {
        eclipseLog.write("!MESSAGE");
        eclipseLog.writeSpace();
        eclipseLog.writeln(frameworkLogEntry.getMessage());
    }

    public static void writeSession(EclipseLog eclipseLog) {
        eclipseLog.write("!SESSION");
        eclipseLog.writeSpace();
        String string = eclipseLog.getSessionTimestamp();
        eclipseLog.write(string);
        eclipseLog.writeSpace();
        int n = "!SESSION".length() + string.length();
        while (n < 78) {
            eclipseLog.write("-");
            ++n;
        }
        eclipseLog.writeln();
        try {
            String string2 = "eclipse.buildId";
            String string3 = FrameworkProperties.getProperty(string2, "unknown");
            eclipseLog.writeln(String.valueOf(string2) + "=" + string3);
            string2 = "java.fullversion";
            string3 = System.getProperty(string2);
            if (string3 == null) {
                string2 = "java.version";
                string3 = System.getProperty(string2);
                eclipseLog.writeln(String.valueOf(string2) + "=" + string3);
                string2 = "java.vendor";
                string3 = System.getProperty(string2);
                eclipseLog.writeln(String.valueOf(string2) + "=" + string3);
            } else {
                eclipseLog.writeln(String.valueOf(string2) + "=" + string3);
            }
        }
        catch (Exception exception) {}
        eclipseLog.write("BootLoader constants: OS=" + EclipseEnvironmentInfo.getDefault().getOS());
        eclipseLog.write(", ARCH=" + EclipseEnvironmentInfo.getDefault().getOSArch());
        eclipseLog.write(", WS=" + EclipseEnvironmentInfo.getDefault().getWS());
        eclipseLog.writeln(", NL=" + EclipseEnvironmentInfo.getDefault().getNL());
        eclipseLog.writeArgs("Framework arguments: ", EclipseEnvironmentInfo.getDefault().getNonFrameworkArgs());
        eclipseLog.writeArgs("Command-line arguments: ", EclipseEnvironmentInfo.getDefault().getCommandLineArgs());
    }

    public static void writeStack(EclipseLog eclipseLog, FrameworkLogEntry frameworkLogEntry) {
        Throwable throwable = frameworkLogEntry.getThrowable();
        if (throwable != null) {
            String string = eclipseLog.getStackTrace(throwable);
            eclipseLog.write("!STACK");
            eclipseLog.writeSpace();
            eclipseLog.write(Integer.toString(frameworkLogEntry.getStackCode()));
            eclipseLog.writeln();
            eclipseLog.write(string);
        }
    }
}

