/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class PlatformURLFragmentConnection
extends PlatformURLConnection {
    private Bundle target = null;
    private static boolean isRegistered = false;
    public static final String FRAGMENT = "fragment";
    static Class class$0;

    public PlatformURLFragmentConnection(URL uRL) {
        super(uRL);
    }

    protected boolean allowCaching() {
        return true;
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.runtime.PlatformURLFragmentConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        PlatformURLHandler.register(FRAGMENT, clazz);
        isRegistered = true;
    }

    protected URL resolve() throws IOException {
        String string = this.url.getFile().trim();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith(FRAGMENT)) {
            throw (Throwable)new IOException(NLS.bind((String)CommonMessages.url_badVariant, (Object)this.url));
        }
        int n = string.indexOf("/", FRAGMENT.length() + 1);
        String string2 = n == -1 ? string.substring(FRAGMENT.length() + 1) : string.substring(FRAGMENT.length() + 1, n);
        String string3 = this.getId(string2);
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw (Throwable)new IOException(CommonMessages.activator_not_available);
        }
        this.target = activator.getBundle(string3);
        if (this.target == null) {
            throw (Throwable)new IOException(NLS.bind((String)CommonMessages.url_resolveFragment, (Object)this.url));
        }
        URL uRL = this.target.getEntry("/");
        if (n == -1 || n + 1 >= string.length()) {
            return uRL;
        }
        return new URL(uRL, string.substring(n + 1));
    }
}

