/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.runtime.Activator;

public class DevClassPathHelper {
    public static final String PROP_DEV = "osgi.dev";
    protected static boolean inDevelopmentMode;
    protected static String[] devDefaultClasspath;
    protected static Properties devProperties;

    static {
        String string;
        inDevelopmentMode = false;
        devProperties = null;
        String string2 = string = Activator.getContext() == null ? System.getProperty(PROP_DEV) : Activator.getContext().getProperty(PROP_DEV);
        if (string != null) {
            try {
                inDevelopmentMode = true;
                URL uRL = new URL(string);
                devProperties = DevClassPathHelper.load(uRL);
                if (devProperties != null) {
                    devDefaultClasspath = DevClassPathHelper.getArrayFromList(devProperties.getProperty("*"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                devDefaultClasspath = DevClassPathHelper.getArrayFromList(string);
            }
        }
    }

    public static String[] getDevClassPath(String string) {
        String string2;
        String[] stringArray = null;
        if (string != null && devProperties != null && (string2 = devProperties.getProperty(string)) != null) {
            stringArray = DevClassPathHelper.getArrayFromList(string2);
        }
        if (stringArray == null) {
            stringArray = devDefaultClasspath;
        }
        return stringArray;
    }

    public static String[] getArrayFromList(String string) {
        if (string == null || string.trim().equals("")) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? new String[]{} : vector.toArray(new String[vector.size()]);
    }

    public static boolean inDevelopmentMode() {
        return inDevelopmentMode;
    }

    private static Properties load(URL uRL) {
        Properties properties = new Properties();
        try {
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                properties.load(inputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException iOException) {}
        return properties;
    }
}

