/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.viewer;

import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.core.meeting.CollaborationMeetingEvent;
import com.ibm.team.collaboration.core.meeting.MeetingInvitationRequest;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingView;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingViewer;
import com.ibm.team.collaboration.ui.viewer.ICollaborationViewerUI;
import com.ibm.team.foundation.client.util.FoundationJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class ChatMeetingViewerUI
implements ICollaborationViewerUI {
    private static final IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    static final ChatMeetingView showView() throws PartInitException {
        IViewPart part;
        IWorkbenchPage page = ChatMeetingViewerUI.getActivePage();
        if (page != null && (part = page.showView("com.ibm.team.collaboration.ui.internal.chatView", null, 3)) instanceof ChatMeetingView) {
            return (ChatMeetingView)part;
        }
        return null;
    }

    public IStatus manageMeeting(final CollaborationMeetingEvent event, IProgressMonitor monitor) {
        Assert.isNotNull((Object)event);
        final IStatus[] result = new IStatus[]{Status.OK_STATUS};
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                public final void run() {
                    ChatMeetingView view = null;
                    try {
                        view = ChatMeetingViewerUI.showView();
                        if (view == null) {
                            result[0] = new Status(4, "com.ibm.team.collaboration.chat.rcp.ui", ChatMessages.ChatMeetingViewerUI_0);
                            return;
                        }
                    }
                    catch (PartInitException exception) {
                        result[0] = new Status(4, "com.ibm.team.collaboration.chat.rcp.ui", ChatMessages.ChatMeetingViewerUI_1, (Throwable)exception);
                        return;
                    }
                    CollaborationMeeting meeting = event.getMeeting();
                    String id = meeting.getId();
                    Control control = view.getControl();
                    try {
                        control.setRedraw(false);
                        ChatMeetingViewer viewer = view.getViewer(id);
                        if (viewer == null) {
                            viewer = new ChatMeetingViewer(meeting);
                            view.addViewer(viewer);
                        } else if (viewer.isSealed()) {
                            viewer = new ChatMeetingViewer(meeting);
                            view.replaceViewer(id, viewer);
                        }
                        int type = event.getType();
                        if (2 == type) {
                            boolean activate = false;
                            CollaborationData data = event.getData();
                            if (data instanceof MeetingInvitationRequest) {
                                MeetingInvitationRequest request = (MeetingInvitationRequest)data;
                                activate = !request.isRemote();
                            }
                            view.setActiveViewer(id, activate);
                        } else {
                            final ChatMeetingViewer finalViewer = viewer;
                            FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingView_21){

                                protected IStatus runProtected(IProgressMonitor progress) {
                                    finalViewer.refreshLabel(progress);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setPriority(20);
                            job.setSystem(true);
                            job.schedule();
                        }
                    }
                    finally {
                        control.setRedraw(true);
                    }
                }
            });
        }
        return result[0];
    }
}

