/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.viewer;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.account.CollaborationAccountEvent;
import com.ibm.team.collaboration.core.account.ICollaborationAccountListener;
import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.core.service.CollaborationServiceJob;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationSessionEvent;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.collaboration.internal.chat.ui.CollaborationChatPlugin;
import com.ibm.team.collaboration.internal.chat.ui.action.StartChatAction;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingSite;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingViewer;
import com.ibm.team.collaboration.internal.core.service.DefaultCollaborationService;
import com.ibm.team.collaboration.internal.ui.CollaborationUIPlugin;
import com.ibm.team.collaboration.internal.ui.action.ChangePresenceAction;
import com.ibm.team.collaboration.internal.ui.util.ChangePresenceMenuCreator;
import com.ibm.team.collaboration.internal.ui.util.CollaborationExceptionHandler;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.ActiveControlTracker;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormSelectionProvider;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public final class ChatMeetingView
extends ViewPart {
    private static final String PREFERENCE_SHOW_PRESENCE_TRIM = "com.ibm.team.collaboration.show.presence.trim";
    private static final String TEAM_ARTIFACTS_VIEW_ID = "com.ibm.team.process.rcp.ui.teamArtifactsNavigator";
    static final String VIEW_ID = "com.ibm.team.collaboration.ui.internal.chatView";
    private ActiveControlTracker fActiveControlTracker;
    private Image fAlertImage;
    ChatMeetingViewAlertJob fAlertJob = null;
    final ChangePresenceAction fChangePresenceAction = new ChangePresenceAction(new ChangePresenceMenuCreator());
    final Separator fChangePresenceSeparator = new Separator("com.ibm.team.collaboration.ui.separator");
    ChatMeetingViewerPage fChatMeetingPage;
    private final List<CommandAction> fCommandActions = new ArrayList<CommandAction>(5);
    final Map<CTabItem, ChatMeetingSite> fCurrentMeetingSites = new HashMap<CTabItem, ChatMeetingSite>(4);
    final Map<String, CTabItem> fCurrentViewerTabs = new HashMap<String, CTabItem>(4);
    LoggedOutTeamRepositoryPage fLoggedOutRepositoryPage;
    MissingCollaborationAccountsPage fMissingAccountsPage;
    MissingTeamRepositoryPage fMissingRepositoryPage;
    MissingServiceConnectionPage fMissingServiceConnectionPage;
    private IPartListener2 fPartListener;
    private final IPropertyChangeListener fPropertyChangeListener = new ChatMeetingViewPropertyChangeListener();
    final StartChatAction fStartChatAction = new StartChatAction();
    private Image fViewImage = null;
    final ListenerList fViewListeners = new ListenerList(1);
    PageBook fViewPageBook;
    private final ChatMeetingViewPageListener fViewPageListener = new ChatMeetingViewPageListener();
    CTabFolder fViewTabFolder;

    static void asyncExec(final Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!display.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    static boolean isLoggedIn() {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repository.loggedIn()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addViewer(ChatMeetingViewer viewer) {
        this.addViewer(viewer, null, this.fViewTabFolder.getItemCount());
    }

    void addViewer(final ChatMeetingViewer viewer, ChatMeetingViewer predecessor, int index) {
        final CTabItem item = new CTabItem(this.fViewTabFolder, 64, index);
        String label = ChatMessages.ChatMeetingView_18;
        item.setText(label);
        item.setToolTipText(label);
        item.setData((Object)viewer);
        Composite composite = new Composite((Composite)this.fViewTabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1536));
        item.setControl((Control)composite);
        ChatMeetingSite site = new ChatMeetingSite(this, viewer, item);
        viewer.init(site);
        viewer.createControl(composite, predecessor);
        this.fCurrentMeetingSites.put(item, site);
        this.fCurrentViewerTabs.put(viewer.getId(), item);
        int count = this.fViewTabFolder.getItemCount() - 1;
        if (count == 0) {
            this.fViewTabFolder.setSelection(count);
            this.handleActiveViewerChanged();
        }
        this.updateContentDescription();
        this.fireViewerAdded(viewer);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                Assert.isNotNull((Object)event);
                ChatMeetingView.this.fireViewerRemoved(viewer);
                viewer.dispose();
                ChatMeetingView.this.fCurrentMeetingSites.remove(item);
                ChatMeetingView.this.fCurrentViewerTabs.remove(viewer.getId());
                ChatMeetingView.this.updateContentDescription();
                ChatMeetingView.this.updateViewPage();
                IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)ChatMeetingView.this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                if (service != null) {
                    try {
                        service.decrementBusy();
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }

    public void addViewListener(IChatMeetingViewListener listener) {
        Assert.isNotNull((Object)listener);
        this.fViewListeners.add((Object)listener);
    }

    public void createPartControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fActiveControlTracker = new ActiveControlTracker(parent);
        this.fViewPageBook = new PageBook(parent, 0);
        PageSite site = new PageSite(this.getViewSite());
        this.fChatMeetingPage = new ChatMeetingViewerPage();
        this.fChatMeetingPage.init((IPageSite)site);
        this.fChatMeetingPage.createControl((Composite)this.fViewPageBook);
        this.fMissingAccountsPage = new MissingCollaborationAccountsPage();
        this.fMissingAccountsPage.init((IPageSite)site);
        this.fMissingAccountsPage.createControl((Composite)this.fViewPageBook);
        this.fMissingRepositoryPage = new MissingTeamRepositoryPage();
        this.fMissingRepositoryPage.init((IPageSite)site);
        this.fMissingRepositoryPage.createControl((Composite)this.fViewPageBook);
        this.fLoggedOutRepositoryPage = new LoggedOutTeamRepositoryPage();
        this.fLoggedOutRepositoryPage.init((IPageSite)site);
        this.fLoggedOutRepositoryPage.createControl((Composite)this.fViewPageBook);
        this.fMissingServiceConnectionPage = new MissingServiceConnectionPage();
        this.fMissingServiceConnectionPage.init((IPageSite)site);
        this.fMissingServiceConnectionPage.createControl((Composite)this.fViewPageBook);
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fViewPageListener);
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            repository.addGenericListener((Object)"state", (IListener)this.fViewPageListener);
            ++n2;
        }
        CollaborationCore.getCollaborationService().addSessionListener((ICollaborationSessionListener)this.fViewPageListener);
        CollaborationCore.getCollaborationService().getAccountManager().addAccountListener((ICollaborationAccountListener)this.fViewPageListener);
        IActionBars bars = this.getViewSite().getActionBars();
        IServiceLocator locator = bars.getServiceLocator();
        bars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, (IAction)this.registerAction(new CommandAction(locator, "org.eclipse.ui.edit.undo")));
        bars.setGlobalActionHandler(ITextEditorActionConstants.REDO, (IAction)this.registerAction(new CommandAction(locator, "org.eclipse.ui.edit.redo")));
        bars.setGlobalActionHandler(ITextEditorActionConstants.CUT, (IAction)this.registerAction(new CommandAction(locator, "org.eclipse.ui.edit.cut")));
        bars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.registerAction(new CommandAction(locator, "org.eclipse.ui.edit.copy")));
        bars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, (IAction)this.registerAction(new CommandAction(locator, "org.eclipse.ui.edit.paste")));
        IToolBarManager manager = bars.getToolBarManager();
        IPreferenceStore store = CollaborationUIPlugin.getInstance().getPreferenceStore();
        store.addPropertyChangeListener(this.fPropertyChangeListener);
        if (!store.getBoolean(PREFERENCE_SHOW_PRESENCE_TRIM)) {
            manager.add((IAction)this.fChangePresenceAction);
            manager.add((IContributionItem)this.fChangePresenceSeparator);
        }
        manager.add((IAction)this.fStartChatAction);
        bars.updateActionBars();
        this.updateViewPage();
        this.updateContentDescription();
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference reference) {
                if (reference.getId().equals(ChatMeetingView.VIEW_ID)) {
                    ChatMeetingView.this.hideAlert();
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference reference) {
                if (reference.getId().equals(ChatMeetingView.VIEW_ID)) {
                    ChatMeetingView.this.hideAlert();
                }
            }

            public void partClosed(IWorkbenchPartReference reference) {
            }

            public void partDeactivated(IWorkbenchPartReference reference) {
            }

            public void partHidden(IWorkbenchPartReference reference) {
            }

            public void partInputChanged(IWorkbenchPartReference reference) {
            }

            public void partOpened(IWorkbenchPartReference reference) {
                if (reference.getId().equals(ChatMeetingView.VIEW_ID)) {
                    ChatMeetingView.this.hideAlert();
                }
            }

            public void partVisible(IWorkbenchPartReference reference) {
                if (reference.getId().equals(ChatMeetingView.VIEW_ID)) {
                    ChatMeetingView.this.hideAlert();
                }
            }
        };
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.getSite().getKeyBindingService().setScopes(new String[]{"com.ibm.magnolia.styledEditingScope", "com.ibm.team.collaboration.ui.commands"});
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.collaboration.ui.chat_view");
    }

    public void dispose() {
        this.getViewSite().getPage().removePartListener(this.fPartListener);
        this.hideAlert();
        IPreferenceStore store = CollaborationUIPlugin.getInstance().getPreferenceStore();
        store.removePropertyChangeListener(this.fPropertyChangeListener);
        for (CommandAction action : this.fCommandActions) {
            action.dispose();
        }
        super.dispose();
        this.fChangePresenceAction.dispose();
        for (ChatMeetingSite site : this.fCurrentMeetingSites.values()) {
            site.getViewer().dispose();
        }
        if (this.fViewImage != null && !this.fViewImage.isDisposed()) {
            this.fViewImage.dispose();
            this.fViewImage = null;
        }
        if (this.fAlertImage != null && !this.fAlertImage.isDisposed()) {
            this.fAlertImage.dispose();
            this.fAlertImage = null;
        }
        this.fCurrentMeetingSites.clear();
        this.fCurrentViewerTabs.clear();
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fViewPageListener);
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            repository.removeGenericListener((Object)"state", (IListener)this.fViewPageListener);
            ++n2;
        }
        CollaborationCore.getCollaborationService().removeSessionListener((ICollaborationSessionListener)this.fViewPageListener);
        CollaborationCore.getCollaborationService().getAccountManager().removeAccountListener((ICollaborationAccountListener)this.fViewPageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireViewerAdded(final ChatMeetingViewer viewer) {
        Assert.isNotNull((Object)viewer);
        ListenerList listenerList = this.fViewListeners;
        synchronized (listenerList) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fViewListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                final IChatMeetingViewListener listener = (IChatMeetingViewListener)object;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        CollaborationChatPlugin.getInstance().log(exception);
                    }

                    public void run() throws Exception {
                        listener.chatViewerAdded(viewer);
                    }
                });
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireViewerRemoved(final ChatMeetingViewer viewer) {
        Assert.isNotNull((Object)viewer);
        ListenerList listenerList = this.fViewListeners;
        synchronized (listenerList) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fViewListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                final IChatMeetingViewListener listener = (IChatMeetingViewListener)object;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        CollaborationChatPlugin.getInstance().log(exception);
                    }

                    public void run() throws Exception {
                        listener.chatViewerRemoved(viewer);
                    }
                });
                ++n2;
            }
        }
    }

    public ChatMeetingViewer getActiveViewer() {
        CTabItem item = this.fViewTabFolder.getSelection();
        if (item != null && !item.isDisposed()) {
            return (ChatMeetingViewer)item.getData();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        ChatMeetingViewer viewer;
        Assert.isNotNull((Object)adapter);
        if (ActiveControlTracker.class.equals((Object)adapter)) {
            return this.fActiveControlTracker;
        }
        if (IServiceLocator.class.equals((Object)adapter)) {
            return this.getSite();
        }
        if (CollaborationMeeting.class.equals((Object)adapter) && (viewer = this.getActiveViewer()) != null) {
            return viewer.getMeeting();
        }
        if (ITextViewer.class.equals((Object)adapter) && (viewer = this.getActiveViewer()) != null) {
            return viewer.getTranscriptViewer();
        }
        return super.getAdapter(adapter);
    }

    public Control getControl() {
        return this.fViewPageBook;
    }

    public ChatMeetingViewer getViewer(String id) {
        ChatMeetingSite site;
        Assert.isNotNull((Object)id);
        CTabItem item = this.fCurrentViewerTabs.get(id);
        if (item != null && (site = this.fCurrentMeetingSites.get(item)) != null) {
            return site.getViewer();
        }
        return null;
    }

    void handleActiveViewerChanged() {
        ChatMeetingSite meetingSite;
        CTabItem item;
        IWorkbenchPartSite viewSite = this.getSite();
        if (viewSite != null && (item = this.fViewTabFolder.getSelection()) != null && this == viewSite.getPage().getActivePart() && (meetingSite = this.fCurrentMeetingSites.get(item)) != null) {
            meetingSite.setUnread(false);
            final ChatMeetingViewer viewer = meetingSite.getViewer();
            if (!viewer.isSealed()) {
                FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingView_21){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        viewer.refreshLabel(monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    public void hideAlert() {
        if (this.fAlertJob != null) {
            this.fAlertJob.stop();
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.setSelectionProvider((ISelectionProvider)new TeamFormSelectionProvider());
    }

    CommandAction registerAction(CommandAction action) {
        Assert.isNotNull((Object)action);
        this.fCommandActions.add(action);
        return action;
    }

    public void removeViewListener(IChatMeetingViewListener listener) {
        Assert.isNotNull((Object)listener);
        this.fViewListeners.remove((Object)listener);
    }

    public void replaceViewer(String id, ChatMeetingViewer successor) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)successor);
        ChatMeetingViewer predecessor = null;
        int count = this.fViewTabFolder.getItemCount();
        CTabItem item = this.fCurrentViewerTabs.get(id);
        if (item != null && !item.isDisposed()) {
            predecessor = (ChatMeetingViewer)item.getData();
            CTabItem[] items = this.fViewTabFolder.getItems();
            int index = 0;
            while (index < items.length) {
                if (item == items[index]) {
                    count = index;
                    break;
                }
                ++index;
            }
            item.dispose();
        }
        this.addViewer(successor, predecessor, count);
    }

    public void setActiveViewer(String id, boolean activate) {
        Assert.isNotNull((Object)id);
        CTabItem item = this.fCurrentViewerTabs.get(id);
        if (item != null && !item.isDisposed()) {
            CTabItem[] items = this.fViewTabFolder.getItems();
            int index = 0;
            while (index < items.length) {
                if (item == items[index]) {
                    this.fViewTabFolder.setSelection(index);
                    this.handleActiveViewerChanged();
                    if (!activate) break;
                    try {
                        IWorkbenchPage page;
                        IViewSite site = this.getViewSite();
                        if (site == null || (page = site.getWorkbenchWindow().getActivePage()) == null) break;
                        page.showView(site.getId());
                    }
                    catch (PartInitException exception) {
                        CollaborationChatPlugin.getInstance().log(exception);
                    }
                    break;
                }
                ++index;
            }
        }
    }

    public void setFocus() {
        ChatMeetingSite site;
        CTabItem item = this.fViewTabFolder.getSelection();
        if (item != null && (site = this.fCurrentMeetingSites.get(item)) != null) {
            site.getViewer().setFocus();
            return;
        }
        this.fViewTabFolder.setFocus();
    }

    void setViewMessage(String message) {
        Assert.isNotNull((Object)message);
        this.setContentDescription(message);
    }

    public void showAlert() {
        this.hideAlert();
        this.fAlertJob = new ChatMeetingViewAlertJob();
        this.fAlertJob.schedule();
    }

    public void updateContentDescription() {
        if (this.fCurrentMeetingSites.isEmpty()) {
            this.setContentDescription(ChatMessages.ChatMeetingView_22);
        } else {
            CTabItem item = this.fViewTabFolder.getSelection();
            if (item != null) {
                this.setContentDescription(item.getToolTipText());
            } else {
                this.setContentDescription("");
            }
        }
    }

    void updateViewPage() {
        ChatMeetingView.asyncExec(new Runnable(){

            public void run() {
                if (!ChatMeetingView.this.fViewPageBook.isDisposed()) {
                    DefaultCollaborationService service = DefaultCollaborationService.getInstance();
                    if (TeamPlatform.getTeamRepositoryService().getTeamRepositories().length == 0) {
                        ChatMeetingView.this.fViewPageBook.showPage(ChatMeetingView.this.fMissingRepositoryPage.getControl());
                    } else if (!ChatMeetingView.isLoggedIn()) {
                        ChatMeetingView.this.fViewPageBook.showPage(ChatMeetingView.this.fLoggedOutRepositoryPage.getControl());
                    } else if (service.getAccountManager().getAccounts(1).isEmpty()) {
                        ChatMeetingView.this.fViewPageBook.showPage(ChatMeetingView.this.fMissingAccountsPage.getControl());
                    } else if (!service.isLoggedIn(1)) {
                        ChatMeetingView.this.fViewPageBook.showPage(ChatMeetingView.this.fMissingServiceConnectionPage.getControl());
                    } else {
                        ChatMeetingView.this.fViewPageBook.showPage(ChatMeetingView.this.fChatMeetingPage.getControl());
                        final ChatMeetingViewer viewer = ChatMeetingView.this.getActiveViewer();
                        if (viewer != null && !viewer.isSealed()) {
                            Job job = new Job(ChatMessages.ChatMeetingView_23){

                                protected IStatus run(IProgressMonitor monitor) {
                                    viewer.refreshLabel(monitor);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setPriority(20);
                            job.setSystem(true);
                            job.schedule();
                        }
                        ChatMeetingView.this.fStartChatAction.setEnabled(true);
                        return;
                    }
                    ChatMeetingView.this.fStartChatAction.setEnabled(false);
                    ChatMeetingView.this.setViewMessage(ChatMessages.ChatMeetingView_24);
                }
            }
        });
    }

    private abstract class AbstractChatMeetingViewPage
    extends Page {
        protected Composite fComposite;

        protected AbstractChatMeetingViewPage() {
        }

        public Control getControl() {
            return this.fComposite;
        }

        public void setFocus() {
            this.fComposite.setFocus();
        }
    }

    private abstract class AbstractSealedMeetingViewPage
    extends AbstractChatMeetingViewPage
    implements IChatMeetingViewListener {
        private Label fSealedCaption;
        Composite fSealedViewerContainer;
        private final LinkedHashMap<ChatMeetingViewer, Link> fSealedViewers = new LinkedHashMap(4);

        protected AbstractSealedMeetingViewPage() {
            ChatMeetingView.this.fViewListeners.add((Object)this);
        }

        public void chatViewerAdded(final ChatMeetingViewer viewer) {
            Assert.isNotNull((Object)viewer);
            if (!this.fSealedViewers.containsKey(viewer)) {
                if (this.fSealedViewers.isEmpty() && this.fSealedCaption == null) {
                    this.fSealedCaption = new Label(this.fSealedViewerContainer, 64);
                    this.fSealedCaption.setBackground(this.fSealedViewerContainer.getBackground());
                    this.fSealedCaption.setForeground(this.fSealedViewerContainer.getForeground());
                    this.fSealedCaption.setText(ChatMessages.ChatMeetingView_0);
                }
                final Link link = new Link(this.fSealedViewerContainer, 0);
                FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingView_1){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        viewer.refreshLabel(monitor);
                        ChatMeetingView.asyncExec(new Runnable(){

                            public void run() {
                                String label = viewer.getLabel();
                                link.setText(MessageFormat.format("<a>{0}</a>", label));
                                link.setToolTipText(label);
                                (this).AbstractSealedMeetingViewPage.this.fSealedViewerContainer.layout(true, true);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                job.setSystem(true);
                job.schedule();
                link.setText(ChatMessages.ChatMeetingView_2);
                link.setToolTipText(ChatMessages.ChatMeetingView_3);
                link.setBackground(this.fSealedViewerContainer.getBackground());
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Assert.isNotNull((Object)event);
                        ((AbstractSealedMeetingViewPage)AbstractSealedMeetingViewPage.this).ChatMeetingView.this.fViewPageBook.showPage(((AbstractSealedMeetingViewPage)AbstractSealedMeetingViewPage.this).ChatMeetingView.this.fChatMeetingPage.getControl());
                        ChatMeetingView.this.setActiveViewer(viewer.getId(), false);
                    }
                });
                this.fSealedViewerContainer.layout(true, true);
                this.fSealedViewers.put(viewer, link);
            }
        }

        public void chatViewerRemoved(ChatMeetingViewer viewer) {
            Assert.isNotNull((Object)viewer);
            if (this.fSealedViewerContainer != null && !this.fSealedViewerContainer.isDisposed()) {
                Widget widget = (Widget)this.fSealedViewers.get(viewer);
                if (widget != null && !widget.isDisposed()) {
                    widget.dispose();
                }
                this.fSealedViewers.remove(viewer);
                if (this.fSealedViewers.isEmpty() && this.fSealedCaption != null && !this.fSealedCaption.isDisposed()) {
                    this.fSealedCaption.dispose();
                    this.fSealedCaption = null;
                }
                this.fSealedViewerContainer.layout(true, true);
            }
        }

        protected void createSealedViewersComposite(Composite parent) {
            Assert.isNotNull((Object)parent);
            this.fSealedViewerContainer = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            this.fSealedViewerContainer.setLayout((Layout)layout);
            this.fSealedViewerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fSealedViewerContainer.setForeground(parent.getForeground());
            this.fSealedViewerContainer.setBackground(parent.getBackground());
        }

        public void dispose() {
            ChatMeetingView.this.fViewListeners.remove((Object)this);
            super.dispose();
        }
    }

    private final class ChatMeetingViewAlertJob
    extends UIJob {
        private static final long BLINK_INTERVAL = 500L;
        private boolean fBlinking;

        ChatMeetingViewAlertJob() {
            super(ChatMeetingView.this.getSite().getShell().getDisplay(), ChatMessages.ChatMeetingView_25);
            this.setSystem(true);
            if (ChatMeetingView.this.fViewImage == null || ChatMeetingView.this.fViewImage.isDisposed()) {
                ChatMeetingView.this.fViewImage = new Image((Device)this.getDisplay(), ChatMeetingView.this.getTitleImage().getImageData());
            }
            if (ChatMeetingView.this.fAlertImage == null || ChatMeetingView.this.fAlertImage.isDisposed()) {
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                imageDescriptorArray[1] = ImagePool.NEWINFO_OVRL;
                ChatMeetingView.this.fAlertImage = new OverlayIcon(ImageDescriptor.createFromImage((Image)ChatMeetingView.this.fViewImage), ChatMeetingView.this.fViewImage, imageDescriptorArray, new Point(16, 16), 131200).createImage((Device)this.getDisplay());
            }
            this.fBlinking = false;
            ChatMeetingView.this.setTitleImage(ChatMeetingView.this.fViewImage);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Assert.isNotNull((Object)monitor);
            this.fBlinking = !this.fBlinking;
            ChatMeetingView.this.setTitleImage(this.fBlinking ? ChatMeetingView.this.fAlertImage : ChatMeetingView.this.fViewImage);
            this.schedule(500L);
            return Status.OK_STATUS;
        }

        public void stop() {
            this.cancel();
            ChatMeetingView.this.setTitleImage(ChatMeetingView.this.fViewImage);
        }
    }

    private final class ChatMeetingViewPageListener
    implements ITeamRepositoryService.IRepositoryServiceListener,
    IListener,
    ICollaborationAccountListener,
    ICollaborationSessionListener {
        ChatMeetingViewPageListener() {
        }

        public void accountNotification(CollaborationAccountEvent event) {
            Assert.isNotNull((Object)event);
            ChatMeetingView.this.updateViewPage();
        }

        public void addedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.addGenericListener((Object)"state", (IListener)this);
            ChatMeetingView.this.updateViewPage();
        }

        public void handleEvents(List events) {
            Assert.isNotNull((Object)events);
            for (Object event : events) {
                IEventSource source;
                com.ibm.team.repository.client.util.PropertyChangeEvent extended;
                Object property;
                if (!(event instanceof com.ibm.team.repository.client.util.PropertyChangeEvent) || !"state".equals(property = (extended = (com.ibm.team.repository.client.util.PropertyChangeEvent)event).getProperty()) || !((source = extended.getEventSource()) instanceof ITeamRepository)) continue;
                ITeamRepository repository = (ITeamRepository)source;
                int state = repository.getState();
                switch (state) {
                    case 1: {
                        ChatMeetingView.this.updateViewPage();
                        break;
                    }
                    case 3: {
                        ChatMeetingView.this.updateViewPage();
                    }
                }
            }
        }

        public void removedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.removeGenericListener((Object)"state", (IListener)this);
            ChatMeetingView.this.updateViewPage();
        }

        public void sessionNotification(CollaborationSessionEvent event) {
            Assert.isNotNull((Object)event);
            ChatMeetingView.this.updateViewPage();
        }
    }

    private final class ChatMeetingViewPropertyChangeListener
    implements IPropertyChangeListener {
        ChatMeetingViewPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Assert.isNotNull((Object)event);
            if (ChatMeetingView.PREFERENCE_SHOW_PRESENCE_TRIM.equals(event.getProperty())) {
                Object extended;
                Object value = event.getNewValue();
                boolean result = true;
                if (value instanceof Boolean) {
                    extended = (Boolean)value;
                    result = (Boolean)extended;
                } else if (value instanceof String) {
                    extended = (String)value;
                    result = Boolean.parseBoolean((String)extended);
                }
                IActionBars bars = ChatMeetingView.this.getViewSite().getActionBars();
                IToolBarManager manager = bars.getToolBarManager();
                if (!result) {
                    String id = ChatMeetingView.this.fStartChatAction.getId();
                    manager.insertBefore(id, (IAction)ChatMeetingView.this.fChangePresenceAction);
                    manager.insertBefore(id, (IContributionItem)ChatMeetingView.this.fChangePresenceSeparator);
                } else {
                    manager.remove(ChatMeetingView.this.fChangePresenceAction.getId());
                    manager.remove((IContributionItem)ChatMeetingView.this.fChangePresenceSeparator);
                }
                bars.updateActionBars();
            }
        }
    }

    private final class ChatMeetingViewerPage
    extends Page {
        ChatMeetingViewerPage() {
        }

        public void createControl(Composite parent) {
            Assert.isNotNull((Object)parent);
            ChatMeetingView.this.fViewTabFolder = new CTabFolder(parent, 0x800400);
            ChatMeetingView.this.fViewTabFolder.setLayoutData((Object)new GridData(1808));
            ChatMeetingView.this.fViewTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ChatMeetingView.this.handleActiveViewerChanged();
                }
            });
            DropTarget target = new DropTarget((Control)ChatMeetingView.this.fViewTabFolder, 20);
            target.setTransfer(new Transfer[]{URIReferenceTransfer.getInstance()});
            target.addDropListener((DropTargetListener)new ChatMeetingDropTargetListener());
        }

        public Control getControl() {
            return ChatMeetingView.this.fViewTabFolder;
        }

        public void setFocus() {
            ChatMeetingViewer viewer = ChatMeetingView.this.getActiveViewer();
            if (viewer != null) {
                viewer.setFocus();
            }
        }

        private final class ChatMeetingDropTargetListener
        extends DropTargetAdapter
        implements TransferDropTargetListener {
            ChatMeetingDropTargetListener() {
            }

            public void dragEnter(DropTargetEvent event) {
                Assert.isNotNull((Object)event);
                if (event.detail == 16) {
                    event.detail = (event.operations & 4) != 0 ? 4 : 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                Assert.isNotNull((Object)event);
                event.detail = (event.operations & 4) != 0 ? 4 : 0;
            }

            public void drop(DropTargetEvent event) {
                URIReference[] references;
                Assert.isNotNull((Object)event);
                if (!URIReferenceTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                if (event.data instanceof URIReference[] && (references = (URIReference[])event.data).length != 0) {
                    this.startChat(references);
                }
            }

            public Transfer getTransfer() {
                return URIReferenceTransfer.getInstance();
            }

            public boolean isEnabled(DropTargetEvent event) {
                Assert.isNotNull((Object)event);
                URIReferenceTransfer transfer = URIReferenceTransfer.getInstance();
                TransferData[] transferDataArray = event.dataTypes;
                int n = event.dataTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    TransferData element = transferDataArray[n2];
                    if (transfer.isSupportedType(element)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            private void startChat(final URIReference[] references) {
                Assert.isNotNull((Object)references);
                CollaborationCore.getCollaborationService().scheduleJob(new CollaborationServiceJob(){

                    public String getName() {
                        return ChatMessages.ChatMeetingView_4;
                    }

                    public boolean isSystem() {
                        return false;
                    }

                    public boolean isUser() {
                        return true;
                    }

                    public IStatus run(IProgressMonitor monitor) {
                        Assert.isNotNull((Object)monitor);
                        try {
                            IWorkbenchPart part;
                            monitor.beginTask(ChatMessages.ChatMeetingView_5, references.length * 100);
                            ArrayList<IContributorHandle> handles = new ArrayList<IContributorHandle>(references.length);
                            URIReference[] uRIReferenceArray = references;
                            int n = references.length;
                            int n2 = 0;
                            while (n2 < n) {
                                URIReference reference = uRIReferenceArray[n2];
                                try {
                                    Object element = Hyperlinks.resolve((URI)reference.getURI(), null, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                                    if (element instanceof IContributorHandle) {
                                        IContributorHandle handle = (IContributorHandle)element;
                                        handles.add(handle);
                                    }
                                }
                                catch (CoreException exception) {
                                    CollaborationChatPlugin.getInstance().log(exception);
                                }
                                ++n2;
                            }
                            if (!handles.isEmpty() && (part = ChatMeetingViewerPage.this.getSite().getPage().getActivePart()) != null) {
                                IStatus iStatus = CollaborationExceptionHandler.handleErrorStatus((IStatus)CollaborationUI.contactContributors((IWorkbenchPart)part, handles, (ICollaborationContextProvider)new ICollaborationContextProvider(){

                                    public CollaborationData getContext(Collection<CollaborationUser> users, IProgressMonitor progress) {
                                        Assert.isNotNull(users);
                                        return null;
                                    }

                                    public Collection<URIReference> getTopics(Collection<CollaborationUser> users, IProgressMonitor progress) {
                                        Assert.isNotNull(users);
                                        return Collections.emptyList();
                                    }
                                }, (IProgressMonitor)monitor));
                                return iStatus;
                            }
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
        }
    }

    public static interface IChatMeetingViewListener {
        public void chatViewerAdded(ChatMeetingViewer var1);

        public void chatViewerRemoved(ChatMeetingViewer var1);
    }

    private final class LoggedOutTeamRepositoryPage
    extends AbstractSealedMeetingViewPage {
        private Link fLoginLink;

        LoggedOutTeamRepositoryPage() {
        }

        public void createControl(Composite parent) {
            Assert.isNotNull((Object)parent);
            this.fComposite = new Composite(parent, 0);
            this.fComposite.setLayout((Layout)new GridLayout());
            this.fComposite.setBackground(this.fComposite.getDisplay().getSystemColor(25));
            Link link = new Link(this.fComposite, 64);
            link.setText(ChatMessages.ChatMeetingView_7);
            link.setBackground(this.fComposite.getBackground());
            link.setLayoutData((Object)new GridData(768));
            this.fLoginLink = new Link(this.fComposite, 0);
            this.fLoginLink.setText(ChatMessages.ChatMeetingView_8);
            this.fLoginLink.setBackground(this.fComposite.getBackground());
            this.fLoginLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ITeamRepository[] repositories;
                    Assert.isNotNull((Object)event);
                    ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
                    int n = repositories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final ITeamRepository repository = iTeamRepositoryArray[n2];
                        if (!repository.loggedIn()) {
                            FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingView_9){

                                protected IStatus runProtected(IProgressMonitor monitor) throws TeamRepositoryException {
                                    repository.login(monitor);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setPriority(30);
                            job.schedule();
                        }
                        ++n2;
                    }
                }
            });
            this.createSealedViewersComposite(this.fComposite);
        }

        public void setFocus() {
            this.fLoginLink.setFocus();
        }
    }

    private final class MissingCollaborationAccountsPage
    extends AbstractSealedMeetingViewPage {
        MissingCollaborationAccountsPage() {
        }

        public void createControl(Composite parent) {
            Assert.isNotNull((Object)parent);
            this.fComposite = new Composite(parent, 0);
            Display display = this.fComposite.getDisplay();
            this.fComposite.setLayout((Layout)new GridLayout());
            this.fComposite.setBackground(display.getSystemColor(25));
            final Link link = new Link(this.fComposite, 64);
            link.setText(ChatMessages.ChatMeetingView_11);
            link.setBackground(this.fComposite.getBackground());
            link.setForeground(display.getSystemColor(24));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Assert.isNotNull((Object)event);
                    PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)event.text, null, null).open();
                }
            });
            link.setLayoutData((Object)new GridData(768));
            this.createSealedViewersComposite(this.fComposite);
        }
    }

    private final class MissingServiceConnectionPage
    extends AbstractSealedMeetingViewPage {
        private Link fConnectLink;

        MissingServiceConnectionPage() {
        }

        public void createControl(Composite parent) {
            Assert.isNotNull((Object)parent);
            this.fComposite = new Composite(parent, 0);
            Display display = this.fComposite.getDisplay();
            this.fComposite.setLayout((Layout)new GridLayout());
            this.fComposite.setBackground(display.getSystemColor(25));
            Link link = new Link(this.fComposite, 64);
            link.setText(ChatMessages.ChatMeetingView_12);
            link.setBackground(this.fComposite.getBackground());
            link.setForeground(display.getSystemColor(24));
            link.setLayoutData((Object)new GridData(768));
            this.fConnectLink = new Link(this.fComposite, 0);
            this.fConnectLink.setText(ChatMessages.ChatMeetingView_13);
            this.fConnectLink.setBackground(this.fComposite.getBackground());
            this.fConnectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Assert.isNotNull((Object)event);
                    CollaborationCore.getCollaborationService().scheduleJob(new CollaborationServiceJob(){

                        public String getName() {
                            return ChatMessages.ChatMeetingView_14;
                        }

                        public boolean isSystem() {
                            return false;
                        }

                        public boolean isUser() {
                            return true;
                        }

                        public IStatus run(IProgressMonitor monitor) {
                            Assert.isNotNull((Object)monitor);
                            try {
                                monitor.beginTask(ChatMessages.ChatMeetingView_15, 100);
                                ICollaborationService service = CollaborationCore.getCollaborationService();
                                if (!service.isLoggedIn(1)) {
                                    IStatus iStatus = CollaborationExceptionHandler.handleErrorStatus((IStatus)service.login(1, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)));
                                    return iStatus;
                                }
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
            });
            this.createSealedViewersComposite(this.fComposite);
        }

        public void setFocus() {
            this.fConnectLink.setFocus();
        }
    }

    private final class MissingTeamRepositoryPage
    extends AbstractSealedMeetingViewPage {
        private Link fShowLink;

        MissingTeamRepositoryPage() {
        }

        public void createControl(Composite parent) {
            Assert.isNotNull((Object)parent);
            this.fComposite = new Composite(parent, 0);
            this.fComposite.setLayout((Layout)new GridLayout());
            this.fComposite.setBackground(this.fComposite.getDisplay().getSystemColor(25));
            Link link = new Link(this.fComposite, 64);
            link.setText(ChatMessages.ChatMeetingView_16);
            link.setBackground(this.fComposite.getBackground());
            link.setLayoutData((Object)new GridData(768));
            this.fShowLink = new Link(this.fComposite, 0);
            this.fShowLink.setText(ChatMessages.ChatMeetingView_17);
            this.fShowLink.setBackground(this.fComposite.getBackground());
            this.fShowLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Assert.isNotNull((Object)event);
                    IWorkbenchPage page = MissingTeamRepositoryPage.this.getSite().getWorkbenchWindow().getActivePage();
                    if (page != null) {
                        try {
                            page.showView(ChatMeetingView.TEAM_ARTIFACTS_VIEW_ID, null, 1);
                        }
                        catch (PartInitException exception) {
                            CollaborationChatPlugin.getInstance().log(exception);
                        }
                    }
                }
            });
            this.createSealedViewersComposite(this.fComposite);
        }

        public void setFocus() {
            this.fShowLink.setFocus();
        }
    }
}

