/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.viewer;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.team.collaboration.core.service.CollaborationServiceUser;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.collaboration.internal.chat.ui.CollaborationChatPlugin;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingStanza;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import com.ibm.team.repository.common.UUID;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChatMeetingTranscriptModel {
    private static int fgColorIndex = 0;
    private static Map<UUID, String> fgColorMap = new HashMap<UUID, String>(32);
    private static final RGB[] fgContributorColors = new RGB[]{new RGB(57, 87, 122), new RGB(218, 129, 3), new RGB(172, 32, 0), new RGB(60, 159, 168), new RGB(226, 86, 20), new RGB(11, 106, 200), new RGB(178, 50, 144), new RGB(46, 124, 7), new RGB(91, 50, 132), new RGB(180, 133, 23), new RGB(0, 186, 115), new RGB(41, 127, 255)};
    private static final String USER_NAME_CATEGORY = "com.ibm.team.collaboration.user.names";
    final IStyledDocument fDocument;
    final Map<CollaborationUser, Collection<ChatMeetingStanzaPosition>> fPendingUsers = Collections.synchronizedMap(new HashMap(4));
    final Shell fShell;
    private final ArrayList<ChatMeetingStanza> fStanzas;

    private static String getUserColor(UUID uuid) {
        Assert.isNotNull((Object)uuid);
        String color = fgColorMap.get(uuid);
        if (color == null) {
            color = ChatMeetingTranscriptModel.toHexString(fgContributorColors[fgColorIndex]);
            fgColorMap.put(uuid, color);
            fgColorIndex = (fgColorIndex + 1) % fgContributorColors.length;
        }
        return color;
    }

    /*
     * Unable to fully structure code
     */
    private static String toHexString(int value) {
        string = Integer.toHexString(value);
        if (string.length() <= 2) ** GOTO lbl5
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            string = "0" + string;
lbl5:
            // 2 sources

            ** while (string.length() < 2)
        }
lbl6:
        // 1 sources

        return string;
    }

    private static String toHexString(RGB rgb) {
        Assert.isNotNull((Object)rgb);
        return String.valueOf(ChatMeetingTranscriptModel.toHexString(rgb.red)) + ChatMeetingTranscriptModel.toHexString(rgb.green) + ChatMeetingTranscriptModel.toHexString(rgb.blue);
    }

    ChatMeetingTranscriptModel(Shell shell) {
        this(shell, (IStyledDocument)new StyledDocument(), new ArrayList<ChatMeetingStanza>(64));
    }

    ChatMeetingTranscriptModel(Shell shell, IStyledDocument document, ArrayList<ChatMeetingStanza> stanzas) {
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)document);
        Assert.isNotNull(stanzas);
        this.fShell = shell;
        this.fDocument = document;
        this.fDocument.addPositionCategory(USER_NAME_CATEGORY);
        this.fDocument.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater(USER_NAME_CATEGORY));
        this.fStanzas = stanzas;
    }

    public void addStanza(ChatMeetingStanza stanza) {
        Assert.isNotNull((Object)stanza);
        if (this.fStanzas.contains(stanza)) {
            return;
        }
        int index = this.fStanzas.size() - 1;
        while (index >= 0) {
            ChatMeetingStanza currentStanza = this.fStanzas.get(index);
            if (currentStanza.getOrdinal() < stanza.getOrdinal()) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(currentStanza.getTimeStamp());
                int previous = calendar.get(6);
                calendar.setTimeInMillis(stanza.getTimeStamp());
                int next = calendar.get(6);
                if (previous != next) {
                    calendar.setTimeInMillis(stanza.getTimeStamp());
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    long timeStamp = calendar.getTimeInMillis();
                    ChatMeetingStanzaTimeStamp separator = new ChatMeetingStanzaTimeStamp(timeStamp, stanza.isHistory());
                    int offset = this.fStanzas.size() - 1;
                    while (offset >= 0) {
                        ChatMeetingStanza current = this.fStanzas.get(offset);
                        if (current.getOrdinal() == separator.getOrdinal()) break;
                        if (current.getOrdinal() < separator.getOrdinal()) {
                            this.addStanza(offset + 1, separator);
                            this.addStanza(offset + 2, stanza);
                            return;
                        }
                        --offset;
                    }
                }
                this.addStanza(index + 1, stanza);
                return;
            }
            --index;
        }
        this.addStanza(0, stanza);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStanza(int index, ChatMeetingStanza stanza) {
        block22: {
            this.fStanzas.add(index, stanza);
            try {
                int offset = -1;
                offset = index == 0 ? 0 : (index == this.fStanzas.size() ? this.fDocument.getLength() : this.fDocument.getLineOffset(index));
                if (offset < 0) break block22;
                this.writeHTML(offset, "<br/>");
                final CollaborationUser user = stanza.getUser();
                if (user != null) {
                    this.writeStanza(stanza, index, offset);
                    final Display display = this.fShell.getDisplay();
                    boolean highContrast = !display.isDisposed() && display.getHighContrast();
                    final String color = !highContrast ? ChatMeetingTranscriptModel.getUserColor(user.getUUID()) : this.getHighContrastUserColor();
                    String name = null;
                    if (user instanceof CollaborationServiceUser) {
                        CollaborationServiceUser extended = (CollaborationServiceUser)user;
                        name = extended.getUserName();
                    }
                    FoundationJob job = null;
                    boolean contains = false;
                    if (name == null) {
                        Map<CollaborationUser, Collection<ChatMeetingStanzaPosition>> map = this.fPendingUsers;
                        synchronized (map) {
                            contains = this.fPendingUsers.containsKey(user);
                            if (!contains) {
                                this.fPendingUsers.put(user, new ArrayList(8));
                            }
                        }
                        if (!contains) {
                            job = new FoundationJob(ChatMessages.ChatMeetingTranscriptModel_5){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                protected IStatus runProtected(IProgressMonitor monitor) {
                                    try {
                                        final String userName = user.getUserName(monitor);
                                        final ArrayList<ChatMeetingStanzaPosition> positions = new ArrayList<ChatMeetingStanzaPosition>(8);
                                        Map<CollaborationUser, Collection<ChatMeetingStanzaPosition>> map = ChatMeetingTranscriptModel.this.fPendingUsers;
                                        synchronized (map) {
                                            Collection<ChatMeetingStanzaPosition> collection = ChatMeetingTranscriptModel.this.fPendingUsers.get(user);
                                            if (collection != null) {
                                                positions.addAll(collection);
                                            }
                                        }
                                        Collections.reverse(positions);
                                        if (!(positions.isEmpty() || ChatMeetingTranscriptModel.this.fShell.isDisposed() || display.isDisposed())) {
                                            display.asyncExec(new Runnable(){

                                                public void run() {
                                                    if (!(this).ChatMeetingTranscriptModel.this.fShell.isDisposed()) {
                                                        for (ChatMeetingStanzaPosition position : positions) {
                                                            try {
                                                                (this).ChatMeetingTranscriptModel.this.fDocument.replaceHTML(position.offset, position.length, XMLString.createFromXMLText((String)MessageFormat.format(ChatMessages.ChatMeetingTranscriptModel_4, color, userName)));
                                                            }
                                                            catch (BadLocationException badLocationException) {}
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                        IStatus iStatus = Status.OK_STATUS;
                                        return iStatus;
                                    }
                                    finally {
                                        ChatMeetingTranscriptModel.this.fPendingUsers.remove(user);
                                    }
                                }
                            };
                            job.setPriority(10);
                            job.setSystem(true);
                        }
                    }
                    String message = MessageFormat.format(ChatMessages.ChatMeetingTranscriptModel_1, color, name != null ? name : ChatMessages.ChatMeetingTranscriptModel_3);
                    this.writeHTML(offset, message);
                    if (name == null) {
                        try {
                            ChatMeetingStanzaPosition position = new ChatMeetingStanzaPosition(user, offset, ChatMessages.ChatMeetingTranscriptModel_3.length());
                            Map<CollaborationUser, Collection<ChatMeetingStanzaPosition>> map = this.fPendingUsers;
                            synchronized (map) {
                                Collection<ChatMeetingStanzaPosition> positions = this.fPendingUsers.get(user);
                                if (positions == null) {
                                    positions = new ArrayList<ChatMeetingStanzaPosition>(8);
                                    this.fPendingUsers.put(user, positions);
                                }
                                positions.add(position);
                            }
                            this.fDocument.addPosition(USER_NAME_CATEGORY, (Position)position);
                            if (job != null) {
                                job.schedule();
                            }
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {
                            Assert.isLegal((boolean)false);
                        }
                    }
                } else if (!(stanza instanceof ChatMeetingStanzaTimeStamp)) {
                    this.writePlain(offset, " ::");
                    this.writeStanza(stanza, index, offset);
                    this.writePlain(offset, " :: ");
                }
                this.writePlain(offset, " ");
                if (stanza instanceof ChatMeetingStanzaTimeStamp) {
                    this.writeHTML(offset, MessageFormat.format(ChatMessages.ChatMeetingTranscriptModel_2, this.getTimeStampColor(), stanza.getText()));
                } else {
                    this.writeHTML(offset, MessageFormat.format(ChatMessages.ChatMeetingTranscriptModel_0, this.getTimeStampColor(), DateFormat.getTimeInstance().format(new Date(stanza.getTimeStamp()))));
                }
            }
            catch (BadLocationException exception) {
                CollaborationChatPlugin.getInstance().log(exception);
            }
        }
    }

    private String getHighContrastUserColor() {
        return ChatMeetingTranscriptModel.toHexString(new RGB(255, 255, 255));
    }

    public ChatMeetingStanza getStanza(int line) {
        Assert.isLegal((line >= 0 ? 1 : 0) != 0, (String)"Line must be non-negative");
        if (line < this.fStanzas.size()) {
            return this.fStanzas.get(line);
        }
        return null;
    }

    private String getTimeStampColor() {
        return ChatMeetingTranscriptModel.toHexString(this.fShell.getDisplay().getSystemColor(16).getRGB());
    }

    public IStyledDocument getTranscript() {
        return this.fDocument;
    }

    public void setHistory(boolean history) {
        for (ChatMeetingStanza stanza : this.fStanzas) {
            stanza.setHistory(history);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("Transcript[stanzas=");
        builder.append(this.fStanzas.toString());
        builder.append(']');
        return builder.toString();
    }

    private void writeHTML(int offset, String text) throws BadLocationException {
        this.fDocument.replaceHTML(offset, 0, XMLString.createFromXMLText((String)text));
    }

    private void writePlain(int offset, String text) throws BadLocationException {
        this.fDocument.replace(offset, 0, text);
    }

    /*
     * Unable to fully structure code
     */
    private void writeStanza(ChatMeetingStanza stanza, int index, int offset) throws BadLocationException {
        previous = this.fDocument.getNumberOfLines();
        try {
            if ("text/html".equals(stanza.getTextType())) {
                this.writeHTML(offset, stanza.getText());
            }
            this.writePlain(offset, stanza.getText());
        }
        finally {
            next = this.fDocument.getNumberOfLines();
            line = 0;
            ** while (line < next - previous)
        }
lbl-1000:
        // 1 sources

        {
            this.fStanzas.add(index, new ChatMeetingStanzaReference(stanza));
            ++line;
            continue;
        }
lbl15:
        // 1 sources

    }

    private static final class ChatMeetingStanzaPosition
    extends Position {
        public CollaborationUser user;

        ChatMeetingStanzaPosition(CollaborationUser user, int offset, int length) {
            super(offset, length);
            Assert.isNotNull((Object)user);
            this.user = user;
        }
    }

    private static final class ChatMeetingStanzaReference
    extends ChatMeetingStanza {
        public ChatMeetingStanza reference;

        ChatMeetingStanzaReference(ChatMeetingStanza reference) {
            super(reference.getId(), reference.getUser(), reference.getText(), reference.getTextType(), reference.getTimeStamp(), reference.isHistory());
            Assert.isNotNull((Object)reference);
            this.reference = reference;
        }

        public void setHistory(boolean history) {
            super.setHistory(history);
            this.reference.setHistory(history);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(128);
            builder.append("Reference[stanza=");
            builder.append(this.reference);
            builder.append(']');
            return builder.toString();
        }
    }

    private static final class ChatMeetingStanzaTimeStamp
    extends ChatMeetingStanza {
        ChatMeetingStanzaTimeStamp(long stamp, boolean history) {
            super(ChatMeetingStanzaTimeStamp.generateId(), null, "<b>" + DateFormat.getDateInstance((int)1).format(new Date(stamp)) + "</b>", "text/html", stamp, history);
        }
    }
}

