/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.viewer;

import com.ibm.team.collaboration.core.session.CollaborationUser;
import org.eclipse.core.runtime.Assert;

class ChatMeetingStanza {
    private static int fCurrentId = 0;
    private boolean fHistory;
    private final String fStanzaId;
    private final String fText;
    private final String fTextType;
    private final long fTimeStamp;
    private final CollaborationUser fUser;

    static final synchronized String generateId() {
        return "stanza-" + fCurrentId++;
    }

    ChatMeetingStanza(String id, CollaborationUser user, String text, String textType, long stamp, boolean history) {
        Assert.isNotNull((Object)text);
        Assert.isLegal(("text/html".equals(textType) || "text/plain".equals(textType) ? 1 : 0) != 0, (String)"Message type must be one of the declared constants");
        Assert.isLegal((id != null && !"".equals(id) ? 1 : 0) != 0, (String)"Stanza id must not be null or empty");
        this.fUser = user;
        this.fText = text;
        this.fTextType = textType;
        this.fTimeStamp = stamp;
        this.fStanzaId = id;
        this.fHistory = history;
    }

    ChatMeetingStanza(String text, String textType) {
        this(ChatMeetingStanza.generateId(), null, text, textType, System.currentTimeMillis(), false);
    }

    ChatMeetingStanza(String text, String textType, long stamp) {
        this(ChatMeetingStanza.generateId(), null, text, textType, stamp, false);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChatMeetingStanza) {
            ChatMeetingStanza stanza = (ChatMeetingStanza)object;
            return stanza.fStanzaId.equals(this.fStanzaId);
        }
        return false;
    }

    public String getId() {
        return this.fStanzaId;
    }

    public long getOrdinal() {
        if (this.fHistory) {
            return this.fTimeStamp - 1187194880L;
        }
        return this.fTimeStamp;
    }

    public String getText() {
        return this.fText;
    }

    public String getTextType() {
        return this.fTextType;
    }

    public long getTimeStamp() {
        return this.fTimeStamp;
    }

    public CollaborationUser getUser() {
        return this.fUser;
    }

    public int hashCode() {
        return this.fStanzaId.hashCode();
    }

    public boolean isHistory() {
        return this.fHistory;
    }

    public void setHistory(boolean history) {
        this.fHistory = history;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("Stanza[text=");
        builder.append(this.fText);
        builder.append(",type=");
        builder.append(this.fTextType);
        builder.append(",user=");
        builder.append(this.fUser);
        builder.append(",stamp=");
        builder.append(this.fTimeStamp);
        builder.append(",history=");
        builder.append(this.fHistory);
        builder.append(']');
        return builder.toString();
    }
}

