/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.viewer;

import com.ibm.team.collaboration.internal.chat.ui.CollaborationChatPlugin;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingView;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingViewer;
import com.ibm.team.jface.JazzResources;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

final class ChatMeetingSite {
    private static final String TAB_TEXT_FONT = "org.eclipse.ui.workbench.TAB_TEXT_FONT";
    private boolean fBusy = false;
    private final CTabItem fItem;
    private Font fLastFont = null;
    private final ResourceManager fResourceManager;
    private boolean fUnread = false;
    private final ChatMeetingView fView;
    private final ChatMeetingViewer fViewer;

    ChatMeetingSite(ChatMeetingView view, ChatMeetingViewer viewer, CTabItem item) {
        Assert.isNotNull((Object)((Object)view));
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)item);
        this.fViewer = viewer;
        this.fItem = item;
        this.fView = view;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), this.fItem.getControl());
    }

    public String getLabel() {
        return this.fItem.getText();
    }

    public String getToolTip() {
        return this.fItem.getToolTipText();
    }

    public ChatMeetingView getView() {
        return this.fView;
    }

    public ChatMeetingViewer getViewer() {
        return this.fViewer;
    }

    public Widget getWidget() {
        return this.fItem;
    }

    public void setBusy(boolean busy) {
        if (busy != this.fBusy) {
            this.fBusy = busy;
            this.updateSite();
        }
    }

    public void setComposing(String name) {
        if (name != null && !"".equals(name)) {
            this.fItem.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)CollaborationChatPlugin.getImageDescriptor("$nl$/icons/full/obj16/composing.gif")));
        } else {
            this.fItem.setImage(null);
        }
    }

    public void setLabel(String label) {
        Assert.isNotNull((Object)label);
        this.fItem.setText(label);
    }

    public void setToolTip(String tooltip) {
        Assert.isNotNull((Object)tooltip);
        this.fItem.setToolTipText(tooltip);
    }

    public void setUnread(boolean unread) {
        if (unread != this.fUnread) {
            this.fUnread = unread;
            this.updateSite();
        }
        if (unread && !this.fView.getSite().getPage().isPartVisible((IWorkbenchPart)this.fView)) {
            this.fView.showAlert();
        } else {
            this.fView.hideAlert();
        }
    }

    private void updateSite() {
        FontRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
        Font font = null;
        if (this.fUnread) {
            font = registry.getBold(TAB_TEXT_FONT);
        } else if (this.fBusy) {
            font = registry.getItalic(TAB_TEXT_FONT);
        }
        if (font != this.fLastFont) {
            this.fItem.setFont(font);
            this.fLastFont = font;
        }
    }
}

