/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.action;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.core.meeting.SendDataRequest;
import com.ibm.team.collaboration.core.service.CollaborationServiceJob;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class SendFileAction
extends Action {
    final CollaborationMeeting fMeeting;

    public SendFileAction(CollaborationMeeting meeting) {
        super(ChatMessages.SendFileAction_0);
        Assert.isNotNull((Object)meeting);
        this.fMeeting = meeting;
        this.setDescription(ChatMessages.SendFileAction_1);
        this.setToolTipText(ChatMessages.SendFileAction_2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.team.collaboration.ui.send_file");
    }

    public void run() {
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null) {
            Shell shell = part.getSite().getShell();
            FileDialog dialog = new FileDialog(shell, 4096);
            dialog.setText(ChatMessages.SendFileAction_4);
            String path = dialog.open();
            if (path != null && !"".equals(path)) {
                final File file = new File(path);
                CollaborationCore.getCollaborationService().scheduleJob(new CollaborationServiceJob(){

                    public String getName() {
                        return ChatMessages.SendFileAction_5;
                    }

                    public boolean isSystem() {
                        return false;
                    }

                    public boolean isUser() {
                        return false;
                    }

                    public IStatus run(IProgressMonitor monitor) {
                        return SendFileAction.this.fMeeting.send((CollaborationData)new SendDataRequest(SendFileAction.this.fMeeting.getInvitees(), file), monitor);
                    }
                });
            }
        }
    }
}

