/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui;

import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class CollaborationChatPlugin
extends AbstractUIPlugin {
    private static CollaborationChatPlugin fgPlugin;
    private static ImageRegistry fgRegistry;
    public static final String PLUGIN_ID = "com.ibm.team.collaboration.chat.rcp.ui";

    public static Image getImage(String path) {
        Image image;
        if (fgRegistry == null) {
            fgRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        if ((image = fgRegistry.get(path)) == null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
            fgRegistry.put(path, descriptor);
            image = fgRegistry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor;
        if (fgRegistry == null) {
            fgRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        if ((descriptor = fgRegistry.getDescriptor(path)) == null) {
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
            fgRegistry.put(path, descriptor);
        }
        return descriptor;
    }

    public static CollaborationChatPlugin getInstance() {
        return fgPlugin;
    }

    public static ITeamRepository selectTeamRepository(Shell shell) {
        Assert.isNotNull((Object)shell);
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        ArrayList<ITeamRepository> loggedIn = new ArrayList<ITeamRepository>(repositories.length);
        ITeamRepository[] iTeamRepositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repository.loggedIn()) {
                loggedIn.add(repository);
            }
            ++n2;
        }
        if (loggedIn.size() == 1) {
            return (ITeamRepository)loggedIn.iterator().next();
        }
        if (!loggedIn.isEmpty()) {
            Object[] result;
            ListDialog dialog = new ListDialog(shell);
            dialog.setTitle(ChatMessages.CollaborationChatPlugin_0);
            dialog.setMessage(ChatMessages.CollaborationChatPlugin_1);
            dialog.setLabelProvider((ILabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            Object[] input = loggedIn.toArray();
            dialog.setInput((Object)input);
            dialog.setInitialSelections(new Object[]{input[0]});
            if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
                return (ITeamRepository)result[0];
            }
        }
        return null;
    }

    public CollaborationChatPlugin() {
        fgPlugin = this;
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(String message) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, null));
    }

    public void log(Throwable throwable) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Internal Error", throwable));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (fgRegistry != null) {
            fgRegistry.dispose();
        }
        fgPlugin = null;
    }
}

