/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.internal.util;

import com.ibm.team.foundation.client.internal.util.FoundationJobUtil;
import com.ibm.team.foundation.client.util.FoundationJobContext;
import com.ibm.team.foundation.common.internal.util.FoundationLogUtil;
import com.ibm.team.foundation.rcp.ui.internal.FoundationRCPUIPlugin;
import com.ibm.team.foundation.rcp.ui.internal.util.ExceptionDescriptionUI;
import com.ibm.team.foundation.rcp.ui.internal.util.Messages;
import com.ibm.team.foundation.rcp.ui.internal.util.Utils;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.packageadmin.PackageAdmin;

public final class UserInitiatedJobContext
extends FoundationJobContext {
    private IWorkbenchWindow fWindow;
    IWorkbenchPart fPart;
    IAction fAction;
    private ITeamRepository[] fTeamRepositories;

    public static FoundationJobContext create(IWorkbenchPart part, IAction action, ITeamRepository ... teamRepositories) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)action);
        return new UserInitiatedJobContext(part.getSite().getWorkbenchWindow(), part, action, teamRepositories);
    }

    public static FoundationJobContext create(IWorkbenchWindow window, IAction action, ITeamRepository ... teamRepositories) {
        Assert.isNotNull((Object)window);
        Assert.isNotNull((Object)action);
        return new UserInitiatedJobContext(window, null, action, teamRepositories);
    }

    private UserInitiatedJobContext(IWorkbenchWindow window, IWorkbenchPart part, IAction action, ITeamRepository ... teamRepositories) {
        this.fWindow = window;
        this.fPart = part;
        this.fAction = action;
        this.fTeamRepositories = teamRepositories;
    }

    public void configureJob(Job job) {
    }

    public IStatus checkPreconditions(Job job, IProgressMonitor monitor) throws Exception {
        if (job.isSystem()) {
            return null;
        }
        if (this.fTeamRepositories.length == 0) {
            return null;
        }
        if (this.fTeamRepositories.length == 1) {
            return Utils.validateRepository(this.fTeamRepositories[0], false, monitor);
        }
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        ITeamRepository[] iTeamRepositoryArray = this.fTeamRepositories;
        int n = this.fTeamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository = iTeamRepositoryArray[n2];
            statuses.add(Utils.validateRepository(teamRepository, false, monitor));
            ++n2;
        }
        return new MultiStatus("com.ibm.team.foundation.rcp.ui", 0, statuses.toArray(new IStatus[statuses.size()]), Messages.UserInitiatedJobContext_REPOSITORY_CONNECTION_STATUS, null);
    }

    public void handleStatus(final Job job, final IStatus status) {
        if (job.isSystem()) {
            return;
        }
        if (status.getSeverity() != 4) {
            return;
        }
        if (this.fWindow != null) {
            ExceptionDescriptionUI.handleStatus(this.fWindow, job.getName(), status);
        } else if (Display.getCurrent() != null) {
            this.handleStatusInUI(job.getName(), status);
        } else if (Display.getDefault() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    UserInitiatedJobContext.this.handleStatusInUI(job.getName(), status);
                }
            });
        }
    }

    private void handleStatusInUI(String operationName, IStatus status) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && workbench.getWorkbenchWindowCount() > 0) {
            window = workbench.getWorkbenchWindows()[0];
        }
        if (window != null) {
            ExceptionDescriptionUI.handleStatus(window, operationName, status);
        }
    }

    public static void internalInitialize(PackageAdmin packageAdmin) {
        UserInitiatedJobContext compatibilityContext = new UserInitiatedJobContext(null, null, null, new ITeamRepository[0]);
        FoundationJobUtil.setCompatibilityContext((FoundationJobContext)compatibilityContext);
        FoundationJobUtil.setPackageAdmin((PackageAdmin)packageAdmin);
        FoundationLogUtil.setCompatibilityLog((ILog)FoundationRCPUIPlugin.getDefault().getLog());
    }

    public static void internalDispose() {
        FoundationJobUtil.setCompatibilityContext((FoundationJobContext)new FoundationJobContext());
        FoundationJobUtil.setPackageAdmin(null);
        FoundationLogUtil.setCompatibilityLog(null);
    }
}

