/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.internal.util;

import com.ibm.team.foundation.common.internal.util.ExceptionDescription;
import com.ibm.team.foundation.common.internal.util.TeamFoundationException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class ExceptionDescriptionUI {
    public static void handleDescription(final IWorkbenchWindow window, final ExceptionDescription description) {
        if (window == null || description == null) {
            return;
        }
        if (window.getShell() == null || window.getShell().isDisposed()) {
            return;
        }
        Display display = window.getShell().getDisplay();
        if (Display.getCurrent() == display) {
            ExceptionDescriptionUI.handleDescriptionInUI(window, description);
        } else {
            display.asyncExec(new Runnable(){

                public void run() {
                    ExceptionDescriptionUI.handleDescriptionInUI(window, description);
                }
            });
        }
    }

    private static void handleDescriptionInUI(IWorkbenchWindow window, ExceptionDescription description) {
        ExceptionDescriptionUI descriptionUI = (ExceptionDescriptionUI)ExceptionDescription.findAdapter((Throwable)description.getException(), ExceptionDescriptionUI.class);
        if (descriptionUI != null) {
            descriptionUI.showExceptionDescription(window, description);
        } else {
            ExceptionDescriptionUI.showFallbackUI(window, description);
        }
    }

    private static void showFallbackUI(IWorkbenchWindow window, ExceptionDescription description) {
        int severity = TeamFoundationException.isExpected((Throwable)description.getException()) ? 2 : 4;
        Status status = new Status(severity, "com.ibm.team.foundation.rcp.ui", String.valueOf(description.getDescription()) + "\n", null);
        StatusAdapter adapter = new StatusAdapter((IStatus)status);
        adapter.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)description.getContextSummary());
        StatusManager.getManager().handle(adapter, 2);
    }

    public static void handleStatus(final IWorkbenchWindow window, final String operationName, final IStatus status) {
        if (window == null || status == null) {
            return;
        }
        if (window.getShell() == null || window.getShell().isDisposed()) {
            return;
        }
        Display display = window.getShell().getDisplay();
        if (Display.getCurrent() == display) {
            ExceptionDescriptionUI.handleStatusInUI(window, operationName, status);
        } else {
            display.asyncExec(new Runnable(){

                public void run() {
                    ExceptionDescriptionUI.handleStatusInUI(window, operationName, status);
                }
            });
        }
    }

    private static void handleStatusInUI(IWorkbenchWindow window, String operationName, IStatus status) {
        ExceptionDescriptionUI.showFallbackUI(window, operationName, status);
    }

    private static void showFallbackUI(IWorkbenchWindow window, String operationName, IStatus original) {
        StatusAdapter adapter = ExceptionDescriptionUI.getStatusAdapter(operationName, original);
        StatusManager.getManager().handle(adapter, 2);
    }

    private static StatusAdapter getStatusAdapter(String operationName, IStatus original) {
        IStatus status = ExceptionDescriptionUI.getStatus(operationName, original);
        StatusAdapter adapter = new StatusAdapter(ExceptionDescriptionUI.splitTopLevel(operationName, original.getSeverity(), status));
        adapter.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)ExceptionDescription.getContextSummary((int)original.getSeverity(), (String)operationName));
        return adapter;
    }

    private static IStatus splitTopLevel(String operationName, int originalSeverity, IStatus original) {
        int severity = original.getSeverity();
        String description = original.getMessage();
        IStatus[] children = original.getChildren();
        Throwable exception = original.getException();
        String summary = exception != null ? ExceptionDescription.findDescription((String)operationName, (Throwable)exception).getSummary() : ExceptionDescription.getContextSummary((int)originalSeverity, (String)operationName);
        MultiStatus secondLevel = null;
        if (children.length > 0) {
            secondLevel = new MultiStatus("com.ibm.team.foundation.rcp.ui", 0, children, exception != null ? exception.getMessage() : summary, null);
        } else if (exception != null) {
            secondLevel = new Status(severity, "com.ibm.team.foundation.rcp.ui", exception != null ? exception.getMessage() : summary, null);
        }
        if (secondLevel != null) {
            return new MultiStatus("com.ibm.team.foundation.rcp.ui", 0, new IStatus[]{secondLevel}, String.valueOf(summary) + "\n", (Throwable)new Exception(description));
        }
        return new Status(severity, "com.ibm.team.foundation.rcp.ui", String.valueOf(summary) + "\n", (Throwable)new Exception(description));
    }

    private static IStatus getStatus(String operationName, IStatus original) {
        Status status;
        Throwable exception = original.getException();
        String description = exception != null ? ExceptionDescription.findDescription((String)operationName, (Throwable)exception).getDescription() : (original.getMessage() != null ? original.getMessage() : ExceptionDescription.getContextSummary((int)original.getSeverity(), (String)operationName));
        if (original.getChildren().length == 0) {
            int severity = TeamFoundationException.isExpected((Throwable)exception) ? 2 : 4;
            status = new Status(severity, "com.ibm.team.foundation.rcp.ui", description, exception);
        } else {
            ArrayList<IStatus> children = new ArrayList<IStatus>();
            IStatus[] iStatusArray = original.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                children.add(ExceptionDescriptionUI.getStatus(operationName, child));
                ++n2;
            }
            status = new MultiStatus("com.ibm.team.foundation.rcp.ui", 0, children.toArray(new IStatus[children.size()]), description, exception);
        }
        return status;
    }

    public abstract void showExceptionDescription(IWorkbenchWindow var1, ExceptionDescription var2);
}

