/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.internal.favorites;

import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.ui.internal.FoundationRCPUIPlugin;
import com.ibm.team.foundation.rcp.ui.internal.ImagePool;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;

public class FavoritesLabelProvider
extends LabelProvider
implements ITreePathLabelProvider,
IViewerLabelProvider {
    ResourceManager fResources;

    public void updateLabel(ViewerLabel label, Object element) {
        if (this.fResources == null) {
            this.fResources = new LocalResourceManager(JFaceResources.getResources());
        }
        if (element instanceof FavoritesNode) {
            FavoritesNode favorite = (FavoritesNode)element;
            label.setText(favorite.getText());
        }
        if (element instanceof FavoritesFolder) {
            if (element == FavoritesManager.getInstance().getFavorites()) {
                label.setImage(FoundationRCPUIPlugin.getImage(this.fResources, ImagePool.FAVORITES_DOMAIN, null));
            } else {
                label.setImage(FoundationRCPUIPlugin.getImage(this.fResources, ImagePool.FAVORITES_FOLDER, null));
            }
        } else {
            label.setImage(FoundationRCPUIPlugin.getImage(this.fResources, ImagePool.FAVORITES_DEFAULT, null));
        }
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        this.updateLabel(label, element);
    }
}

