/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.internal.favorites;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.foundation.rcp.ui.internal.favorites.IViewerSettable;
import com.ibm.team.foundation.rcp.ui.internal.favorites.Messages;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class FavoritesContentProvider
implements ITreePathContentProvider {
    IViewerSettable fViewerSettable;

    public FavoritesContentProvider(IViewerSettable viewerSettable) {
        this.fViewerSettable = viewerSettable;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(new TreePath(new Object[]{inputElement}));
    }

    public void dispose() {
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parent = parentPath.getLastSegment();
        if (parent instanceof FavoritesFolder) {
            List children = ((FavoritesFolder)parent).getChildren();
            final ArrayList<URIFavorite> favoritesChildren = new ArrayList<URIFavorite>();
            for (Object next : children) {
                if (!(next instanceof URIFavorite)) continue;
                URIFavorite favorite = (URIFavorite)next;
                favoritesChildren.add(favorite);
            }
            new FoundationJob(Messages.FavoritesContentProvider_RESOLVING_FAVORITES){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    FavoritesManager.getInstance().resolveModelObjects(favoritesChildren, monitor);
                    return Status.OK_STATUS;
                }
            }.schedule();
            return children.toArray();
        }
        return new Object[0];
    }

    public TreePath[] getParents(Object element) {
        if (element instanceof FavoritesNode) {
            FavoritesNode favorite = (FavoritesNode)element;
            LinkedList<FavoritesNode> path = new LinkedList<FavoritesNode>();
            while (favorite != FavoritesManager.getInstance().getFavorites()) {
                favorite = favorite.getParent();
                path.addFirst(favorite);
            }
            return new TreePath[]{new TreePath(path.toArray())};
        }
        return new TreePath[0];
    }

    public boolean hasChildren(TreePath path) {
        Object element = path.getLastSegment();
        return element instanceof FavoritesFolder && ((FavoritesFolder)element).getChildren().size() > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.fViewerSettable != null) {
            this.fViewerSettable.setViewer((TreeViewer)viewer);
        }
    }

    public static class FavoritesSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof FavoritesNode) || !(e2 instanceof FavoritesNode)) {
                return super.compare(viewer, e1, e2);
            }
            double i = ((FavoritesNode)e1).getSortOrder() - ((FavoritesNode)e2).getSortOrder();
            if (i < 0.0) {
                return -1;
            }
            if (i > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

