/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import org.eclipse.core.internal.registry.osgi.RegistryCommandProvider$$Cold;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class RegistryCommandProvider
implements CommandProvider {
    private static final String helpText = "---Extension Registry Commands---\n\tns [-v] [name] - display extension points in the namespace; add -v to display extensions\n\tpt [-v] uniqueExtensionPointId - display the extension point and extensions; add -v to display config elements";
    private static final String indent = "   ";
    private boolean verbose = false;

    public String getHelp() {
        return helpText;
    }

    public void _ns(CommandInterpreter commandInterpreter) throws Exception {
        String string = this.getArgument(commandInterpreter);
        if (string == null) {
            String[] stringArray = RegistryFactory.getRegistry().getNamespaces();
            commandInterpreter.println((Object)"Namespace(s):");
            commandInterpreter.println((Object)"-------------------");
            int n = 0;
            while (n < stringArray.length) {
                commandInterpreter.println((Object)stringArray[n]);
                ++n;
            }
            return;
        }
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        IExtensionPoint[] iExtensionPointArray = iExtensionRegistry.getExtensionPoints(string);
        commandInterpreter.println((Object)"Extension point(s):");
        commandInterpreter.println((Object)"-------------------");
        int n = 0;
        while (n < iExtensionPointArray.length) {
            this.displayExtensionPoint(iExtensionPointArray[n], commandInterpreter);
            ++n;
        }
        if (this.verbose) {
            commandInterpreter.println((Object)"\nExtension(s):");
            commandInterpreter.println((Object)"-------------------");
            IExtension[] iExtensionArray = RegistryFactory.getRegistry().getExtensions(string);
            int n2 = 0;
            while (n2 < iExtensionArray.length) {
                this.displayExtension(iExtensionArray[n2], commandInterpreter, true);
                ++n2;
            }
        }
    }

    public void _pt(CommandInterpreter commandInterpreter) throws Exception {
        String string = this.getArgument(commandInterpreter);
        if (string == null) {
            return;
        }
        IExtensionPoint iExtensionPoint = RegistryFactory.getRegistry().getExtensionPoint(string);
        if (iExtensionPoint == null) {
            return;
        }
        commandInterpreter.print((Object)"Extension point: ");
        this.displayExtensionPoint(iExtensionPoint, commandInterpreter);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        commandInterpreter.println((Object)"\nExtension(s):");
        commandInterpreter.println((Object)"-------------------");
        int n = 0;
        while (n < iExtensionArray.length) {
            this.displayExtension(iExtensionArray[n], commandInterpreter, false);
            if (this.verbose) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    this.displayConfigElement(commandInterpreter, iConfigurationElementArray[n2], 1);
                    ++n2;
                }
                commandInterpreter.println();
            }
            ++n;
        }
    }

    private String getArgument(CommandInterpreter commandInterpreter) {
        String string = commandInterpreter.nextArgument();
        if ("-v".equals(string)) {
            this.verbose = true;
            return commandInterpreter.nextArgument();
        }
        this.verbose = false;
        return string;
    }

    private void displayExtensionPoint(IExtensionPoint iExtensionPoint, CommandInterpreter commandInterpreter) throws  {
        RegistryCommandProvider$$Cold.displayExtensionPoint(this, iExtensionPoint, commandInterpreter);
    }

    private void displayExtension(IExtension iExtension, CommandInterpreter commandInterpreter, boolean bl) throws  {
        RegistryCommandProvider$$Cold.displayExtension(this, iExtension, commandInterpreter, bl);
    }

    private void displayConfigElement(CommandInterpreter commandInterpreter, IConfigurationElement iConfigurationElement, int n) throws Exception {
        String string = this.spacing(commandInterpreter, n);
        commandInterpreter.println((Object)(String.valueOf(string) + '<' + iConfigurationElement.getName() + '>'));
        String[] stringArray = iConfigurationElement.getAttributeNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            commandInterpreter.println((Object)(indent + string + stringArray[n2] + " = " + iConfigurationElement.getAttribute(stringArray[n2])));
            ++n2;
        }
        String string2 = iConfigurationElement.getValue();
        if (string2 != null) {
            commandInterpreter.println((Object)(indent + string + string2));
        }
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        int n3 = 0;
        while (n3 < iConfigurationElementArray.length) {
            this.displayConfigElement(commandInterpreter, iConfigurationElementArray[n3], n + 1);
            ++n3;
        }
        commandInterpreter.println((Object)(String.valueOf(string) + "</" + iConfigurationElement.getName() + '>'));
    }

    private String spacing(CommandInterpreter commandInterpreter, int n) throws  {
        return RegistryCommandProvider$$Cold.spacing(this, commandInterpreter, n);
    }
}

