/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.Activator;
import org.eclipse.core.internal.registry.osgi.OSGIUtils$$Cold;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class OSGIUtils {
    private ServiceTracker debugTracker = null;
    private ServiceTracker bundleTracker = null;
    private ServiceTracker configurationLocationTracker = null;
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    private static final OSGIUtils singleton = new OSGIUtils();
    static Class class$0;
    static Class class$1;

    public static OSGIUtils getDefault() {
        return singleton;
    }

    private OSGIUtils() {
        this.initServices();
    }

    private void initServices() {
        BundleContext bundleContext = Activator.getContext();
        if (bundleContext == null) {
            RuntimeLog.log((IStatus)((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.bundle_not_activated, null)));
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        this.debugTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.debugTracker.open();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        this.bundleTracker = new ServiceTracker(bundleContext, clazz2.getName(), null);
        this.bundleTracker.open();
        Filter filter = null;
        try {
            filter = bundleContext.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.configuration.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocationTracker = new ServiceTracker(bundleContext, filter, null);
        this.configurationLocationTracker.open();
    }

    public boolean getBooleanDebugOption(String string, boolean bl) {
        String string2;
        if (this.debugTracker == null) {
            RuntimeLog.log((IStatus)((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.bundle_not_activated, null)));
            return bl;
        }
        DebugOptions debugOptions = (DebugOptions)this.debugTracker.getService();
        if (debugOptions != null && (string2 = debugOptions.getOption(string)) != null) {
            return string2.equalsIgnoreCase("true");
        }
        return bl;
    }

    public PackageAdmin getPackageAdmin() {
        if (this.bundleTracker == null) {
            RuntimeLog.log((IStatus)((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.bundle_not_activated, null)));
            return null;
        }
        return (PackageAdmin)this.bundleTracker.getService();
    }

    public boolean isFragment(Bundle bundle) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return false;
        }
        return (packageAdmin.getBundleType(bundle) & 1) > 0;
    }

    public Location getConfigurationLocation() {
        if (this.configurationLocationTracker == null) {
            return null;
        }
        return (Location)this.configurationLocationTracker.getService();
    }

    void closeServices() {
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.configurationLocationTracker != null) {
            this.configurationLocationTracker.close();
            this.configurationLocationTracker = null;
        }
    }

    public Bundle getBundle(String string) throws  {
        return OSGIUtils$$Cold.getBundle(this, string);
    }

    public Bundle[] getFragments(Bundle bundle) throws  {
        return OSGIUtils$$Cold.getFragments(this, bundle);
    }

    public Bundle[] getHosts(Bundle bundle) throws  {
        return OSGIUtils$$Cold.getHosts(this, bundle);
    }
}

