/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationElementHandle;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.internal.registry.HashtableOfInt;
import org.eclipse.core.internal.registry.HashtableOfStringAndInt;
import org.eclipse.core.internal.registry.IObjectManager;
import org.eclipse.core.internal.registry.KeyedElement;
import org.eclipse.core.internal.registry.KeyedHashSet;
import org.eclipse.core.internal.registry.ReferenceMap;
import org.eclipse.core.internal.registry.RegistryIndexElement;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.RegistryObjectManager$$Cold;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.internal.registry.TableReader;
import org.eclipse.core.internal.registry.TemporaryObjectManager;
import org.eclipse.core.internal.registry.ThirdLevelConfigurationElementHandle;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.spi.RegistryContributor;

public class RegistryObjectManager
implements IObjectManager {
    public static final byte CONFIGURATION_ELEMENT = 1;
    public static final byte EXTENSION = 2;
    public static final byte EXTENSION_POINT = 3;
    public static final byte THIRDLEVEL_CONFIGURATION_ELEMENT = 4;
    static final int CACHE_INITIAL_SIZE = 512;
    static final float DEFAULT_LOADFACTOR = 0.75f;
    static final int[] EMPTY_INT_ARRAY = new int[0];
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static int UNKNOWN = -1;
    private HashtableOfStringAndInt extensionPoints;
    private ReferenceMap cache;
    private HashtableOfInt fileOffsets;
    private int nextId = 1;
    private KeyedHashSet newContributions;
    private Object formerContributions;
    private HashMap contributors;
    private HashMap removedContributors;
    private KeyedHashSet namespacesIndex;
    private Object orphanExtensions;
    private KeyedHashSet heldObjects = new KeyedHashSet();
    private boolean isDirty = false;
    private boolean fromCache = false;
    private ExtensionRegistry registry;
    public static final String PROP_NO_REGISTRY_FLUSHING = "eclipse.noRegistryFlushing";
    static final ExtensionHandle[] EMPTY_EXTENSIONS_ARRAY = new ExtensionHandle[0];

    public RegistryObjectManager(ExtensionRegistry extensionRegistry) {
        this.extensionPoints = new HashtableOfStringAndInt();
        this.cache = "true".equalsIgnoreCase(RegistryProperties.getProperty(PROP_NO_REGISTRY_FLUSHING)) ? new ReferenceMap(0, 512, 0.75f) : new ReferenceMap(1, 512, 0.75f);
        this.newContributions = new KeyedHashSet();
        this.fileOffsets = new HashtableOfInt();
        this.registry = extensionRegistry;
    }

    synchronized void addContribution(Contribution contribution) {
        this.isDirty = true;
        Object object = contribution.getKey();
        KeyedElement keyedElement = this.getFormerContributions().getByKey(object);
        if (keyedElement != null) {
            this.removeContribution(object);
            this.newContributions.add(keyedElement);
        } else {
            keyedElement = this.newContributions.getByKey(object);
        }
        if (keyedElement != null) {
            ((Contribution)keyedElement).mergeContribution(contribution);
        } else {
            this.newContributions.add(contribution);
        }
        this.updateNamespaceIndex(contribution, true);
    }

    private String findCommonNamespaceIdentifier(RegistryObject[] registryObjectArray) {
        String string = null;
        int n = 0;
        while (n < registryObjectArray.length) {
            RegistryObject registryObject = registryObjectArray[n];
            String string2 = null;
            if (registryObject instanceof ExtensionPoint) {
                string2 = ((ExtensionPoint)registryObject).getNamespace();
            } else if (registryObject instanceof Extension) {
                string2 = ((Extension)registryObject).getNamespaceIdentifier();
            }
            if (string == null) {
                string = string2;
            } else if (!string.equals(string2)) {
                return null;
            }
            ++n;
        }
        return string;
    }

    synchronized void removeExtensionPointFromNamespaceIndex(int n, String string) {
        RegistryIndexElement registryIndexElement = this.getNamespaceIndex(string);
        registryIndexElement.updateExtensionPoint(n, false);
    }

    synchronized void removeExtensionFromNamespaceIndex(int n, String string) {
        RegistryIndexElement registryIndexElement = this.getNamespaceIndex(string);
        registryIndexElement.updateExtension(n, false);
    }

    private void updateNamespaceIndex(Contribution contribution, boolean bl) {
        Object object;
        RegistryObject[] registryObjectArray;
        Object object2;
        int[] nArray = contribution.getExtensionPoints();
        RegistryObject[] registryObjectArray2 = this.getObjects(nArray, (byte)3);
        String string = null;
        if (nArray.length > 1) {
            string = this.findCommonNamespaceIdentifier(registryObjectArray2);
        }
        if (string != null) {
            object2 = this.getNamespaceIndex(string);
            ((RegistryIndexElement)object2).updateExtensionPoints(nArray, bl);
        } else {
            int n = 0;
            while (n < nArray.length) {
                registryObjectArray = ((ExtensionPoint)registryObjectArray2[n]).getNamespace();
                object = this.getNamespaceIndex((String)registryObjectArray);
                ((RegistryIndexElement)object).updateExtensionPoint(nArray[n], bl);
                ++n;
            }
        }
        object2 = contribution.getExtensions();
        registryObjectArray = this.getObjects((int[])object2, (byte)2);
        object = null;
        if (((Object)object2).length > 1) {
            object = this.findCommonNamespaceIdentifier(registryObjectArray);
        }
        if (object != null) {
            RegistryIndexElement registryIndexElement = this.getNamespaceIndex((String)object);
            registryIndexElement.updateExtensions((int[])object2, bl);
        } else {
            int n = 0;
            while (n < ((Object)object2).length) {
                String string2 = ((Extension)registryObjectArray[n]).getNamespaceIdentifier();
                RegistryIndexElement registryIndexElement = this.getNamespaceIndex(string2);
                registryIndexElement.updateExtension((int)object2[n], bl);
                ++n;
            }
        }
    }

    synchronized int[] getExtensionPointsFrom(String string) {
        KeyedElement keyedElement = this.newContributions.getByKey(string);
        if (keyedElement == null) {
            keyedElement = this.getFormerContributions().getByKey(string);
        }
        if (keyedElement == null) {
            return EMPTY_INT_ARRAY;
        }
        return ((Contribution)keyedElement).getExtensionPoints();
    }

    synchronized boolean hasContribution(String string) {
        KeyedElement keyedElement = this.newContributions.getByKey(string);
        if (keyedElement == null) {
            keyedElement = this.getFormerContributions().getByKey(string);
        }
        return keyedElement != null;
    }

    private KeyedHashSet getFormerContributions() {
        KeyedHashSet keyedHashSet;
        if (!this.fromCache) {
            return new KeyedHashSet(0);
        }
        if (this.formerContributions == null || (keyedHashSet = (KeyedHashSet)(this.formerContributions instanceof SoftReference ? ((SoftReference)this.formerContributions).get() : this.formerContributions)) == null) {
            keyedHashSet = this.registry.getTableReader().loadContributions();
            this.formerContributions = new SoftReference<KeyedHashSet>(keyedHashSet);
        }
        return keyedHashSet;
    }

    public synchronized void add(RegistryObject registryObject, boolean bl) {
        if (registryObject.getObjectId() == UNKNOWN) {
            int n = this.nextId++;
            registryObject.setObjectId(n);
        }
        this.cache.put(registryObject.getObjectId(), registryObject);
        if (bl) {
            this.hold(registryObject);
        }
    }

    private void hold(RegistryObject registryObject) {
        this.heldObjects.add(registryObject);
    }

    private void release(RegistryObject registryObject) {
        this.heldObjects.remove(registryObject);
    }

    public synchronized Object getObject(int n, byte by) {
        return this.basicGetObject(n, by);
    }

    private Object basicGetObject(int n, byte by) {
        Object object = this.cache.get(n);
        if (object != null) {
            return object;
        }
        if (this.fromCache) {
            object = this.load(n, by);
        }
        if (object == null) {
            throw (Throwable)new InvalidRegistryObjectException();
        }
        this.cache.put(n, object);
        return object;
    }

    public boolean shouldPersist(int n) {
        Object object = this.cache.get(n);
        if (object != null) {
            return ((RegistryObject)object).shouldPersist();
        }
        return true;
    }

    public synchronized RegistryObject[] getObjects(int[] nArray, byte by) {
        if (nArray.length == 0) {
            switch (by) {
                case 3: {
                    return ExtensionPoint.EMPTY_ARRAY;
                }
                case 2: {
                    return Extension.EMPTY_ARRAY;
                }
                case 1: 
                case 4: {
                    return ConfigurationElement.EMPTY_ARRAY;
                }
            }
        }
        RegistryObject[] registryObjectArray = null;
        switch (by) {
            case 3: {
                registryObjectArray = new ExtensionPoint[nArray.length];
                break;
            }
            case 2: {
                registryObjectArray = new Extension[nArray.length];
                break;
            }
            case 1: 
            case 4: {
                registryObjectArray = new ConfigurationElement[nArray.length];
            }
        }
        int n = 0;
        while (n < nArray.length) {
            registryObjectArray[n] = (RegistryObject)this.basicGetObject(nArray[n], by);
            ++n;
        }
        return registryObjectArray;
    }

    synchronized ExtensionPoint getExtensionPointObject(String string) {
        int n = this.extensionPoints.get(string);
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        return (ExtensionPoint)this.getObject(n, (byte)3);
    }

    public Handle getHandle(int n, byte by) {
        switch (by) {
            case 3: {
                return new ExtensionPointHandle(this, n);
            }
            case 2: {
                return new ExtensionHandle(this, n);
            }
            case 1: {
                return new ConfigurationElementHandle(this, n);
            }
        }
        return new ThirdLevelConfigurationElementHandle(this, n);
    }

    public Handle[] getHandles(int[] nArray, byte by) {
        Handle[] handleArray = null;
        int n = nArray.length;
        switch (by) {
            case 3: {
                if (n == 0) {
                    return ExtensionPointHandle.EMPTY_ARRAY;
                }
                handleArray = new ExtensionPointHandle[n];
                int n2 = 0;
                while (n2 < n) {
                    handleArray[n2] = new ExtensionPointHandle(this, nArray[n2]);
                    ++n2;
                }
                break;
            }
            case 2: {
                if (n == 0) {
                    return ExtensionHandle.EMPTY_ARRAY;
                }
                handleArray = new ExtensionHandle[n];
                int n3 = 0;
                while (n3 < n) {
                    handleArray[n3] = new ExtensionHandle(this, nArray[n3]);
                    ++n3;
                }
                break;
            }
            case 1: {
                if (n == 0) {
                    return ConfigurationElementHandle.EMPTY_ARRAY;
                }
                handleArray = new ConfigurationElementHandle[n];
                int n4 = 0;
                while (n4 < n) {
                    handleArray[n4] = new ConfigurationElementHandle(this, nArray[n4]);
                    ++n4;
                }
                break;
            }
            case 4: {
                if (n == 0) {
                    return ConfigurationElementHandle.EMPTY_ARRAY;
                }
                handleArray = new ThirdLevelConfigurationElementHandle[n];
                int n5 = 0;
                while (n5 < n) {
                    handleArray[n5] = new ThirdLevelConfigurationElementHandle(this, nArray[n5]);
                    ++n5;
                }
                break;
            }
        }
        return handleArray;
    }

    synchronized ExtensionPointHandle[] getExtensionPointsHandles() {
        return (ExtensionPointHandle[])this.getHandles(this.extensionPoints.getValues(), (byte)3);
    }

    synchronized ExtensionPointHandle getExtensionPointHandle(String string) {
        int n = this.extensionPoints.get(string);
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        return (ExtensionPointHandle)this.getHandle(n, (byte)3);
    }

    synchronized int[] getExtensionsFrom(String string) {
        KeyedElement keyedElement = this.newContributions.getByKey(string);
        if (keyedElement == null) {
            keyedElement = this.getFormerContributions().getByKey(string);
        }
        if (keyedElement == null) {
            return EMPTY_INT_ARRAY;
        }
        return ((Contribution)keyedElement).getExtensions();
    }

    synchronized boolean addExtensionPoint(ExtensionPoint extensionPoint, boolean bl) {
        String string = extensionPoint.getUniqueIdentifier();
        if (this.extensionPoints.get(string) != Integer.MIN_VALUE) {
            return false;
        }
        this.add(extensionPoint, bl);
        this.extensionPoints.put(string, extensionPoint.getObjectId());
        return true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    synchronized void removeContribution(Object object) {
        boolean bl = this.newContributions.removeByKey(object);
        if (!bl && (bl = this.getFormerContributions().removeByKey(object))) {
            this.formerContributions = this.getFormerContributions();
        }
        if (bl) {
            this.isDirty = true;
            return;
        }
    }

    private Map getOrphans() {
        HashMap hashMap = this.orphanExtensions;
        if (this.orphanExtensions == null && !this.fromCache) {
            hashMap = new HashMap();
            this.orphanExtensions = hashMap;
        } else if (this.orphanExtensions == null || (hashMap = (HashMap)(this.orphanExtensions instanceof SoftReference ? ((SoftReference)this.orphanExtensions).get() : this.orphanExtensions)) == null) {
            hashMap = this.registry.getTableReader().loadOrphans();
            this.orphanExtensions = new SoftReference<HashMap>(hashMap);
        }
        return hashMap;
    }

    void markOrphansHasDirty(Map map) {
        this.orphanExtensions = map;
    }

    void addOrphan(String string, int n) {
        Map map = this.getOrphans();
        int[] nArray = (int[])map.get(string);
        if (nArray != null) {
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray.length] = n;
            map.put(string, nArray2);
        } else {
            map.put(string, new int[]{n});
        }
        this.markOrphansHasDirty(map);
    }

    int[] removeOrphans(String string) {
        Map map = this.getOrphans();
        int[] nArray = (int[])map.remove(string);
        if (nArray != null) {
            this.markOrphansHasDirty(map);
        }
        return nArray;
    }

    Map getOrphanExtensions() {
        return this.getOrphans();
    }

    int getNextId() {
        return this.nextId;
    }

    HashtableOfStringAndInt getExtensionPoints() {
        return this.extensionPoints;
    }

    KeyedHashSet[] getContributions() {
        return new KeyedHashSet[]{this.newContributions, this.getFormerContributions()};
    }

    HashMap getContributors() {
        if (this.contributors == null) {
            this.contributors = !this.fromCache ? new HashMap() : this.registry.getTableReader().loadContributors();
        }
        return this.contributors;
    }

    synchronized RegistryContributor getContributor(String string) {
        RegistryContributor registryContributor = (RegistryContributor)this.getContributors().get(string);
        if (registryContributor != null) {
            return registryContributor;
        }
        if (this.removedContributors != null) {
            return (RegistryContributor)this.removedContributors.get(string);
        }
        return null;
    }

    synchronized void addContributor(RegistryContributor registryContributor) {
        String string = registryContributor.getActualId();
        if (!this.getContributors().containsKey(string)) {
            this.isDirty = true;
            if (this.removedContributors != null) {
                this.removedContributors.remove(string);
            }
            this.getContributors().put(string, registryContributor);
        }
    }

    synchronized void removeContributor(String string) {
        this.isDirty = true;
        RegistryContributor registryContributor = (RegistryContributor)this.getContributors().remove(string);
        if (registryContributor != null) {
            if (this.removedContributors == null) {
                this.removedContributors = new HashMap();
            }
            this.removedContributors.put(string, registryContributor);
        }
    }

    KeyedHashSet getNamespacesIndex() {
        if (this.namespacesIndex == null) {
            this.namespacesIndex = !this.fromCache ? new KeyedHashSet(0) : this.registry.getTableReader().loadNamespaces();
        }
        return this.namespacesIndex;
    }

    private RegistryIndexElement getNamespaceIndex(String string) {
        RegistryIndexElement registryIndexElement = (RegistryIndexElement)this.getNamespacesIndex().getByKey(string);
        if (registryIndexElement == null) {
            registryIndexElement = new RegistryIndexElement(string);
            this.namespacesIndex.add(registryIndexElement);
        }
        return registryIndexElement;
    }

    synchronized Map getAssociatedObjects(String string) {
        RegistryObject registryObject;
        int[] nArray = this.getExtensionPointsFrom(string);
        int[] nArray2 = this.getExtensionsFrom(string);
        HashMap<Integer, Extension> hashMap = new HashMap<Integer, Extension>(nArray.length + nArray2.length);
        int n = 0;
        while (n < nArray2.length) {
            registryObject = (Extension)this.basicGetObject(nArray2[n], (byte)2);
            hashMap.put(new Integer(nArray2[n]), (Extension)registryObject);
            this.collectChildren(registryObject, 0, hashMap);
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            registryObject = (ExtensionPoint)this.basicGetObject(nArray[n], (byte)3);
            hashMap.put(new Integer(nArray[n]), (Extension)registryObject);
            ++n;
        }
        return hashMap;
    }

    synchronized void addNavigableObjects(Map map) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Integer n;
            Extension extension;
            int n2;
            int[] nArray;
            Object object;
            Object object2;
            RegistryObject registryObject = (RegistryObject)iterator.next();
            if (registryObject instanceof Extension) {
                object2 = this.getExtensionPointObject(((Extension)registryObject).getExtensionPointIdentifier());
                if (object2 == null) continue;
                object = new Integer(((RegistryObject)object2).getKeyHashCode());
                if (!map.containsKey(object)) {
                    hashMap.put(new Integer(((RegistryObject)object2).getKeyHashCode()), object2);
                }
                nArray = ((RegistryObject)object2).getRawChildren();
                n2 = 0;
                while (n2 < nArray.length) {
                    extension = (Extension)this.basicGetObject(nArray[n2], (byte)2);
                    if (extension != null && !map.containsKey(n = new Integer(nArray[n2]))) {
                        hashMap.put(n, extension);
                        this.collectChildren(extension, 0, hashMap);
                    }
                    ++n2;
                }
                continue;
            }
            if (!(registryObject instanceof ExtensionPoint) || (nArray = (int[])(object2 = this.getOrphans()).get(object = ((ExtensionPoint)registryObject).getUniqueIdentifier())) == null) continue;
            n2 = 0;
            while (n2 < nArray.length) {
                extension = (Extension)this.basicGetObject(nArray[n2], (byte)2);
                if (extension != null && !map.containsKey(n = new Integer(nArray[n2]))) {
                    hashMap.put(n, extension);
                    this.collectChildren(extension, 0, hashMap);
                }
                ++n2;
            }
        }
        map.putAll((Map)hashMap);
    }

    synchronized void removeObjects(Map map) {
        Collection collection = map.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RegistryObject registryObject = (RegistryObject)iterator.next();
            this.remove(registryObject.getObjectId(), true);
            if (!(registryObject instanceof ExtensionPoint)) continue;
            this.removeExtensionPoint(((ExtensionPoint)registryObject).getUniqueIdentifier());
        }
    }

    IObjectManager createDelegatingObjectManager(Map map) {
        return new TemporaryObjectManager(map, this);
    }

    private void collectChildren(RegistryObject registryObject, int n, Map map) {
        ConfigurationElement[] configurationElementArray = (ConfigurationElement[])this.getObjects(registryObject.getRawChildren(), (byte)(n == 0 || registryObject.noExtraData() ? 1 : 4));
        int n2 = 0;
        while (n2 < configurationElementArray.length) {
            map.put(new Integer(configurationElementArray[n2].getObjectId()), configurationElementArray[n2]);
            this.collectChildren(configurationElementArray[n2], n + 1, map);
            ++n2;
        }
    }

    public void close() {
    }

    public ExtensionRegistry getRegistry() {
        return this.registry;
    }

    synchronized boolean init(long l) {
        TableReader tableReader = this.registry.getTableReader();
        Object[] objectArray = tableReader.loadTables(l);
        if (objectArray == null) {
            return false;
        }
        this.fileOffsets = (HashtableOfInt)objectArray[0];
        this.extensionPoints = (HashtableOfStringAndInt)objectArray[1];
        this.nextId = (Integer)objectArray[2];
        this.fromCache = true;
        if (!this.registry.useLazyCacheLoading()) {
            tableReader.setHoldObjects(true);
            this.markOrphansHasDirty(this.getOrphans());
            this.fromCache = tableReader.readAllCache(this);
            this.formerContributions = this.getFormerContributions();
        }
        return this.fromCache;
    }

    private void remove(RegistryObject registryObject, boolean bl) {
        this.cache.remove(registryObject.getObjectId());
        if (bl) {
            this.release(registryObject);
        }
    }

    synchronized void remove(int n, boolean bl) {
        RegistryObject registryObject = (RegistryObject)this.cache.get(n);
        if (this.fileOffsets != null) {
            this.fileOffsets.removeKey(n);
        }
        if (registryObject != null) {
            this.remove(registryObject, bl);
        }
    }

    private Object load(int n, byte by) {
        TableReader tableReader = this.registry.getTableReader();
        int n2 = this.fileOffsets.get(n);
        if (n2 == Integer.MIN_VALUE) {
            return null;
        }
        switch (by) {
            case 1: {
                return tableReader.loadConfigurationElement(n2);
            }
            case 4: {
                return tableReader.loadThirdLevelConfigurationElements(n2, this);
            }
            case 2: {
                return tableReader.loadExtension(n2);
            }
        }
        return tableReader.loadExtensionPointTree(n2, this);
    }

    synchronized void removeExtensionPoint(String string) {
        int n = this.extensionPoints.removeKey(string);
        if (n == Integer.MIN_VALUE) {
            return;
        }
        this.remove(n, true);
    }

    void addOrphans(String string, int[] nArray) {
        Map map = this.getOrphans();
        int[] nArray2 = (int[])map.get(string);
        if (nArray2 != null) {
            int[] nArray3 = new int[nArray2.length + nArray.length];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            System.arraycopy(nArray, 0, nArray3, nArray2.length, nArray.length);
            map.put(string, nArray3);
        } else {
            map.put(string, nArray);
        }
        this.markOrphansHasDirty(map);
    }

    void removeOrphan(String string, int n) {
        Map map = this.getOrphans();
        int[] nArray = (int[])map.get(string);
        if (nArray == null) {
            return;
        }
        this.markOrphansHasDirty(map);
        int n2 = nArray.length - 1;
        if (n2 == 0) {
            map.remove(string);
            return;
        }
        int[] nArray2 = new int[nArray.length - 1];
        int n3 = 0;
        int n4 = 0;
        while (n3 < nArray.length) {
            if (n != nArray[n3]) {
                nArray2[n4++] = nArray[n3];
            }
            ++n3;
        }
        map.put(string, nArray2);
    }

    private boolean unlinkChildFromContributions(KeyedElement[] keyedElementArray, int n) throws  {
        return RegistryObjectManager$$Cold.unlinkChildFromContributions(this, keyedElementArray, n);
    }

    synchronized boolean unlinkChildFromContributions(int n) {
        if (this.unlinkChildFromContributions(this.newContributions.elements, n)) {
            return true;
        }
        return this.unlinkChildFromContributions(this.getFormerContributions().elements, n);
    }

    public synchronized ExtensionPointHandle[] getExtensionPointsFromNamespace(String string) {
        RegistryIndexElement registryIndexElement = this.getNamespaceIndex(string);
        int[] nArray = registryIndexElement.getExtensionPoints();
        return (ExtensionPointHandle[])this.getHandles(nArray, (byte)3);
    }

    public synchronized ExtensionHandle[] getExtensionsFromNamespace(String string) {
        RegistryIndexElement registryIndexElement = this.getNamespaceIndex(string);
        int[] nArray = registryIndexElement.getExtensions();
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        Extension[] extensionArray = (Extension[])this.getObjects(nArray, (byte)2);
        int n = 0;
        while (n < extensionArray.length) {
            if (this.getExtensionPointObject(extensionArray[n].getExtensionPointIdentifier()) != null) {
                arrayList.add(this.getHandle(extensionArray[n].getObjectId(), (byte)2));
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return EMPTY_EXTENSIONS_ARRAY;
        }
        ExtensionHandle[] extensionHandleArray = new ExtensionHandle[arrayList.size()];
        return arrayList.toArray(extensionHandleArray);
    }
}

