/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.internal.registry.ExtensionDelta;
import org.eclipse.core.internal.registry.IObjectManager;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;

public class RegistryDelta {
    private Set extensionDeltas = new HashSet();
    private IObjectManager objectManager;

    RegistryDelta() {
    }

    public int getExtensionDeltasCount() {
        return this.extensionDeltas.size();
    }

    public IExtensionDelta[] getExtensionDeltas() {
        return this.extensionDeltas.toArray(new ExtensionDelta[this.extensionDeltas.size()]);
    }

    public IExtensionDelta[] getExtensionDeltas(String string) {
        LinkedList<IExtensionDelta> linkedList = new LinkedList<IExtensionDelta>();
        Iterator iterator = this.extensionDeltas.iterator();
        while (iterator.hasNext()) {
            IExtensionDelta iExtensionDelta = (IExtensionDelta)iterator.next();
            if (!iExtensionDelta.getExtension().getExtensionPointUniqueIdentifier().equals(string)) continue;
            linkedList.add(iExtensionDelta);
        }
        return linkedList.toArray(new IExtensionDelta[linkedList.size()]);
    }

    public IExtensionDelta getExtensionDelta(String string, String string2) {
        Iterator iterator = this.extensionDeltas.iterator();
        while (iterator.hasNext()) {
            IExtensionDelta iExtensionDelta = (IExtensionDelta)iterator.next();
            IExtension iExtension = iExtensionDelta.getExtension();
            if (!iExtension.getExtensionPointUniqueIdentifier().equals(string) || iExtension.getUniqueIdentifier() == null || !iExtension.getUniqueIdentifier().equals(string2)) continue;
            return iExtensionDelta;
        }
        return null;
    }

    void addExtensionDelta(IExtensionDelta iExtensionDelta) {
        this.extensionDeltas.add(iExtensionDelta);
        ((ExtensionDelta)iExtensionDelta).setContainingDelta(this);
    }

    public String toString() {
        return "\n\tHost : " + this.extensionDeltas;
    }

    void setObjectManager(IObjectManager iObjectManager) {
        this.objectManager = iObjectManager;
    }

    public IObjectManager getObjectManager() {
        return this.objectManager;
    }
}

