/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import org.eclipse.core.internal.registry.KeyedElement;
import org.eclipse.core.internal.registry.KeyedHashSet$$Cold;

public class KeyedHashSet {
    protected static final int MINIMUM_SIZE = 7;
    private int capacity;
    protected int elementCount = 0;
    protected KeyedElement[] elements;
    protected boolean replace;

    public KeyedHashSet() {
        this(7, true);
    }

    public KeyedHashSet(int n) {
        this(n, true);
    }

    public KeyedHashSet(int n, boolean bl) {
        this.elements = new KeyedElement[Math.max(7, n * 2)];
        this.replace = bl;
        this.capacity = n;
    }

    public boolean add(KeyedElement keyedElement) {
        int n;
        int n2 = n = this.hash(keyedElement);
        while (n2 < this.elements.length) {
            if (this.elements[n2] == null) {
                this.elements[n2] = keyedElement;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (this.elements[n2].compare(keyedElement)) {
                if (this.replace) {
                    this.elements[n2] = keyedElement;
                }
                return this.replace;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            if (this.elements[n2] == null) {
                this.elements[n2] = keyedElement;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return true;
            }
            if (this.elements[n2].compare(keyedElement)) {
                if (this.replace) {
                    this.elements[n2] = keyedElement;
                }
                return this.replace;
            }
            ++n2;
        }
        this.expand();
        return this.add(keyedElement);
    }

    public KeyedElement[] elements() {
        return (KeyedElement[])this.elements(new KeyedElement[this.elementCount]);
    }

    public Object[] elements(Object[] objectArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.length) {
            KeyedElement keyedElement = this.elements[n2];
            if (keyedElement != null) {
                objectArray[n++] = keyedElement;
            }
            ++n2;
        }
        return objectArray;
    }

    protected void expand() {
        KeyedElement[] keyedElementArray = this.elements;
        this.elements = new KeyedElement[this.elements.length * 2];
        int n = this.elements.length - 1;
        int n2 = 0;
        while (n2 < keyedElementArray.length) {
            KeyedElement keyedElement = keyedElementArray[n2];
            if (keyedElement != null) {
                int n3 = this.hash(keyedElement);
                while (this.elements[n3] != null) {
                    if (++n3 <= n) continue;
                    n3 = 0;
                }
                this.elements[n3] = keyedElement;
            }
            ++n2;
        }
    }

    public KeyedElement getByKey(Object object) {
        KeyedElement keyedElement;
        int n;
        if (this.elementCount == 0) {
            return null;
        }
        int n2 = n = this.keyHash(object);
        while (n2 < this.elements.length) {
            keyedElement = this.elements[n2];
            if (keyedElement == null) {
                return null;
            }
            if (keyedElement.getKey().equals(object)) {
                return keyedElement;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            keyedElement = this.elements[n2];
            if (keyedElement == null) {
                return null;
            }
            if (keyedElement.getKey().equals(object)) {
                return keyedElement;
            }
            ++n2;
        }
        return null;
    }

    private int hash(KeyedElement keyedElement) {
        return Math.abs(keyedElement.getKeyHashCode()) % this.elements.length;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    private int keyHash(Object object) {
        return Math.abs(object.hashCode()) % this.elements.length;
    }

    public boolean removeByKey(Object object) {
        KeyedElement keyedElement;
        int n;
        if (this.elementCount == 0) {
            return false;
        }
        int n2 = n = this.keyHash(object);
        while (n2 < this.elements.length) {
            keyedElement = this.elements[n2];
            if (keyedElement == null) {
                return false;
            }
            if (keyedElement.getKey().equals(object)) {
                this.rehashTo(n2);
                --this.elementCount;
                return true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            keyedElement = this.elements[n2];
            if (keyedElement == null) {
                return false;
            }
            if (keyedElement.getKey().equals(object)) {
                this.rehashTo(n2);
                --this.elementCount;
                return true;
            }
            ++n2;
        }
        return true;
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.elements.length * 0.75;
    }

    public int size() {
        return this.elementCount;
    }

    public void clear() {
        this.elements = new KeyedElement[Math.max(7, this.capacity * 2)];
        this.elementCount = 0;
    }

    public KeyedElement get(KeyedElement keyedElement) {
        KeyedElement keyedElement2;
        int n;
        if (this.elementCount == 0) {
            return null;
        }
        int n2 = n = this.hash(keyedElement);
        while (n2 < this.elements.length) {
            keyedElement2 = this.elements[n2];
            if (keyedElement2 == null) {
                return null;
            }
            if (keyedElement2.compare(keyedElement)) {
                return keyedElement2;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            keyedElement2 = this.elements[n2];
            if (keyedElement2 == null) {
                return null;
            }
            if (keyedElement2.compare(keyedElement)) {
                return keyedElement2;
            }
            ++n2;
        }
        return null;
    }

    protected void rehashTo(int n) {
        int n2 = n;
        int n3 = n + 1;
        if (n3 >= this.elements.length) {
            n3 = 0;
        }
        KeyedElement keyedElement = this.elements[n3];
        while (keyedElement != null) {
            boolean bl;
            int n4 = this.hash(keyedElement);
            if (n3 < n2) {
                bl = n4 <= n2 && n4 > n3;
            } else {
                boolean bl2 = bl = n4 <= n2 || n4 > n3;
            }
            if (bl) {
                this.elements[n2] = keyedElement;
                n2 = n3;
            }
            if (++n3 >= this.elements.length) {
                n3 = 0;
            }
            keyedElement = this.elements[n3];
        }
        this.elements[n2] = null;
    }

    public boolean remove(KeyedElement keyedElement) {
        KeyedElement keyedElement2;
        int n;
        if (this.elementCount == 0) {
            return false;
        }
        int n2 = n = this.hash(keyedElement);
        while (n2 < this.elements.length) {
            keyedElement2 = this.elements[n2];
            if (keyedElement2 == null) {
                return false;
            }
            if (keyedElement2.compare(keyedElement)) {
                this.rehashTo(n2);
                --this.elementCount;
                return true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            keyedElement2 = this.elements[n2];
            if (keyedElement2 == null) {
                return false;
            }
            if (keyedElement2.compare(keyedElement)) {
                this.rehashTo(n2);
                --this.elementCount;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() throws  {
        return KeyedHashSet$$Cold.toString(this);
    }
}

