/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class HashtableOfInt {
    private int[] keyTable;
    private int[] valueTable;
    private static final float GROWTH_FACTOR = 1.33f;
    private int elementSize = 0;
    private int threshold;

    public HashtableOfInt() {
        this(13);
    }

    public HashtableOfInt(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.33f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new int[n2];
        this.valueTable = new int[n2];
    }

    public int put(int n, int n2) {
        int n3;
        int n4 = n % this.valueTable.length;
        while ((n3 = this.keyTable[n4]) != 0) {
            if (n3 == n) {
                this.valueTable[n4] = n2;
                return this.valueTable[n4];
            }
            n4 = (n4 + 1) % this.keyTable.length;
        }
        this.keyTable[n4] = n;
        this.valueTable[n4] = n2;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n2;
    }

    public int size() {
        return this.elementSize;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.elementSize);
        int n = this.keyTable.length;
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.threshold);
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeInt(this.keyTable[n2]);
            dataOutputStream.writeInt(this.valueTable[n2]);
            ++n2;
        }
    }

    public boolean containsKey(int n) {
        int n2;
        int n3 = n % this.valueTable.length;
        while ((n2 = this.keyTable[n3]) != 0) {
            if (n2 == n) {
                return true;
            }
            n3 = (n3 + 1) % this.keyTable.length;
        }
        return false;
    }

    public int get(int n) {
        int n2;
        int n3 = n % this.valueTable.length;
        while ((n2 = this.keyTable[n3]) != 0) {
            if (n2 == n) {
                return this.valueTable[n3];
            }
            n3 = (n3 + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    public int removeKey(int n) {
        int n2;
        int n3 = n % this.valueTable.length;
        while ((n2 = this.keyTable[n3]) != 0) {
            if (n2 == n) {
                return this.valueTable[n3];
            }
            n3 = (n3 + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    private void rehash() {
        HashtableOfInt hashtableOfInt = new HashtableOfInt((int)((float)this.elementSize * 1.33f));
        int n = this.keyTable.length;
        while (--n >= 0) {
            int n2 = this.keyTable[n];
            if (n2 == 0) continue;
            hashtableOfInt.put(n2, this.valueTable[n]);
        }
        this.keyTable = hashtableOfInt.keyTable;
        this.valueTable = hashtableOfInt.valueTable;
        this.threshold = hashtableOfInt.threshold;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.valueTable.length;
        while (n < n2) {
            int n3 = this.valueTable[n];
            if (n3 != Integer.MIN_VALUE) {
                string = String.valueOf(string) + this.keyTable[n] + " -> " + n3 + "\n";
            }
            ++n;
        }
        return string;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.elementSize = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        this.threshold = dataInputStream.readInt();
        boolean bl = true;
        if ((double)n / (double)this.elementSize < (double)1.33f) {
            this.keyTable = new int[(int)((float)this.elementSize * 1.33f)];
            this.valueTable = new int[(int)((float)this.elementSize * 1.33f)];
            this.elementSize = 0;
            bl = false;
        } else {
            this.keyTable = new int[n];
            this.valueTable = new int[n];
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            if (bl) {
                this.keyTable[n2] = n3;
                this.valueTable[n2] = n4;
            } else {
                this.put(n3, n4);
            }
            ++n2;
        }
    }
}

