/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.lang.ref.SoftReference;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.runtime.IContributor;

public class Extension
extends RegistryObject {
    public static final Extension[] EMPTY_ARRAY = new Extension[0];
    private String simpleId;
    private String namespaceIdentifier;
    private Object extraInformation;
    private static final byte LABEL = 0;
    private static final byte XPT_NAME = 1;
    private static final byte CONTRIBUTOR_ID = 2;
    private static final int EXTRA_SIZE = 3;

    protected Extension(ExtensionRegistry extensionRegistry, boolean bl) {
        super(extensionRegistry, bl);
    }

    protected Extension(int n, String string, String string2, int[] nArray, int n2, ExtensionRegistry extensionRegistry, boolean bl) {
        super(extensionRegistry, bl);
        this.setObjectId(n);
        this.simpleId = string;
        this.setRawChildren(nArray);
        this.setExtraDataOffset(n2);
        this.namespaceIdentifier = string2;
    }

    protected String getExtensionPointIdentifier() {
        return this.getExtraData()[1];
    }

    protected String getSimpleIdentifier() {
        return this.simpleId;
    }

    protected String getUniqueIdentifier() {
        return this.simpleId == null ? null : String.valueOf(this.getNamespaceIdentifier()) + '.' + this.simpleId;
    }

    void setExtensionPointIdentifier(String string) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[1] = string;
    }

    void setSimpleIdentifier(String string) {
        this.simpleId = string;
    }

    private String[] getExtraData() {
        if (this.noExtraData()) {
            if (this.extraInformation != null) {
                return (String[])this.extraInformation;
            }
            return null;
        }
        String[] stringArray = null;
        if (this.extraInformation == null || (stringArray = this.extraInformation instanceof SoftReference ? (String[])((SoftReference)this.extraInformation).get() : (String[])this.extraInformation) == null) {
            stringArray = this.registry.getTableReader().loadExtensionExtraData(this.getExtraDataOffset());
            this.extraInformation = new SoftReference<String[]>(stringArray);
        }
        return stringArray;
    }

    String getLabel() {
        String string = this.getExtraData()[0];
        if (string == null) {
            return "";
        }
        return string;
    }

    void setLabel(String string) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[0] = string;
    }

    String getContributorId() {
        String string = this.getExtraData()[2];
        if (string == null) {
            return "";
        }
        return string;
    }

    public IContributor getContributor() {
        return this.registry.getObjectManager().getContributor(this.getContributorId());
    }

    void setContributorId(String string) {
        this.ensureExtraInformationType();
        ((String[])this.extraInformation)[2] = string;
    }

    public String getNamespaceIdentifier() {
        return this.namespaceIdentifier;
    }

    void setNamespaceIdentifier(String string) {
        this.namespaceIdentifier = string;
    }

    public String toString() {
        return String.valueOf(this.getUniqueIdentifier()) + " -> " + this.getExtensionPointIdentifier();
    }

    private void ensureExtraInformationType() {
        if (this.extraInformation instanceof SoftReference) {
            this.extraInformation = ((SoftReference)this.extraInformation).get();
        }
        if (this.extraInformation == null) {
            this.extraInformation = new String[3];
        }
    }
}

