/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationElementHandle$$Cold;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.internal.registry.IObjectManager;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;

public class ConfigurationElementHandle
extends Handle
implements IConfigurationElement {
    static final ConfigurationElementHandle[] EMPTY_ARRAY = new ConfigurationElementHandle[0];

    public ConfigurationElementHandle(IObjectManager iObjectManager, int n) {
        super(iObjectManager, n);
    }

    protected ConfigurationElement getConfigurationElement() {
        return (ConfigurationElement)this.objectManager.getObject(this.getId(), (byte)1);
    }

    protected boolean shouldPersist() {
        return this.getConfigurationElement().shouldPersist();
    }

    public String getAttribute(String string) {
        return this.getConfigurationElement().getAttribute(string);
    }

    public String[] getAttributeNames() {
        return this.getConfigurationElement().getAttributeNames();
    }

    public IConfigurationElement[] getChildren() {
        ConfigurationElement configurationElement = this.getConfigurationElement();
        if (configurationElement.noExtraData()) {
            return (IConfigurationElement[])this.objectManager.getHandles(configurationElement.getRawChildren(), (byte)1);
        }
        return (IConfigurationElement[])this.objectManager.getHandles(configurationElement.getRawChildren(), (byte)4);
    }

    public Object createExecutableExtension(String string) throws CoreException {
        try {
            return this.getConfigurationElement().createExecutableExtension(string);
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            Status status = new Status(4, "org.eclipse.equinox.registry", 1, "Invalid registry object", (Throwable)invalidRegistryObjectException);
            if (this.objectManager instanceof RegistryObjectManager) {
                ((RegistryObjectManager)this.objectManager).getRegistry().log((IStatus)status);
            }
            throw (Throwable)new CoreException((IStatus)status);
        }
    }

    public String getAttributeAsIs(String string) {
        return this.getConfigurationElement().getAttributeAsIs(string);
    }

    public IExtension getDeclaringExtension() {
        Object object = this;
        while (!((object = ((ConfigurationElementHandle)object).getParent()) instanceof ExtensionHandle)) {
        }
        return (IExtension)object;
    }

    public String getName() {
        return this.getConfigurationElement().getName();
    }

    public Object getParent() {
        ConfigurationElement configurationElement = this.getConfigurationElement();
        return this.objectManager.getHandle(configurationElement.parentId, configurationElement.parentType);
    }

    public String getValue() {
        return this.getConfigurationElement().getValue();
    }

    public String getValueAsIs() {
        return this.getConfigurationElement().getValueAsIs();
    }

    RegistryObject getObject() {
        return this.getConfigurationElement();
    }

    public String getNamespace() {
        return this.getContributor().getName();
    }

    public String getNamespaceIdentifier() {
        return this.getDeclaringExtension().getNamespaceIdentifier();
    }

    public IContributor getContributor() {
        return this.getConfigurationElement().getContributor();
    }

    public boolean isValid() {
        try {
            this.getConfigurationElement();
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return false;
        }
        return true;
    }

    public IConfigurationElement[] getChildren(String string) throws  {
        return ConfigurationElementHandle$$Cold.getChildren(this, string);
    }
}

