/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.common.internal.Messages;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionablePath {
    private static VersionablePath nullPath;
    private VersionablePathSegment[] segments;
    private SiloedItemId<IVersionable> item;
    private boolean isResolved;
    private static final String UNRESOLVED_PATH;

    static {
        UNRESOLVED_PATH = Messages.getString("UNRESOLVED_PATH");
    }

    private VersionablePath(VersionablePathSegment[] segments, SiloedItemId<IVersionable> item, boolean isAbsolute) {
        this.segments = segments;
        this.item = item;
        this.isResolved = isAbsolute;
    }

    private VersionablePath(List<VersionablePathSegment> segments, SiloedItemId<IVersionable> item, boolean isAbsolute) {
        this.segments = new VersionablePathSegment[segments.size()];
        segments.toArray(this.segments);
        this.item = item;
        this.isResolved = isAbsolute;
    }

    public static VersionablePath create(VersionablePathSegment[] segments, SiloedItemId<IVersionable> item, boolean isAbsolute) {
        return new VersionablePath(segments, item, isAbsolute);
    }

    public static VersionablePath create(IPath path) {
        VersionablePathSegment[] segments = new VersionablePathSegment[path.segmentCount()];
        ItemId itemId = ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
        int idx = 0;
        while (idx < segments.length) {
            segments[idx] = VersionablePathSegment.create((ItemId<IFolder>)itemId, path.segment(idx));
            ++idx;
        }
        return new VersionablePath(segments, (SiloedItemId<IVersionable>)SiloedItemId.getNullItem((IItemType)IVersionable.ITEM_TYPE), path.isAbsolute());
    }

    public static VersionablePath create(List<VersionablePathSegment> segments, SiloedItemId<IVersionable> item, boolean isAbsolute) {
        return new VersionablePath(segments, item, isAbsolute);
    }

    public boolean isAbsolute() {
        return this.isResolved;
    }

    public ItemId<IVersionable> getRoot() {
        if (this.segments.length > 0) {
            return ItemId.upcast(this.segments[0].getParent());
        }
        return this.getItemId();
    }

    public SiloedItemId<IVersionable> getSiloedRoot() {
        return SiloedItemId.create(this.getRoot(), (ItemId)this.item.getComponent());
    }

    public int segmentCount() {
        return this.segments.length;
    }

    public ItemId<IVersionable> getItemId() {
        return this.item.getItemId();
    }

    public SiloedItemId<IVersionable> getSiloedItemId() {
        return this.item;
    }

    public VersionablePath append(VersionablePath nextPath) {
        VersionablePathSegment[] newPath = new VersionablePathSegment[this.segments.length + nextPath.segments.length];
        System.arraycopy(this.segments, 0, newPath, 0, this.segments.length);
        System.arraycopy(nextPath.segments, 0, newPath, this.segments.length, nextPath.segments.length);
        return new VersionablePath(newPath, nextPath.getSiloedItemId(), this.isResolved);
    }

    public VersionablePathSegment segment(int idx) {
        return this.segments[idx];
    }

    public IPath toPath() {
        String pathString = this.computePathString();
        if (!this.isAbsolute()) {
            String unresolvedString = "unresolved/" + this.getRoot().getItemUUID().getUuidValue();
            if (pathString.equals("")) {
                return new Path(unresolvedString);
            }
            return new Path(String.valueOf(unresolvedString) + "/" + pathString);
        }
        return new Path(pathString);
    }

    public String toString() {
        String pathString = this.computePathString();
        if (!this.isAbsolute()) {
            if (pathString.equals("")) {
                return UNRESOLVED_PATH;
            }
            return String.valueOf(UNRESOLVED_PATH) + "/" + pathString;
        }
        return pathString;
    }

    private String computePathString() {
        StringBuffer buf = new StringBuffer();
        boolean isFirst = true;
        int idx = 0;
        while (idx < this.segments.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append("/");
            }
            buf.append(this.segments[idx].lastSegment());
            ++idx;
        }
        return buf.toString();
    }

    public static VersionablePath create(IAncestorReport nextReport, ItemId<IComponent> component) {
        ArrayList<VersionablePathSegment> pathSegments = new ArrayList<VersionablePathSegment>();
        List nameItemPairs = nextReport.getNameItemPairs();
        ItemId parent = ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
        boolean isFirst = true;
        for (INameItemPair next : nameItemPairs) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            pathSegments.add(VersionablePathSegment.create((ItemId<IFolder>)parent, next.getName()));
            parent = ItemId.create((IItemHandle)next.getItem());
        }
        return VersionablePath.create(pathSegments, (SiloedItemId<IVersionable>)SiloedItemId.create((ItemId)parent, component), !nameItemPairs.isEmpty());
    }

    public VersionablePath append(String filename, SiloedItemId<IVersionable> itemId) {
        ArrayList<VersionablePathSegment> segments = new ArrayList<VersionablePathSegment>();
        segments.addAll((Collection)Arrays.asList(this.segments));
        segments.add(VersionablePathSegment.create((ItemId<IFolder>)this.item.getItemId(), filename));
        return VersionablePath.create(segments, itemId, this.isResolved);
    }

    public VersionablePath append(String filename, ItemId<IVersionable> itemId) {
        ArrayList<VersionablePathSegment> segments = new ArrayList<VersionablePathSegment>();
        segments.addAll((Collection)Arrays.asList(this.segments));
        segments.add(VersionablePathSegment.create((ItemId<IFolder>)this.item.getItemId(), filename));
        return VersionablePath.create(segments, (SiloedItemId<IVersionable>)SiloedItemId.create(itemId, (ItemId)this.item.getComponent()), this.isResolved);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isResolved ? 1231 : 1237);
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + Arrays.hashCode(this.segments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionablePath other = (VersionablePath)obj;
        if (this.isResolved != other.isResolved) {
            return false;
        }
        if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
            return false;
        }
        return Arrays.equals(this.segments, other.segments);
    }

    public VersionablePath removeLastSegments(int i) {
        if (this.segments.length == 0) {
            SiloedItemId id = SiloedItemId.create((IItemType)this.getItemId().getItemType(), (UUID)ItemId.getNullItemUUID(), (UUID)this.getSiloedItemId().getComponentUUID());
            return new VersionablePath(this.segments, (SiloedItemId<IVersionable>)id, this.isAbsolute());
        }
        List segments = NewCollection.arrayList();
        int j = 0;
        while (j < this.segments.length - 1) {
            VersionablePathSegment seg = this.segments[j];
            segments.add(seg);
            ++j;
        }
        ItemId parentId = ItemId.upcast(this.segments[this.segments.length - 1].getParent());
        SiloedItemId item = SiloedItemId.create((ItemId)parentId, (ItemId)this.item.getComponent());
        return new VersionablePath(segments, (SiloedItemId<IVersionable>)item, this.isResolved);
    }

    public static VersionablePath getNullPath() {
        if (nullPath == null) {
            SiloedItemId id = SiloedItemId.getNullItem((IItemType)IVersionable.ITEM_TYPE);
            nullPath = new VersionablePath(new VersionablePathSegment[0], (SiloedItemId<IVersionable>)id, false);
        }
        return nullPath;
    }

    public static VersionablePath getUnresolvedPath(IVersionable versionable, ItemId<IComponent> component) {
        return new VersionablePath(new VersionablePathSegment[]{VersionablePathSegment.pathFor(versionable)}, (SiloedItemId<IVersionable>)SiloedItemId.create((ItemId)ItemId.forItem((IItem)versionable), component), false);
    }

    public static VersionablePath getUnresolvedPath(SiloedItemId itemId) {
        return new VersionablePath(new VersionablePathSegment[0], (SiloedItemId<IVersionable>)itemId, false);
    }

    public static VersionablePath getUnresolvedPath(ItemId<IVersionable> itemId) {
        return VersionablePath.getUnresolvedPath(itemId, (ItemId<IComponent>)ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE));
    }

    public static VersionablePath getUnresolvedPath(ItemId<IVersionable> itemId, ItemId<IComponent> component) {
        return new VersionablePath(new VersionablePathSegment[0], (SiloedItemId<IVersionable>)SiloedItemId.create(itemId, component), false);
    }

    public String getFileName() {
        if (this.segments.length > 0) {
            return this.segments[0].lastSegment();
        }
        return this.item.getItemUUID().getUuidValue();
    }
}

