/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResolvedConfigurationChangePaths {
    private IPathResolver pathResolver;
    private boolean resolveConflicts;
    private IPathResolver beforeResolver = new IPathResolver(){

        @Override
        public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
            return ResolvedConfigurationChangePaths.this.computePaths(unresolved, true, monitor);
        }
    };
    private IPathResolver afterResolver = new IPathResolver(){

        @Override
        public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
            return ResolvedConfigurationChangePaths.this.computePaths(unresolved, false, monitor);
        }
    };
    private Map<SiloedItemId<IVersionable>, VersionablePathSegment> resolvedPaths = new HashMap<SiloedItemId<IVersionable>, VersionablePathSegment>();
    private Map<SiloedItemId<IVersionable>, List<FileChange>> changesByItem;
    private Collection<SiloedItemId<IVersionable>> knownTopLevelItems = new HashSet<SiloedItemId<IVersionable>>();

    private ResolvedConfigurationChangePaths(IPathResolver resolver, ConfigurationChange change, boolean resolveConflicts) {
        this.changesByItem = change.getChangesByItem();
        this.pathResolver = resolver;
        this.resolveConflicts = resolveConflicts;
        for (List<FileChange> changes : this.changesByItem.values()) {
            for (FileChange next : changes) {
                if (!next.getNonDeleted(true).getPath().getParent().isNull()) continue;
                this.knownTopLevelItems.add(next.getSiloedItemId());
            }
        }
    }

    public IPathResolver getPathResolver(boolean beforePaths) {
        return beforePaths ? this.beforeResolver : this.afterResolver;
    }

    public Map<SiloedItemId<IVersionable>, VersionablePath> computePaths(Collection<SiloedItemId<IVersionable>> versionables, boolean beforeState, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<SiloedItemId<IVersionable>, VersionablePath> result = new HashMap<SiloedItemId<IVersionable>, VersionablePath>();
        HashMap toFetch = new HashMap();
        this.fetchMoreSegments(versionables, (IProgressMonitor)progress.newChild(10));
        for (SiloedItemId<IVersionable> next : versionables) {
            VersionablePath nextPath = this.getKnownSegments(next, beforeState);
            if (nextPath.isAbsolute()) {
                result.put(next, nextPath);
                continue;
            }
            CollectionUtil.addToMapOfLists(toFetch, nextPath.getSiloedRoot(), (Object)nextPath);
        }
        while (!toFetch.isEmpty()) {
            HashMap nextToFetch = new HashMap();
            this.fetchMoreSegments(toFetch.keySet(), (IProgressMonitor)progress.newChild(50));
            for (SiloedItemId next : toFetch.keySet()) {
                VersionablePath beforeSegments = this.getKnownSegments((SiloedItemId<IVersionable>)next, beforeState);
                List nextPaths = (List)toFetch.get(next);
                if (beforeSegments.segmentCount() == 0) {
                    for (VersionablePath nextPath : nextPaths) {
                        result.put(nextPath.getSiloedItemId(), nextPath);
                    }
                    continue;
                }
                for (VersionablePath nextPath : nextPaths) {
                    VersionablePath computedPath = beforeSegments.append(nextPath);
                    if (computedPath.isAbsolute()) {
                        result.put(nextPath.getSiloedItemId(), computedPath);
                        continue;
                    }
                    CollectionUtil.addToMapOfLists(nextToFetch, computedPath.getSiloedRoot(), (Object)computedPath);
                }
            }
            toFetch = nextToFetch;
        }
        return result;
    }

    private void fetchMoreSegments(Collection<SiloedItemId<IVersionable>> keySet, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet<SiloedItemId<IVersionable>> newKeySet = new HashSet<SiloedItemId<IVersionable>>();
        for (SiloedItemId<IVersionable> next : keySet) {
            if (this.resolvedPaths.containsKey(next)) continue;
            newKeySet.add(next);
        }
        if (newKeySet.isEmpty()) {
            return;
        }
        Map<SiloedItemId<IVersionable>, VersionablePath> resolved = this.pathResolver.resolve(newKeySet, (IProgressMonitor)progress.newChild(100));
        for (VersionablePath next : resolved.values()) {
            SiloedItemId nextId = next.getSiloedItemId();
            int idx = next.segmentCount() - 1;
            while (idx >= 0) {
                VersionablePathSegment nextSegment = next.segment(idx);
                if (!this.resolvedPaths.containsKey(nextId)) {
                    this.resolvedPaths.put(nextId, nextSegment);
                }
                nextId = SiloedItemId.upcast((SiloedItemId)SiloedItemId.create(nextSegment.getParent(), (ItemId)next.getSiloedItemId().getComponent()));
                --idx;
            }
            if (!next.isAbsolute()) continue;
            SiloedItemId topLevelItem = null;
            if (next.segmentCount() > 1) {
                topLevelItem = SiloedItemId.upcast((SiloedItemId)SiloedItemId.create(next.segment(1).getParent(), (ItemId)next.getSiloedItemId().getComponent()));
            } else if (next.segmentCount() > 0) {
                topLevelItem = next.getSiloedItemId();
            }
            if (topLevelItem == null) continue;
            this.knownTopLevelItems.add(topLevelItem);
        }
    }

    private VersionablePath getKnownSegments(SiloedItemId<IVersionable> next, boolean beforeState) {
        LinkedList<VersionablePathSegment> segments = new LinkedList<VersionablePathSegment>();
        HashSet<SiloedItemId> versionables = new HashSet<SiloedItemId>();
        if (next.getItemId().isNull()) {
            return VersionablePath.create(new VersionablePathSegment[0], next, false);
        }
        boolean resolved = false;
        SiloedItemId nextItem = next;
        while (nextItem != null && !resolved) {
            if (versionables.contains(nextItem)) break;
            versionables.add(nextItem);
            VersionablePathSegment nextSegment = this.getCachedPath(nextItem, beforeState);
            if (this.knownTopLevelItems.contains(nextItem)) {
                resolved = true;
            }
            if (nextSegment != null) {
                segments.addFirst(nextSegment);
                nextItem = SiloedItemId.upcast((SiloedItemId)SiloedItemId.create(nextSegment.getParent(), (ItemId)next.getComponent()));
                continue;
            }
            nextItem = null;
        }
        return VersionablePath.create(segments, next, resolved);
    }

    private VersionablePathSegment getPath(List<FileChange> changes, boolean beforeStates) {
        HashSet<VersionablePathSegment> parentPaths = new HashSet<VersionablePathSegment>();
        for (FileChange next : changes) {
            FileState state = next.getNonDeleted(beforeStates);
            parentPaths.add(state.getPath());
        }
        VersionablePathSegment result = null;
        if (parentPaths.size() == 1 || parentPaths.size() > 1 && this.resolveConflicts) {
            result = (VersionablePathSegment)parentPaths.iterator().next();
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    private VersionablePathSegment getCachedPath(SiloedItemId<IVersionable> next, boolean beforeState) {
        List<FileChange> changes = this.changesByItem.get(next);
        if (next.getItemId().isNull()) {
            return null;
        }
        if (changes != null) {
            return this.getPath(changes, beforeState);
        }
        VersionablePathSegment result = this.resolvedPaths.get(next);
        if (result != null && result.getParent().equals((Object)next.getItemId())) {
            throw new IllegalStateException("Error: found an item that has itself as its own parent");
        }
        return result;
    }

    public static ResolvedConfigurationChangePaths resolve(IPathResolver context, ConfigurationChange config, IProgressMonitor monitor) throws TeamRepositoryException {
        return ResolvedConfigurationChangePaths.resolve(context, config, true, monitor);
    }

    public static ResolvedConfigurationChangePaths resolve(IPathResolver context, ConfigurationChange config, boolean resolveConflicts, IProgressMonitor monitor) throws TeamRepositoryException {
        ResolvedConfigurationChangePaths result = new ResolvedConfigurationChangePaths(context, config, resolveConflicts);
        result.resolveAll(monitor);
        return result;
    }

    public void resolveAll(IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<SiloedItemId<IVersionable>> allVersionables = new HashSet<SiloedItemId<IVersionable>>();
        for (List<FileChange> next : this.changesByItem.values()) {
            for (FileChange nextChange : next) {
                UUID componentId = nextChange.getSiloedItemId().getComponentUUID();
                IItemType itemType = nextChange.getItemId().getItemType();
                SiloedItemId nextId = SiloedItemId.create((IItemType)itemType, (UUID)nextChange.getInitial().getPath().getParent().getItemUUID(), (UUID)componentId);
                if (!this.changesByItem.containsKey(nextId)) {
                    allVersionables.add((SiloedItemId<IVersionable>)nextId);
                }
                if (this.changesByItem.containsKey(nextId = SiloedItemId.create((IItemType)itemType, (UUID)nextChange.getFinal().getPath().getParent().getItemUUID(), (UUID)componentId))) continue;
                allVersionables.add((SiloedItemId<IVersionable>)nextId);
            }
        }
        this.fetchMoreSegments(allVersionables, monitor);
    }

    public VersionablePath computePath(SiloedItemId<IVersionable> siloedItemId, boolean beforePath, IProgressMonitor monitor) throws TeamRepositoryException {
        VersionablePath result = this.computePaths((Collection<SiloedItemId<IVersionable>>)Collections.singleton(siloedItemId), beforePath, monitor).get(siloedItemId);
        if (result == null) {
            throw new TeamRepositoryException("Item not found in configuration");
        }
        return result;
    }
}

