/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.queries;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.expression.SortCriteria;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.internal.queries.Messages;
import com.ibm.team.workitem.rcp.core.internal.queries.QueryViewColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryView {
    private ITeamRepository fRepository;
    private String fName;
    private QueryViewColumn[] fColumns;
    private QueryViewColumn[] fOriginalColumns;
    private UUID fId;
    private SortCriteria[] fSortCriteria;
    private String fIdentifier;
    private QueryView fDelegate;

    public QueryView(ITeamRepository repository, UUID id, String name, QueryViewColumn[] columns) {
        this.fRepository = repository;
        this.fId = id;
        this.fName = name;
        this.fOriginalColumns = columns;
        this.updateOrderedColumns(null);
    }

    public QueryView(ITeamRepository repository, String name, QueryViewColumn[] columns) {
        this(repository, UUID.generate(), name, columns);
    }

    public QueryView(ITeamRepository repository, String name, QueryViewColumn[] columns, SortCriteria[] sortCriteria) {
        this(repository, UUID.generate(), name, columns);
        this.fSortCriteria = sortCriteria;
    }

    public QueryView(ITeamRepository repository, QueryViewColumn[] columns) {
        this(repository, null, null, columns);
    }

    public boolean isAdhocView() {
        return this.fId == null;
    }

    public ITeamRepository getTeamRepository() {
        return this.fRepository;
    }

    public UUID getId() {
        return this.fId;
    }

    public void setIdentifier(String identifier) {
        this.fIdentifier = identifier;
    }

    public String getIdentifier() {
        return this.fIdentifier;
    }

    public String getName() {
        if (this.isAdhocView()) {
            return Messages.QueryView_UNSAVED_VIEW;
        }
        return this.fName;
    }

    public QueryViewColumn[] getColumns() {
        return this.fColumns;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setUpdateDelegate(QueryView delegate) {
        this.fDelegate = delegate;
    }

    public void setColumns(QueryViewColumn[] columns) {
        this.fOriginalColumns = columns;
        this.updateOrderedColumns(null);
        if (this.fDelegate != null) {
            this.fDelegate.setColumns(columns);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof QueryView && !((QueryView)object).isAdhocView()) {
            return ((QueryView)object).fId.equals((Object)this.fId);
        }
        return false;
    }

    public SortCriteria[] getSortCriteria() {
        if (this.fSortCriteria != null) {
            return this.fSortCriteria;
        }
        QueryViewColumn[] viewColumns = this.getColumns();
        ArrayList<QueryViewColumn> sortColumns = new ArrayList<QueryViewColumn>();
        int i = 0;
        while (i < viewColumns.length) {
            if (viewColumns[i].getSorting() != 0) {
                sortColumns.add(viewColumns[i]);
            }
            ++i;
        }
        QueryViewColumn[] orderedSortColumns = sortColumns.toArray(new QueryViewColumn[sortColumns.size()]);
        Arrays.sort(orderedSortColumns, new Comparator(){

            public int compare(Object o1, Object o2) {
                int c2;
                int c1 = ((QueryViewColumn)o1).getSortOrder();
                return c1 == (c2 = ((QueryViewColumn)o2).getSortOrder()) ? 0 : (c1 < c2 ? -1 : 1);
            }
        });
        if (orderedSortColumns.length == 0) {
            return new SortCriteria[]{new SortCriteria(IWorkItem.ID_PROPERTY, false)};
        }
        SortCriteria[] sortCriteria = new SortCriteria[orderedSortColumns.length];
        int i2 = 0;
        while (i2 < orderedSortColumns.length) {
            sortCriteria[i2] = new SortCriteria(orderedSortColumns[i2].getAttributeIdentifier(), orderedSortColumns[i2].getSorting() == 1);
            ++i2;
        }
        return sortCriteria;
    }

    public void setSorting(String attributeIdentifier, int sorting) {
        QueryViewColumn column = this.getColumn(attributeIdentifier);
        if (column != null) {
            int minSortOrder = this.getMinSortOrder();
            if (minSortOrder == Integer.MAX_VALUE) {
                column.setSortOrder(1);
            } else if (minSortOrder > 1) {
                column.setSortOrder(minSortOrder - 1);
            } else {
                int i = 0;
                while (i < this.fColumns.length) {
                    if (this.fColumns[i].getSorting() != 0) {
                        this.fColumns[i].setSortOrder(this.fColumns[i].getSortOrder() + 1);
                    }
                    ++i;
                }
                column.setSortOrder(1);
            }
            column.setSorting(sorting);
        }
    }

    public void removeSorting(String attributeIdentifier) {
        QueryViewColumn column = this.getColumn(attributeIdentifier);
        if (column != null) {
            column.setSorting(0);
            column.setSortOrder(0);
        }
    }

    public void toggleSorting(String attributeIdentifier) {
        QueryViewColumn column = this.getColumn(attributeIdentifier);
        if (column != null && column.getSorting() != 0) {
            column.setSorting(column.getSorting() == 1 ? 2 : 1);
        }
    }

    public QueryViewColumn getColumn(int index) {
        if (index >= 0 && index < this.fColumns.length) {
            return this.fColumns[index];
        }
        return null;
    }

    public QueryViewColumn getColumn(String attributeIdentifier) {
        int index = this.getColumnIndex(attributeIdentifier);
        if (index > -1) {
            return this.getColumn(index);
        }
        return null;
    }

    public int getColumnIndex(String attributeIdentifier) {
        int i = 0;
        while (i < this.fColumns.length) {
            if (this.fColumns[i].getAttributeIdentifier().equals(attributeIdentifier)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getMinSortOrder() {
        int sortOrder = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.fColumns.length) {
            if (this.fColumns[i].getSorting() != 0 && this.fColumns[i].getSortOrder() < sortOrder) {
                sortOrder = this.fColumns[i].getSortOrder();
            }
            ++i;
        }
        return sortOrder;
    }

    public QueryView getCopy() {
        return new QueryView(this.fRepository, this.fName, this.getCopy(this.fColumns), this.getCopy(this.fSortCriteria));
    }

    private SortCriteria[] getCopy(SortCriteria[] sortCriteria) {
        if (sortCriteria != null) {
            SortCriteria[] copy = new SortCriteria[sortCriteria.length];
            int i = 0;
            while (i < sortCriteria.length) {
                copy[i] = sortCriteria[i].copy();
                ++i;
            }
            return copy;
        }
        return null;
    }

    private QueryViewColumn[] getCopy(QueryViewColumn[] columns) {
        if (columns != null) {
            QueryViewColumn[] copy = new QueryViewColumn[columns.length];
            int i = 0;
            while (i < columns.length) {
                QueryViewColumn column = columns[i];
                copy[i] = new QueryViewColumn(column.getAttributeIdentifier(), column.isVisible(), column.getSorting(), column.getSortOrder(), column.getWidth());
                ++i;
            }
            return copy;
        }
        return null;
    }

    public void setColumnOrder(List<String> columnOrder) {
        this.updateOrderedColumns(columnOrder);
        if (this.fDelegate != null) {
            this.fDelegate.setColumnOrder(columnOrder);
        }
    }

    private void updateOrderedColumns(List<String> columnOrder) {
        if (this.fColumns == null || this.fColumns.length != this.fOriginalColumns.length) {
            this.fColumns = new QueryViewColumn[this.fOriginalColumns.length];
        }
        if (columnOrder == null || columnOrder.isEmpty()) {
            int i = 0;
            while (i < this.fOriginalColumns.length) {
                this.fColumns[i] = this.fOriginalColumns[i];
                ++i;
            }
        } else {
            int k = 0;
            int i = 0;
            while (i < columnOrder.size()) {
                QueryViewColumn column = this.getOriginalColumn(columnOrder.get(i));
                if (column != null && k < this.fColumns.length) {
                    this.fColumns[k] = column;
                    ++k;
                }
                ++i;
            }
        }
    }

    private QueryViewColumn getOriginalColumn(String columnId) {
        QueryViewColumn[] queryViewColumnArray = this.fOriginalColumns;
        int n = this.fOriginalColumns.length;
        int n2 = 0;
        while (n2 < n) {
            QueryViewColumn column = queryViewColumnArray[n2];
            if (columnId.equals(column.getAttributeIdentifier())) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    public void setSortCriteria(SortCriteria[] sortCriteria) {
        this.fSortCriteria = sortCriteria;
    }
}

