/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.xml;

import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentDescription;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.CommentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.LookupTable;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.Tokens;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReportHandler
extends DefaultHandler
implements Tokens {
    private final DateFormat fDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final DateFormat fAttachmentDateFormat = new SimpleDateFormat("MM/dd/yy HH:mm");
    private StringBuffer fBuffer;
    private ArrayList fAttachments = new ArrayList();
    private CommentData fComment = null;
    private AttachmentDescription fAttachment = null;
    protected ReportData fReport = null;

    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.fBuffer == null) {
            this.fBuffer = new StringBuffer();
        }
        this.fBuffer.append(ch, start, length);
    }

    protected final String getPCDATA() {
        if (this.fBuffer == null) {
            return "";
        }
        return this.fBuffer.toString().trim();
    }

    protected final void flushBuffer() {
        this.fBuffer = null;
    }

    protected final Date getDate() {
        try {
            return this.fDateFormat.parse(this.getPCDATA());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    protected final Date getAttachmentDate() {
        try {
            return this.fAttachmentDateFormat.parse(this.getPCDATA());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int token = LookupTable.get(qName);
        switch (token) {
            case 1: {
                String value = attributes.getValue("version");
                String urlbase = attributes.getValue("urlbase");
                this.fReport = new ReportData();
                this.fReport.set("version", value);
                this.fReport.set("urlbase", urlbase);
                break;
            }
            case 2: {
                String error = attributes.getValue("error");
                if (!"NotFound".equals(error)) break;
                this.fReport.notfound = true;
                break;
            }
            case 26: {
                this.fComment = new CommentData();
                break;
            }
            case 27: {
                this.fAttachment = new AttachmentDescription();
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String name = "".equals(localName) ? qName : localName;
        int token = LookupTable.get(name);
        switch (token) {
            case 3: {
                this.fReport.set("bug_id", this.getPCDATA());
                break;
            }
            case 4: {
                this.fReport.set("bug_status", this.getPCDATA());
                break;
            }
            case 5: {
                this.fReport.set("product", this.getPCDATA());
                break;
            }
            case 6: {
                this.fReport.set("priority", this.getPCDATA());
                break;
            }
            case 7: {
                this.fReport.set("version", this.getPCDATA());
                break;
            }
            case 8: {
                this.fReport.set("rep_platform", this.getPCDATA());
                break;
            }
            case 9: {
                this.fReport.set("assigned_to", this.getPCDATA());
                break;
            }
            case 10: {
                this.fReport.set("delta_ts", this.getPCDATA());
                break;
            }
            case 11: {
                this.fReport.set("component", this.getPCDATA());
                break;
            }
            case 12: {
                this.fReport.set("reporter", this.getPCDATA());
                break;
            }
            case 13: {
                this.fReport.set("target_milestone", this.getPCDATA());
                break;
            }
            case 14: {
                this.fReport.set("bug_severity", this.getPCDATA());
                break;
            }
            case 15: {
                this.fReport.set("creation_ts", this.getDate());
                break;
            }
            case 16: {
                this.fReport.set("qa_contact", this.getPCDATA());
                break;
            }
            case 17: {
                this.fReport.set("op_sys", this.getPCDATA());
                break;
            }
            case 18: {
                this.fReport.set("resolution", this.getPCDATA());
                break;
            }
            case 19: {
                this.fReport.set("bug_file_loc", this.getPCDATA());
                break;
            }
            case 20: {
                this.fReport.set("short_desc", this.getPCDATA());
                break;
            }
            case 21: {
                this.fReport.keywords.add(this.getPCDATA());
                break;
            }
            case 22: {
                this.fReport.set("status_whiteboard", this.getPCDATA());
                break;
            }
            case 23: {
                this.fReport.dependsOn.add(this.getPCDATA());
                break;
            }
            case 24: {
                this.fReport.blocks.add(this.getPCDATA());
                break;
            }
            case 25: {
                this.fReport.ccs.add(this.getPCDATA());
                break;
            }
            case 26: {
                this.fReport.comments.add(this.fComment);
                this.fComment = null;
                break;
            }
            case 28: {
                this.fComment.set("0", this.getPCDATA());
                break;
            }
            case 29: {
                this.fComment.set("1", this.getDate());
                break;
            }
            case 30: {
                this.fComment.set("2", this.getPCDATA());
                break;
            }
            case 27: {
                this.fAttachments.add(this.fAttachment);
                this.fAttachment = null;
                break;
            }
            case 31: {
                this.fAttachment.set("0", this.getPCDATA());
                break;
            }
            case 32: {
                this.fAttachment.set("1", this.getAttachmentDate());
                break;
            }
            case 33: {
                this.fAttachment.set("2", this.getPCDATA());
                break;
            }
            case 36: {
                this.fAttachment.set("4", this.getPCDATA());
                break;
            }
            case 1: {
                this.fReport.attachments = this.fAttachments;
                for (AttachmentDescription attachment : this.fAttachments) {
                    String id = attachment.getString("0").trim();
                    String pattern = "(id=" + id + ")";
                    attachment.set("3", false);
                    CommentData associatedComment = null;
                    for (CommentData comment : this.fReport.comments) {
                        if (comment.getString("2").indexOf(pattern) < 0) continue;
                        associatedComment = comment;
                        boolean obsolete = !comment.getDate("1").equals(attachment.getDate("1"));
                        attachment.set("3", obsolete);
                        break;
                    }
                    if (associatedComment == null) continue;
                    associatedComment.attachmentDesc = attachment;
                }
            }
            case 2: {
                break;
            }
            default: {
                this.fReport.set(name, this.getPCDATA());
            }
        }
        this.flushBuffer();
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (!systemId.endsWith("bugzilla.dtd")) {
            return null;
        }
        return new InputSource(this.getClass().getResourceAsStream("bugzilla.dtd"));
    }

    public ReportData getReportData() {
        return this.fReport;
    }
}

