/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.xml;

import com.ibm.team.workitem.rcp.core.internal.bugzilla.http.QueryData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Status;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QueryHandler
extends DefaultHandler {
    Stack<String> elementStack = new Stack();
    public static final String RDF_TAG = "RDF";
    public static final String RESULT_TAG = "bz:result";
    public static final String BUG_LIST_TAG = "bz:bugs";
    public static final String BUG_TAG = "bz:bug";
    public static final String BUG_ID_TAG = "bz:id";
    public static final String BUG_SUMMARY_TAG = "bz:summary";
    public static final String BUG_OPEN_DATE_TAG = "bz:opendate";
    public static final String BUG_SEVERITY_TAG = "bz:severity";
    public static final String BUG_PRIORITY_TAG = "bz:priority";
    public static final String BUG_OWNER_TAG = "bz:owner";
    public static final String BUG_STATUS_TAG = "bz:status";
    public static final String BUG_TARGET_MILESTONE_TAG = "bz:target_milestone";
    public static final String ABOUT_FIELD = "about";
    public static final String XMLNS_FIELD = "xmlns";
    public static final String BUG_XMLNS_FIELD = "xmlns:bz";
    public static final String EXPECTED_XMLNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String EXPECTED_BUG_XMLNS = "http://www.bugzilla.org/rdf#";
    public static final Map<String, String> tag2data = new HashMap<String, String>();
    private ReportData currentBugData;
    private QueryData data = new QueryData();
    private StringBuffer textBuffer = new StringBuffer();

    static {
        tag2data.put(BUG_ID_TAG, "bug_id");
        tag2data.put(BUG_SUMMARY_TAG, "short_desc");
        tag2data.put(BUG_SEVERITY_TAG, "bug_severity");
        tag2data.put(BUG_PRIORITY_TAG, "priority");
        tag2data.put(BUG_OWNER_TAG, "assigned_to");
        tag2data.put(BUG_STATUS_TAG, "bug_status");
        tag2data.put(BUG_TARGET_MILESTONE_TAG, "target_milestone");
    }

    public QueryData getQueryData() {
        return this.data;
    }

    private String getElementName(String localName, String qName) {
        if (localName != null && localName.length() > 0) {
            return localName;
        }
        return qName;
    }

    private void addError(Status status) {
        this.data.addError(status);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name = this.getElementName(localName, qName);
        this.elementStack.push(name);
        if (name.equals(RDF_TAG)) {
            this.validateNamespaces(attributes);
        } else if (name.equals(BUG_TAG)) {
            this.currentBugData = new ReportData();
        } else if (this.isBugDataField(name)) {
            this.clearText();
        }
    }

    private boolean isBugDataField(String name) {
        return tag2data.containsKey(name);
    }

    private String getDataKey(String name) {
        return tag2data.get(name);
    }

    private void validateNamespaces(Attributes attributes) {
        String bns;
        String ns = attributes.getValue(XMLNS_FIELD);
        if (!ns.equals(EXPECTED_XMLNS)) {
            this.addError(new Status(4, "com.ibm.team.workitem.rcp.core", 0, "Expected xml namespace http://www.w3.org/1999/02/22-rdf-syntax-ns# but was " + ns, null));
        }
        if (!(bns = attributes.getValue(BUG_XMLNS_FIELD)).equals(EXPECTED_BUG_XMLNS)) {
            this.addError(new Status(4, "com.ibm.team.workitem.rcp.core", 0, "Expected bug namespace http://www.bugzilla.org/rdf# but was " + bns, null));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String name = this.getElementName(localName, qName);
        if (this.elementStack.peek().equals(name)) {
            this.elementStack.pop();
        } else {
            this.addError(new Status(4, "com.ibm.team.workitem.rcp.core", 0, "Expected tag " + this.elementStack.peek() + " but was " + name, null));
        }
        if (name.equals(BUG_TAG)) {
            if (this.currentBugData != null && this.currentBugData.getString("bug_id") != null) {
                this.data.addBug(this.currentBugData);
                this.currentBugData = null;
            }
        } else if (this.isBugDataField(name) && this.currentBugData != null) {
            String text = this.getText();
            this.currentBugData.set(this.getDataKey(name), text);
        }
    }

    private void clearText() {
        this.textBuffer.setLength(0);
    }

    private String getText() {
        return this.textBuffer.toString();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.textBuffer.append(ch, start, length);
    }
}

