/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.SimpleMapper;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TimestampMapper
extends SimpleMapper {
    private static List<DateFormat> fgDateFormats = new ArrayList<DateFormat>();

    static {
        ArrayList<ULocale> locales = new ArrayList<ULocale>();
        locales.add(ULocale.getDefault());
        if (!ULocale.getDefault().equals((Object)ULocale.US)) {
            locales.add(ULocale.US);
        }
        for (ULocale locale : locales) {
            for (int dateStyle : Arrays.asList(0, 1, 2, 3)) {
                for (int timeStyle : Arrays.asList(0, 1, 2, 3)) {
                    fgDateFormats.add(DateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (ULocale)locale));
                }
                fgDateFormats.add(DateFormat.getDateInstance((int)dateStyle, (ULocale)locale));
            }
        }
        fgDateFormats.add((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm"));
        fgDateFormats.add((DateFormat)new SimpleDateFormat("MM/dd/yy HH:mm"));
    }

    public TimestampMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    protected Object findValue(String valueId) {
        if (valueId == null || valueId.length() == 0) {
            return null;
        }
        Date date = this.parseDate(valueId, new ParsePosition(0));
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    protected boolean isAccurate(BugzillaMapping.ValueMapping valueMapping, String valueId) {
        if (valueMapping != null && !valueMapping.isAccurate()) {
            return false;
        }
        if (valueId == null || valueId.length() == 0) {
            return true;
        }
        ParsePosition position = new ParsePosition(0);
        this.parseDate(valueId, position);
        return position.getIndex() == valueId.length();
    }

    private Date parseDate(String valueId, ParsePosition current) {
        ParsePosition bestPosition = new ParsePosition(current.getIndex());
        Date bestValue = null;
        for (DateFormat format : fgDateFormats) {
            ParsePosition position = new ParsePosition(0);
            Date value = format.parse(valueId, position);
            if (position.getIndex() <= bestPosition.getIndex()) continue;
            bestPosition = position;
            bestValue = value;
            if (bestPosition.getIndex() == valueId.length()) break;
        }
        current.setIndex(bestPosition.getIndex());
        current.setErrorIndex(bestPosition.getErrorIndex());
        return bestValue;
    }
}

