/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.SimpleMapper;
import java.text.ParsePosition;

public class NumberMapper
extends SimpleMapper {
    public NumberMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    protected Object findValue(String valueId) {
        if (valueId == null || valueId.length() == 0) {
            return this.getNullValue();
        }
        Number value = this.parseNumber(valueId);
        if (value == null) {
            return this.getNullValue();
        }
        if ("long".equals(this.getAttribute().getAttributeType())) {
            return value.longValue();
        }
        return value.intValue();
    }

    private Number getNullValue() {
        if ("long".equals(this.getAttribute().getAttributeType())) {
            return 0L;
        }
        return 0;
    }

    protected Number parseNumber(String valueId) {
        NumberFormat format1 = NumberFormat.getNumberInstance();
        ParsePosition position1 = new ParsePosition(0);
        Number value1 = format1.parse(valueId, position1);
        if (ULocale.US.equals((Object)ULocale.getDefault())) {
            return value1;
        }
        NumberFormat format2 = NumberFormat.getNumberInstance((ULocale)ULocale.US);
        ParsePosition position2 = new ParsePosition(0);
        Number value2 = format2.parse(valueId, position2);
        if (position1.getIndex() >= position2.getIndex()) {
            return value1;
        }
        return value2;
    }

    protected boolean isAccurate(BugzillaMapping.ValueMapping valueMapping, String valueId) {
        if (valueMapping != null && !valueMapping.isAccurate()) {
            return false;
        }
        if (valueId == null || valueId.length() == 0) {
            return true;
        }
        return this.parsesAccurately(valueId);
    }

    private boolean parsesAccurately(String valueId) {
        NumberFormat format1 = NumberFormat.getNumberInstance();
        ParsePosition position1 = new ParsePosition(0);
        format1.parse(valueId, position1);
        if (position1.getIndex() == valueId.length()) {
            return true;
        }
        if (ULocale.US.equals((Object)ULocale.getDefault())) {
            return false;
        }
        NumberFormat format2 = NumberFormat.getNumberInstance((ULocale)ULocale.US);
        ParsePosition position2 = new ParsePosition(0);
        format2.parse(valueId, position2);
        return position2.getIndex() == valueId.length();
    }
}

