/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.AttributeMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationMapper
extends AttributeMapper {
    private IAttribute fAttribute;
    private List<String> fFallbackPrefix;
    private Map<String, IIterationHandle> fIterations = new HashMap<String, IIterationHandle>();

    public IterationMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    @Override
    public XMLString copy(IWorkItem workItem, ReportData data, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectArea = workItem.getProjectArea();
        this.invalidateCachedValues(projectArea);
        if (this.fAttribute == null) {
            this.fAttribute = this.getAttributeMapping().resolveTargetAttribute(projectArea, monitor);
        }
        if (this.fAttribute == null) {
            return null;
        }
        String id = data.getString(this.getAttributeMapping().getSourceId());
        if (id == null) {
            return null;
        }
        List<String> idPath = this.findIdPath(projectArea, id, monitor);
        if (idPath == null) {
            return null;
        }
        IIterationHandle iteration = this.findOrCreateIteration(projectArea, idPath, monitor);
        if (!workItem.hasAttribute(this.fAttribute)) {
            workItem.addCustomAttribute(this.fAttribute);
        }
        workItem.setValue(this.fAttribute, (Object)iteration);
        return null;
    }

    private void invalidateCachedValues(IProjectAreaHandle projectArea) {
        if (this.fAttribute != null && !this.fAttribute.getProjectArea().sameItemId((IItemHandle)projectArea)) {
            this.fAttribute = null;
            this.fFallbackPrefix = null;
            this.fIterations.clear();
        }
    }

    private List<String> findIdPath(IProjectAreaHandle projectArea, String id, IProgressMonitor monitor) throws TeamRepositoryException {
        List<String> idPath = this.getIdPath(id);
        if (idPath != null) {
            return idPath;
        }
        return this.findFallbackIdPath(projectArea, id, monitor);
    }

    private List<String> getIdPath(String id) {
        BugzillaMapping.ValueMapping valueMapping = this.getValueMapping(id);
        if (valueMapping != null) {
            return Arrays.asList(valueMapping.getTargetId().split("/"));
        }
        valueMapping = this.getValueMapping("");
        if (valueMapping != null) {
            return Arrays.asList((String.valueOf(valueMapping.getTargetId()) + "/" + id).split("/"));
        }
        return null;
    }

    private List<String> findFallbackIdPath(IProjectAreaHandle projectArea, String id, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fFallbackPrefix == null) {
            IIteration[] currentIterations;
            ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IProcessItemService processService = (IProcessItemService)teamRepository.getClientLibrary(IProcessItemService.class);
            IDevelopmentLine developmentLine = auditableClient.findDefaultDevelopmentLine(projectArea, monitor);
            if (developmentLine == null) {
                IProjectArea item = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)projectArea, ItemProfile.PROJECT_AREA_DEFAULT, monitor);
                IDevelopmentLineHandle[] developmentLines = item.getDevelopmentLines();
                if (developmentLines.length == 0) {
                    return null;
                }
                developmentLine = (IDevelopmentLine)auditableClient.resolveAuditable((IAuditableHandle)developmentLines[0], ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
            }
            if ((currentIterations = processService.getCurrentIterations((IDevelopmentLineHandle)developmentLine, monitor)).length == 0) {
                return null;
            }
            IIteration iteration = currentIterations[0];
            this.fFallbackPrefix = new ArrayList<String>();
            this.fFallbackPrefix.add(developmentLine.getId());
            this.fFallbackPrefix.add(iteration.getId());
        }
        ArrayList<String> idPath = new ArrayList<String>(this.fFallbackPrefix);
        idPath.add(id);
        return idPath;
    }

    private IIterationHandle findOrCreateIteration(IProjectAreaHandle projectArea, List<String> idPath, IProgressMonitor monitor) throws TeamRepositoryException {
        if (idPath.isEmpty()) {
            return null;
        }
        IIterationHandle iteration = this.fIterations.get(this.getPathAsString(idPath));
        if (iteration != null) {
            return iteration;
        }
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IDevelopmentLine developmentLine = this.findDevelopmentLine(projectArea, idPath.get(0), monitor);
        if (developmentLine == null) {
            return null;
        }
        List children = auditableClient.resolveAuditables(Arrays.asList(developmentLine.getIterations()), ItemProfile.ITERATION_DEFAULT, monitor);
        IIteration parent = null;
        for (String id : idPath.subList(1, idPath.size())) {
            IIteration current;
            IIteration iIteration = current = children != null ? this.findIteration(children, id) : null;
            if (current != null) {
                parent = current;
                children = auditableClient.resolveAuditables(Arrays.asList(current.getChildren()), ItemProfile.ITERATION_DEFAULT, monitor);
                continue;
            }
            children = null;
            parent = parent == null ? this.createIteration(developmentLine, id, monitor) : this.createIteration(parent, id, monitor);
        }
        iteration = parent != null ? (IIterationHandle)parent.getItemHandle() : null;
        this.fIterations.put(this.getPathAsString(idPath), iteration);
        return iteration;
    }

    private IIteration createIteration(IDevelopmentLine parent, String id, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)parent.getOrigin();
        IProcessItemService processService = (IProcessItemService)teamRepository.getClientLibrary(IProcessItemService.class);
        IIteration iteration = this.createIteration(processService, (IDevelopmentLineHandle)parent.getItemHandle(), null, id);
        parent = (IDevelopmentLine)parent.getWorkingCopy();
        parent.addIteration((IIterationHandle)iteration);
        return (IIteration)processService.save(new IProcessItem[]{parent, iteration}, monitor)[1];
    }

    private IIteration createIteration(IIteration parent, String id, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)parent.getOrigin();
        IProcessItemService processService = (IProcessItemService)teamRepository.getClientLibrary(IProcessItemService.class);
        IIteration iteration = this.createIteration(processService, parent.getDevelopmentLine(), parent, id);
        parent = (IIteration)parent.getWorkingCopy();
        parent.addChild((IIterationHandle)iteration);
        return (IIteration)processService.save(new IProcessItem[]{parent, iteration}, monitor)[1];
    }

    private IIteration createIteration(IProcessItemService processService, IDevelopmentLineHandle developmentLine, IIteration parent, String id) {
        IIteration iteration = processService.createIteration();
        iteration.setDevelopmentLine(developmentLine);
        iteration.setParent((IIterationHandle)parent);
        iteration.setId(id);
        iteration.setName(id);
        return iteration;
    }

    private IIteration findIteration(List<IIteration> iterations, String id) {
        for (IIteration current : iterations) {
            if (!current.getId().equals(id)) continue;
            return current;
        }
        return null;
    }

    private IDevelopmentLine findDevelopmentLine(IProjectAreaHandle projectArea, String lineId, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IProjectArea item = (IProjectArea)auditableClient.resolveAuditable((IAuditableHandle)projectArea, ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        List developmentLines = auditableClient.resolveAuditables(Arrays.asList(item.getDevelopmentLines()), ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        for (IDevelopmentLine developmentLine : developmentLines) {
            if (!developmentLine.getId().equals(lineId)) continue;
            return developmentLine;
        }
        return null;
    }

    private String getPathAsString(List<String> path) {
        StringBuilder builder = new StringBuilder();
        for (String segment : path) {
            builder.append("/");
            builder.append(segment);
        }
        return builder.toString();
    }
}

