/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.AuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.AttributeMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ContributorMapper
extends AttributeMapper {
    private Map<String, IContributorHandle> fContributorsByEmail = new HashMap<String, IContributorHandle>();
    private Map<String, IContributorHandle> fContributorsByUserId = new HashMap<String, IContributorHandle>();
    private IAttribute fAttribute;

    public ContributorMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    public XMLString copy(IWorkItem workItem, ReportData data, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        String email;
        ITeamRepository teamRepository = (ITeamRepository)workItem.getOrigin();
        if (this.fAttribute == null || !this.fAttribute.getProjectArea().sameItemId((IItemHandle)workItem.getProjectArea())) {
            this.fAttribute = this.getAttributeMapping().resolveTargetAttribute(workItem.getProjectArea(), monitor);
        }
        if (this.fAttribute == null) {
            return null;
        }
        if (this.getAttributeMapping().getSourceId().equals("cc")) {
            for (String cc : data.ccs) {
                IContributorHandle handle = this.findContributor(teamRepository, cc, monitor);
                if (handle == null) continue;
                workItem.getSubscriptions().add(handle);
            }
        }
        if ((email = data.getString(this.getAttributeMapping().getSourceId())) == null) {
            return null;
        }
        IContributorHandle handle = this.findContributor(teamRepository, email, monitor);
        if (handle == null) {
            return null;
        }
        if (!workItem.hasAttribute(this.fAttribute)) {
            workItem.addCustomAttribute(this.fAttribute);
        }
        workItem.setValue(this.fAttribute, (Object)handle);
        return null;
    }

    public IContributorHandle findContributor(ITeamRepository teamRepository, String email, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        BugzillaMapping.ValueMapping valueMapping = this.getValueMapping(email);
        String userId = valueMapping != null ? valueMapping.getTargetId() : email;
        if (userId.length() == 0) {
            return null;
        }
        IContributorHandle handle = this.fContributorsByUserId.get(userId);
        if (handle != null) {
            return handle;
        }
        handle = this.fContributorsByEmail.get(email);
        if (handle != null) {
            return handle;
        }
        try {
            IContributor contributor = teamRepository.contributorManager().fetchContributorByUserId(userId, monitor);
            return this.cache(contributor);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            ItemQueryIterator iter = WorkItemQueries.contributorByEmail((IAuditableCommon)auditableClient, (String)email);
            if (iter.hasNext(monitor)) {
                IContributor contributor = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)iter.next(monitor), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                return this.cache(contributor);
            }
            IContributor contributor = (IContributor)auditableClient.createAuditable(IContributor.ITEM_TYPE);
            contributor.setName(this.inferNameFromEmailAdress(email));
            contributor.setEmailAddress(email);
            contributor.setUserId(userId);
            contributor = teamRepository.contributorManager().saveContributor(contributor, monitor);
            ((AuditableClient)auditableClient).updateFromItemManager(Collections.singletonList(contributor), monitor);
            return this.cache(contributor);
        }
    }

    private IContributorHandle cache(IContributor contributor) {
        IContributorHandle handle = (IContributorHandle)contributor.getItemHandle();
        this.fContributorsByEmail.put(contributor.getEmailAddress(), handle);
        this.fContributorsByUserId.put(contributor.getUserId(), handle);
        return handle;
    }

    private String inferNameFromEmailAdress(String email) {
        int i = email.indexOf(64);
        String string = i <= 0 ? email : email.substring(0, i);
        String inferredName = this.capitalizeFirstLetter(string);
        String[] name = inferredName.split("_");
        if (name.length == 2) {
            int isDoubleName = name[0].indexOf("-");
            if (isDoubleName > 0) {
                int firstLetterOfSecondName = isDoubleName + 1;
                name[0] = String.valueOf(name[0].substring(0, firstLetterOfSecondName)) + this.capitalizeFirstLetter(name[0].substring(firstLetterOfSecondName));
            }
            inferredName = String.valueOf(name[0]) + " " + this.capitalizeFirstLetter(name[1]);
        }
        return inferredName;
    }

    private String capitalizeFirstLetter(String inferredName) {
        return String.valueOf(inferredName.substring(0, 1).toUpperCase()) + inferredName.substring(1);
    }

    public void record(ReportData data, IProgressMonitor monitor) {
        if ("cc".equals(this.getAttributeMapping().getSourceId())) {
            for (String cc : data.ccs) {
                if (cc == null || cc.length() <= 0) continue;
                if (this.getAttributeTypeMapping().getTargetId().length() > 0) {
                    this.getAttributeTypeMapping().recordValueMapping(cc);
                    continue;
                }
                this.getAttributeMapping().recordValueMapping(cc);
            }
            return;
        }
        super.record(data, monitor);
    }
}

